/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;

public class CapabilityWarning
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.WARNING_DEV_CONTROL;

    protected CapabilityWarning(int id, Resource parent) {
        super(id, parent);
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(WarningType.class, (Object)new WarningTypeSerializer());
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case START: {
                command = (Command)gson.fromJson(commandParams, StartWarning.class);
                break;
            }
            case STOP: {
                command = (Command)gson.fromJson(commandParams, StopWarning.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class StopWarning
    extends Command<CommandId> {
        public StopWarning() {
            super(CommandId.STOP);
        }
    }

    public static class StartWarning
    extends Command<CommandId> {
        @SerializedName(value="warningType")
        public WarningType warningType;

        public StartWarning() {
            super(CommandId.START);
        }

        public StartWarning(WarningType warningType) {
            this();
            this.warningType = warningType;
        }
    }

    public static final class WarningType {
        public static final int BURGLAR = 0;
        public static final int FIRE = 1;
        public static final int EMERGENCY = 2;
        public static final int POLICE_PANIC = 3;
        public static final int FIRE_PANIC = 4;
        public static final int EMERGENCY_PANIC = 5;
        private final int warningType;

        public WarningType(int warningType) {
            this.warningType = warningType;
        }

        public int rawValue() {
            return this.warningType;
        }

        public static WarningType burglar() {
            return new WarningType(0);
        }

        public static WarningType fire() {
            return new WarningType(1);
        }

        public static WarningType emergency() {
            return new WarningType(2);
        }

        public static WarningType policePanic() {
            return new WarningType(3);
        }

        public static WarningType firePanic() {
            return new WarningType(4);
        }

        public static WarningType emergencyPanic() {
            return new WarningType(5);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WarningType that = (WarningType)o;
            return this.warningType == that.warningType;
        }

        public int hashCode() {
            return this.warningType;
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        START,
        STOP;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        STATE;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }

    private static class WarningTypeSerializer
    implements JsonSerializer<WarningType>,
    JsonDeserializer<WarningType> {
        private WarningTypeSerializer() {
        }

        public WarningType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new WarningType(json.getAsInt());
        }

        public JsonElement serialize(WarningType warningType, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)warningType.rawValue());
        }
    }
}

