/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.CallbackMultiplexer;
import buzz.getcoco.iot.CallbacksInterface;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityDoorLock;
import buzz.getcoco.iot.CapabilityHvacControl;
import buzz.getcoco.iot.CapabilityKeyPressSensing;
import buzz.getcoco.iot.CapabilityMediaStreaming;
import buzz.getcoco.iot.CapabilityMotorControl;
import buzz.getcoco.iot.CapabilityRemoteControl;
import buzz.getcoco.iot.CapabilityStorageControl;
import buzz.getcoco.iot.CapabilityTunnel;
import buzz.getcoco.iot.CapabilityWarning;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Creator;
import buzz.getcoco.iot.DeepDeserializer;
import buzz.getcoco.iot.DefaultCallbacksHandler;
import buzz.getcoco.iot.DefaultCreator;
import buzz.getcoco.iot.DefaultNativeHandler;
import buzz.getcoco.iot.Factory;
import buzz.getcoco.iot.InfoRequest;
import buzz.getcoco.iot.InfoResponse;
import buzz.getcoco.iot.Listener;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.NativeCallbacksInterface;
import buzz.getcoco.iot.NativeInterface;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Parameter;
import buzz.getcoco.iot.PlatformCallbacksHandler;
import buzz.getcoco.iot.PlatformInterface;
import buzz.getcoco.iot.RadioProtocol;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.ResourceAction;
import buzz.getcoco.iot.ResourceCondition;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.ScheduleCondition;
import buzz.getcoco.iot.StorageContentMetadata;
import buzz.getcoco.iot.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CocoClient {
    private static CocoClient instance = null;
    private final Map<String, Network> networkMap;
    private NativeInterface nativeHandler;
    private NativeCallbacksInterface callbacksHandler;

    private CocoClient(PlatformInterface platformInterface, NativeInterface nativeHandler, NativeCallbacksInterface callbackHandler, ConnectivityTimers timers) throws IllegalArgumentException {
        String cwdPath = platformInterface.getCwdPath();
        String clientId = platformInterface.getClientId();
        String appAccessList = platformInterface.getAppAccessList();
        String downloadPath = platformInterface.getDownloadPath();
        this.nativeHandler = nativeHandler;
        this.callbacksHandler = callbackHandler;
        this.networkMap = new ConcurrentHashMap<String, Network>();
        Command.init();
        Capability.init();
        Resource.init();
        ResourceAction.init();
        Attribute.init();
        ScheduleCondition.init();
        CapabilityDoorLock.init();
        CapabilityWarning.init();
        ResourceCondition.init();
        Scene.init();
        Rule.init();
        Parameter.init();
        InfoRequest.init();
        InfoResponse.init();
        CapabilityTunnel.init();
        StorageContentMetadata.init();
        CapabilityMotorControl.init();
        RadioProtocol.init();
        CapabilityStorageControl.init();
        CapabilityMediaStreaming.init();
        CapabilityHvacControl.init();
        CapabilityRemoteControl.init();
        CapabilityKeyPressSensing.init();
        try {
            this.getNativeHandler().init(cwdPath, appAccessList, clientId, downloadPath, timers);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    void setNativeHandler(NativeInterface nativeHandler) {
        this.nativeHandler = nativeHandler;
    }

    void setCallbacksHandler(NativeCallbacksInterface callbacksHandler) {
        this.callbacksHandler = callbacksHandler;
    }

    NativeInterface getNativeHandler() {
        return this.nativeHandler;
    }

    NativeCallbacksInterface getCallbacksHandler() {
        return this.callbacksHandler;
    }

    public String getVersionInfo() {
        return this.getNativeHandler().getVersion();
    }

    public void clearSubscriptions() {
        CallbackMultiplexer.getInstance().removeAllExternalSubscribers();
    }

    public void addSubscription(CallbacksInterface nativeCallbacks) {
        CallbackMultiplexer.getInstance().addSubscription(nativeCallbacks);
    }

    public void removeSubscription(CallbacksInterface nativeCallbacks) {
        CallbackMultiplexer.getInstance().removeSubscription(nativeCallbacks);
    }

    public void setListener(PlatformInterface listener) {
        PlatformCallbacksHandler.getInstance().setListener(listener);
    }

    public void invalidateAccessToken() {
        this.getNativeHandler().invalidateAccessToken();
    }

    public static CocoClient getInstance() {
        return instance;
    }

    public Network[] getSavedNetworks() {
        return this.getNativeHandler().getSavedNetworks();
    }

    public void getAllNetworks(NetworkListListener listener) {
        this.getNativeHandler().getAllNetworks(listener);
    }

    public Network restoreNetworkState(String jsonNetworkState) {
        if (null == jsonNetworkState) {
            return null;
        }
        Network network = DeepDeserializer.deserialize(jsonNetworkState);
        if (this.containsNetwork(network.getId())) {
            throw new IllegalArgumentException("already deserialized or connection initiated");
        }
        this.internalAddNetwork(network);
        return network;
    }

    public void setTokens(String response) {
        this.getNativeHandler().setTokens(response);
    }

    public void getAccessTokens(AccessTokensListener listener) {
        this.getNativeHandler().getAccessTokens(listener);
    }

    public Map<String, Network> getNetworkMap() {
        return this.networkMap;
    }

    public boolean containsNetwork(String networkId) {
        return this.getNetworkMap().containsKey(networkId);
    }

    protected void internalAddNetwork(Network network) {
        this.getNetworkMap().put(network.getId(), network);
    }

    protected void internalRemoveNetwork(String networkId) {
        this.getNetworkMap().remove(networkId);
    }

    protected void clearNetworks() {
        this.getNetworkMap().clear();
    }

    public <T extends Network> T getNetwork(String networkId) {
        return (T)((Network)Utils.castUp(this.getNetworkMap().get(networkId)));
    }

    public void setConnectivityMode(ConnectivityMode mode) {
        if (null == mode) {
            throw new NullPointerException("mode cannot be null");
        }
        this.getNativeHandler().setConnectivityMode(mode);
    }

    public void informNetworkChange() {
        this.getNativeHandler().informNetworkChange();
    }

    public static interface AccessTokensListener
    extends Listener {
        public void onResponse(String var1, Throwable var2);
    }

    public static interface NetworkListListener
    extends Listener {
        public void onResponse(List<Network> var1, Throwable var2);
    }

    public static class Configurator {
        private PlatformInterface platform = null;
        private final Set<CallbacksInterface> additionalCallbacks = new HashSet<CallbacksInterface>();
        private NativeInterface nativeHandler;
        private NativeCallbacksInterface callbackHandler;
        private Creator creator = new DefaultCreator(){};
        private Log.Logger logger = new Log.Logger(){};
        private ConnectivityTimers timers = new ConnectivityTimers();
        private long defaultCommandTimeout = Command.defaultTimeOut;
        private int clearOnNetworkStates = Network.clearNetworkForState;

        Configurator setNativeHandler(NativeInterface nativeHandler) {
            this.nativeHandler = nativeHandler;
            return this;
        }

        Configurator setCallbackHandler(NativeCallbacksInterface callbackHandler) {
            this.callbackHandler = callbackHandler;
            return this;
        }

        public Configurator clearNetworkForStates(Network.State ... states) {
            this.clearOnNetworkStates = Network.createClearOnDisconnectionFlag(states);
            return this;
        }

        public Configurator withCreator(Creator creator) {
            this.creator = Objects.requireNonNull(creator);
            return this;
        }

        public Configurator withLogger(Log.Logger logger) {
            this.logger = Objects.requireNonNull(logger);
            return this;
        }

        public Configurator withPlatform(PlatformInterface platform) {
            this.platform = platform;
            return this;
        }

        public Configurator withTimers(ConnectivityTimers timers) {
            this.timers = timers;
            return this;
        }

        public Configurator withDefaultCommandTimeout(long timeout) {
            this.defaultCommandTimeout = timeout;
            return this;
        }

        public Configurator addCallbackListener(CallbacksInterface listener) {
            this.additionalCallbacks.add(listener);
            return this;
        }

        public Configurator removeCallbackListener(CallbacksInterface listener) {
            this.additionalCallbacks.remove(listener);
            return this;
        }

        public CocoClient configure() {
            if (null != instance) {
                throw new IllegalStateException("CocoClient already initialized, CocoClient is a singleton and it is being instantiated multiple times");
            }
            Objects.requireNonNull(this.platform);
            Factory.creator = this.creator;
            Log.logger = this.logger;
            Network.clearNetworkForState = this.clearOnNetworkStates;
            Command.defaultTimeOut = this.defaultCommandTimeout;
            this.nativeHandler = null == this.nativeHandler ? new DefaultNativeHandler() : this.nativeHandler;
            this.callbackHandler = null == this.callbackHandler ? new DefaultCallbacksHandler() : this.callbackHandler;
            this.timers = null == this.timers ? new ConnectivityTimers() : this.timers;
            instance = new CocoClient(this.platform, this.nativeHandler, this.callbackHandler, this.timers);
            instance.setListener(this.platform);
            instance.clearSubscriptions();
            for (CallbacksInterface listener : this.additionalCallbacks) {
                instance.addSubscription(listener);
            }
            return instance;
        }
    }

    public static enum ConnectivityMode {
        FOREGROUND,
        BACKGROUND;

        private static final int offset = 0;

        public int getInt() {
            return this.ordinal() + 0;
        }
    }

    public static final class ConnectivityTimers {
        public static final long DEFAULT_FAST_RETRY_DURATION = 20L;
        public static final long DEFAULT_BACKGROUND_MAX_RETRY_PERIOD = 600L;
        public static final long DEFAULT_FOREGROUND_MAX_RETRY_PERIOD = 30L;
        public static final long DEFAULT_KEEP_ALIVE_TIMEOUT = 5L;
        public static final long DEFAULT_KEEP_ALIVE_INTERVAL = 10L;
        final long fastRetryDuration;
        final long backgroundMaxRetryPeriod;
        final long foregroundMaxRetryPeriod;
        final long keepAliveInterval;
        final long keepAliveTimeout;

        public ConnectivityTimers() {
            this(20L, 600L, 30L, 10L, 5L);
        }

        public ConnectivityTimers(long fastRetryDuration, long backgroundMaxRetryPeriod, long foregroundMaxRetryPeriod, long keepAliveInterval, long keepAliveTimeout) {
            this.fastRetryDuration = fastRetryDuration;
            this.backgroundMaxRetryPeriod = backgroundMaxRetryPeriod;
            this.foregroundMaxRetryPeriod = foregroundMaxRetryPeriod;
            this.keepAliveInterval = keepAliveInterval;
            this.keepAliveTimeout = keepAliveTimeout;
        }

        public ConnectivityTimers toFastRetryDuration(long fastRetryDuration) {
            return new ConnectivityTimers(fastRetryDuration, this.backgroundMaxRetryPeriod, this.foregroundMaxRetryPeriod, this.keepAliveInterval, this.keepAliveTimeout);
        }

        public ConnectivityTimers toBackgroundMaxRetryPeriod(long backgroundMaxRetryPeriod) {
            return new ConnectivityTimers(this.fastRetryDuration, backgroundMaxRetryPeriod, this.foregroundMaxRetryPeriod, this.keepAliveInterval, this.keepAliveTimeout);
        }

        public ConnectivityTimers toForegroundMaxRetryPeriod(long foregroundMaxRetryPeriod) {
            return new ConnectivityTimers(this.fastRetryDuration, this.backgroundMaxRetryPeriod, foregroundMaxRetryPeriod, this.keepAliveInterval, this.keepAliveTimeout);
        }

        public ConnectivityTimers toKeepAliveInterval(long keepAliveInterval) {
            return new ConnectivityTimers(this.fastRetryDuration, this.backgroundMaxRetryPeriod, this.foregroundMaxRetryPeriod, keepAliveInterval, this.keepAliveTimeout);
        }

        public ConnectivityTimers toKeepAliveTimeout(long keepAliveTimeout) {
            return new ConnectivityTimers(this.fastRetryDuration, this.backgroundMaxRetryPeriod, this.foregroundMaxRetryPeriod, this.keepAliveInterval, keepAliveTimeout);
        }
    }
}

