/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CommandIdInterface;
import buzz.getcoco.iot.CommandResponse;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Formatters;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Utils;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;

public class Command<T extends CommandIdInterface> {
    private static final String TAG = "Command";
    static long defaultTimeOut = 0L;
    static final GsonBuilder GSON_BUILDER = new GsonBuilder();
    private transient Tag tag;
    private transient T commandId;
    private transient long commandTimeout;

    static void init() {
        InstantParser instantParser = new InstantParser();
        BooleanSerializer booleanSerializer = new BooleanSerializer();
        GSON_BUILDER.registerTypeAdapter(Boolean.class, (Object)booleanSerializer);
        GSON_BUILDER.registerTypeAdapter(Boolean.TYPE, (Object)booleanSerializer);
        GSON_BUILDER.registerTypeAdapter(Instant.class, (Object)instantParser);
    }

    protected Command(T commandId, long commandTimeout) {
        if (null == commandId) {
            throw new IllegalArgumentException("commandId cannot be null");
        }
        this.commandId = commandId;
        this.commandTimeout = commandTimeout;
    }

    protected Command(T commandId) {
        this(commandId, defaultTimeOut);
    }

    public T getCommandId() {
        return this.commandId;
    }

    protected void setCommandId(CommandIdInterface commandId) {
        this.commandId = (CommandIdInterface)Utils.castUp(commandId);
    }

    public Command<T> setTimeout(long commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public long getTimeout() {
        return this.commandTimeout;
    }

    protected JsonObject toJsonObject() {
        return GSON_BUILDER.create().toJsonTree((Object)this).getAsJsonObject();
    }

    final void setTag(Tag tag) {
        Tag oldTag = this.getTag();
        if (null != oldTag) {
            Log.w(TAG, "Command already sent. oldTag: " + oldTag);
        }
        this.tag = tag;
    }

    final Tag getTag() {
        return this.tag;
    }

    public String toString() {
        return "Command{commandId=" + this.commandId + ", commandTimeout=" + this.commandTimeout + ", class=" + this.getClass() + '}';
    }

    private static final class InstantParser
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        private static final Instant YEAR_3000 = Instant.ofEpochMilli(32503680000000L);

        private InstantParser() {
        }

        public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            long epochTime = 0L;
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
                epochTime = json.getAsLong();
            }
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return Instant.from(Formatters.getDateTimeFormatter().parse(json.getAsString()));
            }
            Instant instant = Instant.ofEpochSecond(epochTime);
            if (instant.isBefore(YEAR_3000)) {
                return instant;
            }
            return Instant.ofEpochMilli(epochTime);
        }

        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getEpochSecond());
        }
    }

    private static final class BooleanSerializer
    implements JsonSerializer<Boolean>,
    JsonDeserializer<Boolean> {
        private BooleanSerializer() {
        }

        public Boolean deserialize(JsonElement jsonEle, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonPrimitive json = jsonEle.getAsJsonPrimitive();
            if (json.isBoolean()) {
                return json.getAsBoolean();
            }
            if (json.isNumber()) {
                return 0 != json.getAsInt();
            }
            if (json.isString()) {
                return "true".equalsIgnoreCase(json.getAsString()) || "1".equalsIgnoreCase(json.getAsString());
            }
            throw new JsonParseException("unknown jsonType: " + json);
        }

        public JsonElement serialize(Boolean src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)(src != false ? 1 : 0));
        }
    }

    static final class CapabilityTag
    implements Tag {
        private final Capability capability;

        CapabilityTag(Capability capability) {
            this.capability = capability;
        }

        @Override
        public <T extends CommandIdInterface> CommandResponse.Args<T> generateArgs(T commandId, String response) {
            try {
                JsonElement responseParamsJson = JsonParser.parseString((String)response).getAsJsonObject().get("commandResponse");
                return this.capability.createCommandResponseArgs(commandId, responseParamsJson);
            }
            catch (JsonParseException e) {
                Log.w(Command.TAG, "error while parsing: " + response, e);
                return CommandResponse.createEmptyResponseArgs();
            }
        }
    }

    static final class NetworkTag
    implements Tag {
        private final Network network;

        NetworkTag(Network network) {
            this.network = network;
        }

        @Override
        public <T extends CommandIdInterface> CommandResponse.Args<T> generateArgs(T commandId, String response) {
            Log.d(Command.TAG, "ignoring genArgs on net: " + this.network + ", for: " + commandId);
            return CommandResponse.createEmptyResponseArgs();
        }
    }

    static final class DeviceTag
    implements Tag {
        private final Device device;

        DeviceTag(Device device) {
            this.device = device;
        }

        @Override
        public <T extends CommandIdInterface> CommandResponse.Args<T> generateArgs(T commandId, String response) {
            Log.d(Command.TAG, "ignoring genArgs on dev: " + this.device + ", for: " + commandId);
            return CommandResponse.createEmptyResponseArgs();
        }
    }

    static interface Tag {
        public <T extends CommandIdInterface> CommandResponse.Args<T> generateArgs(T var1, String var2);
    }

    public static enum State {
        SUCCESS,
        INVALID,
        FAILURE,
        PARTIAL_SUCCESS,
        TIMEOUT,
        REJECTED,
        DEVICE_BUSY,
        IN_PROGRESS,
        AUTH_FAILED,
        RESOURCE_NOT_SUPPORTED,
        SUCCESS_INSECURE,
        PARTIAL_SUCCESS_INSECURE,
        CONNECTIVITY_ERROR,
        COMMAND_NOT_SUPPORTED,
        TOKEN_NOT_SET,
        TOKEN_REFRESH_FAILED,
        DISCOVERY_NOT_APPLICABLE,
        NETWORK_DISCONNECTED,
        MAX_COUNT_REACHED,
        DEVICE_UNREACHABLE,
        NETWORK_BLOCKED;


        static State getEnum(int index) {
            return (State)Utils.findEnum((int)index, (Enum[])State.values());
        }
    }
}

