/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.CallbackMultiplexer;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.DefaultCallbacksInterface;
import buzz.getcoco.iot.FiniteStateMachine;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.NodeType;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public final class ConnectivityStateManager
implements DefaultCallbacksInterface {
    private static final String TAG = "ConnectivityManager";
    private static ConnectivityStateManager instance = null;
    private long connectingDelay = 20000L;
    private long localDelay = 7000L;
    private long localDelay2 = 15000L;
    private long localDelay3 = 15000L;
    private final ThreadLocal<Exception> exceptionLocal = new ThreadLocal();
    private final Map<String, NetworkDatum> networkData;
    private CacheState cachedState;
    private WeakReference<ConnectivityStateChangeListener> listener;

    private ConnectivityStateManager() {
        CallbackMultiplexer.getInstance().internalAddSubscription(this);
        this.networkData = new ConcurrentHashMap<String, NetworkDatum>(10);
    }

    public static ConnectivityStateManager getInstance() {
        if (null == instance) {
            return ConnectivityStateManager.getInstance(null);
        }
        return instance;
    }

    public static synchronized ConnectivityStateManager getInstance(ConnectivityStateChangeListener listener) {
        if (null == instance) {
            Log.d(TAG, "no instance available creating one");
            instance = new ConnectivityStateManager();
        }
        if (null == listener) {
            return instance;
        }
        ConnectivityStateManager.instance.listener = new WeakReference<ConnectivityStateChangeListener>(listener);
        return instance;
    }

    private boolean disconnectInternal(Network network) {
        try {
            network.disconnect();
            this.exceptionLocal.set(null);
        }
        catch (Exception e) {
            Log.w(TAG, "error while disconnection", e);
            this.exceptionLocal.set(e);
            return false;
        }
        return true;
    }

    private void removeNetworkData(String networkId) {
        this.networkData.remove(networkId);
    }

    private NetworkDatum getNetworkData(Network network) {
        NetworkDatum datum = this.networkData.get(network.getId());
        if (null == datum) {
            datum = new NetworkDatum(network);
            this.networkData.put(network.getId(), datum);
            Log.d(TAG, "getNetworkData: created: " + datum + ", for: " + network.getId());
        }
        return datum;
    }

    public CacheState cacheStates() {
        CacheState cachedState = new CacheState(CocoClient.getInstance().getNetworkMap().size());
        for (Network network : CocoClient.getInstance().getNetworkMap().values()) {
            Network.State state = network.getState();
            if (null == state || !state.isConnected()) continue;
            cachedState.connectedNetworks.add(network);
            Log.d(TAG, "adding " + network.getName() + " to cache");
        }
        this.cachedState = cachedState;
        return cachedState;
    }

    public void setConnectingTimeout(long connectingDelay) {
        this.connectingDelay = connectingDelay;
    }

    public void setLocalTimeout(long localDelay) {
        this.localDelay = localDelay;
    }

    public void setLocal2Timeout(long localDelay2) {
        this.localDelay2 = localDelay2;
    }

    public void setLocal3Timeout(long localDelay3) {
        this.localDelay3 = localDelay3;
    }

    public Exception getRecentException() {
        return this.exceptionLocal.get();
    }

    public void restoreToCachedState() {
        this.restoreToCachedState(this.cachedState);
    }

    public void restoreToCachedState(CacheState cacheState) {
        if (null == cacheState) {
            return;
        }
        for (Network network : cacheState.connectedNetworks) {
            Network.State state = network.getState();
            Log.d(TAG, "restoring " + network.getName() + " from cache");
            if (null != state && !state.isEquivalentToDisconnected()) continue;
            Log.d(TAG, "reconnecting on: " + network.getName());
            ConnectivityStateManager.connect(network);
        }
    }

    public static boolean disconnect(Network network) {
        return ConnectivityStateManager.getInstance().disconnectInternal(network);
    }

    private boolean connectInternal(Network network) {
        try {
            NetworkDatum datum = this.getNetworkData(network);
            network.connect();
            datum.handleEvent(Event.CONNECTING);
            this.exceptionLocal.set(null);
        }
        catch (Exception e) {
            Log.w(TAG, "error while connection", e);
            this.exceptionLocal.set(e);
            return false;
        }
        return true;
    }

    public static boolean connect(Network network) {
        return ConnectivityStateManager.getInstance().connectInternal(network);
    }

    @Override
    public void connectStatusCallback(Network network) {
        Log.d(TAG, "connectStatusCB network: " + network.getId() + ", status: " + (Object)((Object)network.getState()));
        Event event = network.getState().isConnected() ? Event.CONNECTED : (network.getState().isConnecting() ? Event.CONNECTING : (network.getState().isLeftOrDeleted() ? Event.RESET : (network.getState().isBlocked() ? Event.BLOCKED : (network.getState().connectionNotPermitted() ? Event.NOT_PERMITTED : Event.DISCONNECTED))));
        NetworkDatum datum = this.getNetworkData(network);
        if (Event.DISCONNECTED == event) {
            this.removeNetworkData(network.getId());
        }
        datum.handleEvent(event);
    }

    @Override
    public void nodeConnectionStatusCallback(Network network, long nodeId, NodeType nodeType, boolean isOnline) {
        Log.d(TAG, "nodeStatus: " + isOnline + ", type: " + (Object)((Object)nodeType) + ", id: " + nodeId + ", networkId: " + network.getId());
        if (NodeType.NETWORK != nodeType) {
            return;
        }
        NetworkDatum datum = this.getNetworkData(network);
        Event event = isOnline ? Event.NODE_STATUS_ONLINE : Event.NODE_STATUS_OFFLINE;
        datum.handleEvent(event);
    }

    @Override
    public void networkDataCallback(Network network) {
        Log.d(TAG, "network data received for: " + network.getName());
        NetworkDatum datum = this.getNetworkData(network);
        datum.handleEvent(Event.NETWORK_DATA_RECEIVED);
    }

    public static State getState(Network network) {
        if (null == network) {
            Log.d(TAG, "getState: null network received");
            return State.OFFLINE;
        }
        return ConnectivityStateManager.getState(ConnectivityStateManager.getInstance().getNetworkData(network));
    }

    private static State getState(NetworkDatum datum) {
        if (null == datum) {
            Log.d(TAG, "getState: null datum received");
            return State.OFFLINE;
        }
        return datum.getExternalState();
    }

    public static enum State {
        DELETED,
        OFFLINE,
        LOCAL,
        CONNECTING,
        ONLINE,
        BLOCKED,
        NOT_PERMITTED;


        private InternalState getInternalState() {
            switch (this) {
                case BLOCKED: {
                    return InternalState.BLOCKED;
                }
                case DELETED: {
                    return InternalState.DELETED;
                }
                case OFFLINE: {
                    return InternalState.OFFLINE;
                }
                case CONNECTING: {
                    return InternalState.CONNECTING;
                }
                case LOCAL: {
                    return InternalState.LOCAL_1;
                }
                case ONLINE: {
                    return InternalState.ONLINE;
                }
            }
            return InternalState.OFFLINE;
        }
    }

    private static class InternalState
    implements FiniteStateMachine.State {
        public static final InternalState BLOCKED = new InternalState(State.BLOCKED);
        public static final InternalState NOT_PERMITTED = new InternalState(State.NOT_PERMITTED);
        public static final InternalState DELETED = new InternalState(State.DELETED);
        public static final InternalState OFFLINE = new InternalState(State.OFFLINE);
        public static final InternalState LOCAL_1 = new InternalState(State.LOCAL);
        public static final InternalState LOCAL_2 = new InternalState(State.LOCAL);
        public static final InternalState LOCAL_3 = new InternalState(State.LOCAL);
        public static final InternalState CONNECTING = new InternalState(State.CONNECTING);
        public static final InternalState ONLINE = new InternalState(State.ONLINE);
        public static final InternalState ANY = new InternalState(null);
        private final State exposedState;

        private InternalState(State exposedState) {
            this.exposedState = exposedState;
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (ANY == this || ANY == obj) {
                return true;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return null != this.exposedState ? this.exposedState.hashCode() : 0;
        }

        public String toString() {
            if (DELETED == this) {
                return "DELETED";
            }
            if (OFFLINE == this) {
                return "OFFLINE";
            }
            if (LOCAL_1 == this) {
                return "LOCAL_1";
            }
            if (LOCAL_2 == this) {
                return "LOCAL_2";
            }
            if (LOCAL_3 == this) {
                return "LOCAL_3";
            }
            if (CONNECTING == this) {
                return "CONNECTING";
            }
            if (ONLINE == this) {
                return "ONLINE";
            }
            if (ANY == this) {
                return "ANY";
            }
            if (BLOCKED == this) {
                return "BLOCKED";
            }
            if (NOT_PERMITTED == this) {
                return "NOT_PERMITTED";
            }
            return "<UNKNOWN>" + super.toString();
        }

        private State getExposedState() {
            return this.exposedState;
        }
    }

    private static class Event
    implements FiniteStateMachine.Event {
        public static final Event CONNECTED = new Event();
        public static final Event DISCONNECTED = new Event();
        public static final Event CONNECTING = new Event();
        public static final Event NETWORK_DATA_RECEIVED = new Event();
        public static final Event NETWORK_DATA_LOST = new Event();
        public static final Event NODE_STATUS_ONLINE = new Event();
        public static final Event NODE_STATUS_OFFLINE = new Event();
        public static final Event TIMEOUT = new Event();
        public static final Event RESET = new Event();
        public static final Event BLOCKED = new Event();
        public static final Event NOT_PERMITTED = new Event();

        private Event() {
        }

        public String toString() {
            if (CONNECTED == this) {
                return "CONNECTED";
            }
            if (DISCONNECTED == this) {
                return "DISCONNECTED";
            }
            if (CONNECTING == this) {
                return "CONNECTING";
            }
            if (NETWORK_DATA_RECEIVED == this) {
                return "NETWORK_DATA_RECEIVED";
            }
            if (NETWORK_DATA_LOST == this) {
                return "NETWORK_DATA_LOST";
            }
            if (NODE_STATUS_ONLINE == this) {
                return "NODE_STATUS_ONLINE";
            }
            if (NODE_STATUS_OFFLINE == this) {
                return "NODE_STATUS_OFFLINE";
            }
            if (TIMEOUT == this) {
                return "TIMEOUT";
            }
            if (RESET == this) {
                return "RESET";
            }
            if (BLOCKED == this) {
                return "BLOCKED";
            }
            if (NOT_PERMITTED == this) {
                return "NOT PERMITTED";
            }
            return "<UNKNOWN>" + super.toString();
        }
    }

    public static class CacheState {
        private final List<Network> connectedNetworks;

        private CacheState(int initialCapacity) {
            this.connectedNetworks = new ArrayList<Network>(initialCapacity);
        }
    }

    private class NetworkDatum
    implements FiniteStateMachine.TimerCallback<NetworkDatum> {
        private static final int TASK_UNKNOWN = 0;
        private static final int TASK_DISCONNECT = 1;
        private static final int TASK_SET_LOCAL = 2;
        private final Timer timer;
        private final String networkId;
        private final FiniteStateMachine<InternalState, Event, NetworkDatum> fsm;
        private TimerTask nextTask = null;
        private int nextTaskType = 0;

        private List<FiniteStateMachine.EventTable<InternalState, Event, NetworkDatum>> getEventTable() {
            List<FiniteStateMachine.EventTable<InternalState, Event, NetworkDatum>> eventTables = Arrays.asList(new FiniteStateMachine.EventTable(Event.RESET, InternalState.ANY, InternalState.DELETED, null), new FiniteStateMachine.EventTable(Event.BLOCKED, InternalState.ANY, InternalState.BLOCKED, null), new FiniteStateMachine.EventTable(Event.NOT_PERMITTED, InternalState.ANY, InternalState.NOT_PERMITTED, null), new FiniteStateMachine.EventTable(Event.CONNECTING, InternalState.ANY, InternalState.CONNECTING, null), new FiniteStateMachine.EventTable(Event.DISCONNECTED, InternalState.ANY, InternalState.OFFLINE, null), new FiniteStateMachine.EventTable(Event.CONNECTED, InternalState.CONNECTING, InternalState.LOCAL_1, null), new FiniteStateMachine.EventTable(Event.NODE_STATUS_ONLINE, InternalState.LOCAL_1, InternalState.LOCAL_2, null), new FiniteStateMachine.EventTable<InternalState, Event, NetworkDatum>(Event.NETWORK_DATA_RECEIVED, InternalState.LOCAL_1, InternalState.LOCAL_3, d -> this.logImpossibleState(Event.NETWORK_DATA_RECEIVED, InternalState.LOCAL_1)), new FiniteStateMachine.EventTable(Event.NETWORK_DATA_RECEIVED, InternalState.ONLINE, InternalState.ONLINE, null), new FiniteStateMachine.EventTable(Event.NODE_STATUS_ONLINE, InternalState.ONLINE, InternalState.ONLINE, null), new FiniteStateMachine.EventTable(Event.NODE_STATUS_ONLINE, InternalState.LOCAL_3, InternalState.ONLINE, null), new FiniteStateMachine.EventTable(Event.NETWORK_DATA_RECEIVED, InternalState.LOCAL_2, InternalState.ONLINE, null), new FiniteStateMachine.EventTable<InternalState, Event, NetworkDatum>(Event.NETWORK_DATA_LOST, InternalState.ONLINE, InternalState.LOCAL_2, d -> this.logImpossibleState(Event.NETWORK_DATA_LOST, InternalState.ONLINE)), new FiniteStateMachine.EventTable(Event.NODE_STATUS_OFFLINE, InternalState.ONLINE, InternalState.LOCAL_1, null), new FiniteStateMachine.EventTable(Event.NODE_STATUS_OFFLINE, InternalState.LOCAL_2, InternalState.LOCAL_1, null), new FiniteStateMachine.EventTable<InternalState, Event, NetworkDatum>(Event.NETWORK_DATA_LOST, InternalState.LOCAL_3, InternalState.LOCAL_1, d -> this.logImpossibleState(Event.NETWORK_DATA_LOST, InternalState.LOCAL_3)), new FiniteStateMachine.EventTable<InternalState, Event, NetworkDatum>(Event.TIMEOUT, InternalState.LOCAL_1, InternalState.LOCAL_1, d -> this.broadCastIfLocal()), new FiniteStateMachine.EventTable<InternalState, Event, NetworkDatum>(Event.TIMEOUT, InternalState.LOCAL_2, InternalState.LOCAL_2, d -> this.broadCastIfLocal()), new FiniteStateMachine.EventTable<InternalState, Event, NetworkDatum>(Event.TIMEOUT, InternalState.LOCAL_3, InternalState.LOCAL_3, d -> this.broadCastIfLocal()), new FiniteStateMachine.EventTable<InternalState, Event, NetworkDatum>(Event.TIMEOUT, InternalState.CONNECTING, InternalState.CONNECTING, d -> this.disconnectIfConnecting()));
            for (int i = 0; i < eventTables.size(); ++i) {
                Log.d(ConnectivityStateManager.TAG, "eventTable[" + i + "]:" + eventTables.get(i));
            }
            return eventTables;
        }

        private List<FiniteStateMachine.StateTable<InternalState, Event, NetworkDatum>> getStateTable() {
            List<FiniteStateMachine.StateTable<InternalState, Event, NetworkDatum>> stateTables = Arrays.asList(new FiniteStateMachine.StateTable(InternalState.LOCAL_1, () -> ConnectivityStateManager.this.localDelay, null, null), new FiniteStateMachine.StateTable(InternalState.LOCAL_2, () -> ConnectivityStateManager.this.localDelay2, null, null), new FiniteStateMachine.StateTable(InternalState.LOCAL_3, () -> ConnectivityStateManager.this.localDelay3, null, null), new FiniteStateMachine.StateTable<InternalState, Event, NetworkDatum>(InternalState.DELETED, 0L, this::broadcastStateChange, null), new FiniteStateMachine.StateTable<InternalState, Event, NetworkDatum>(InternalState.OFFLINE, 0L, this::broadcastStateChange, null), new FiniteStateMachine.StateTable<InternalState, Event, NetworkDatum>(InternalState.ONLINE, 0L, this::broadcastStateChange, null), new FiniteStateMachine.StateTable<InternalState, Event, NetworkDatum>(InternalState.BLOCKED, 0L, this::broadcastStateChange, null), new FiniteStateMachine.StateTable<InternalState, Event, NetworkDatum>(InternalState.NOT_PERMITTED, 0L, this::broadcastStateChange, null), new FiniteStateMachine.StateTable<InternalState, Event, NetworkDatum>(InternalState.CONNECTING, () -> ConnectivityStateManager.this.connectingDelay, this::broadcastStateChange, null));
            for (int i = 0; i < stateTables.size(); ++i) {
                Log.d(ConnectivityStateManager.TAG, "stateTable[" + i + "]:" + stateTables.get(i));
            }
            return stateTables;
        }

        private NetworkDatum(Network network) {
            InternalState expectedState = this.getExpectedState(network);
            network.internalSetConnectivityState(expectedState.getExposedState());
            this.networkId = network.getId();
            this.timer = new Timer();
            this.fsm = new FiniteStateMachine(expectedState, this, this.getEventTable(), this.getStateTable());
        }

        private InternalState getExpectedState(Network network) {
            if (null == network) {
                return InternalState.OFFLINE;
            }
            Network.State networkState = network.getState();
            State exposedState = network.getConnectivityManagerState();
            if (null != exposedState) {
                return exposedState.getInternalState();
            }
            if (null == networkState) {
                return InternalState.OFFLINE;
            }
            if (networkState.isConnecting()) {
                return InternalState.CONNECTING;
            }
            if (networkState.isConnected()) {
                return InternalState.ONLINE;
            }
            return InternalState.OFFLINE;
        }

        private Network getNetwork() {
            return CocoClient.getInstance().getNetwork(this.networkId);
        }

        private State getExternalState() {
            Network network = this.getNetwork();
            if (null == network) {
                return State.OFFLINE;
            }
            return network.getConnectivityManagerState();
        }

        private void logImpossibleState(Event event, InternalState state) {
            Log.w(ConnectivityStateManager.TAG, "impossible event: " + event + "state: " + state);
        }

        private void disconnectIfConnecting() {
            if (InternalState.CONNECTING != this.fsm.getCurrentState()) {
                return;
            }
            Network network = this.getNetwork();
            if (null == network) {
                return;
            }
            ConnectivityStateManager.disconnect(network);
        }

        private void broadCastIfLocal() {
            ConnectivityStateChangeListener listener;
            InternalState state = this.fsm.getCurrentState();
            WeakReference weakListener = ConnectivityStateManager.this.listener;
            ConnectivityStateChangeListener connectivityStateChangeListener = listener = null == weakListener ? null : (ConnectivityStateChangeListener)weakListener.get();
            if (InternalState.LOCAL_1 != state && InternalState.LOCAL_2 != state && InternalState.LOCAL_3 != state) {
                return;
            }
            State externalState = State.LOCAL;
            Network network = this.getNetwork();
            if (null != network) {
                network.internalSetConnectivityState(externalState);
            }
            if (null == listener) {
                Log.d(ConnectivityStateManager.TAG, "no listener !!");
                return;
            }
            Log.d(ConnectivityStateManager.TAG, "posting to listener");
            listener.onStateChanged(network, null, externalState);
            Log.d(ConnectivityStateManager.TAG, "posted to listener");
        }

        private Event broadcastStateChange(NetworkDatum arg) {
            this.broadcastStateChange();
            return null;
        }

        private void broadcastStateChange() {
            Network network = this.getNetwork();
            InternalState internalState = this.fsm.getCurrentState();
            WeakReference weakListener = ConnectivityStateManager.this.listener;
            ConnectivityStateChangeListener listener = null == weakListener ? null : (ConnectivityStateChangeListener)weakListener.get();
            Log.d(ConnectivityStateManager.TAG, "broadcasting for: " + (null == network ? "-" : network.getName()) + " for state: " + internalState);
            State externalState = internalState.getExposedState();
            if (null != network) {
                network.internalSetConnectivityState(externalState);
            }
            if (null == listener) {
                Log.d(ConnectivityStateManager.TAG, "no listener !!");
                return;
            }
            Log.d(ConnectivityStateManager.TAG, "posting to listener");
            listener.onStateChanged(network, null, externalState);
            Log.d(ConnectivityStateManager.TAG, "posted to listener");
        }

        @Override
        public void triggerTimer(long timeout, NetworkDatum datum) {
            boolean stateLocal;
            InternalState state = datum.fsm.getCurrentState();
            boolean stateConnecting = InternalState.CONNECTING == state;
            boolean bl = stateLocal = InternalState.LOCAL_1 == state || InternalState.LOCAL_2 == state || InternalState.LOCAL_3 == state;
            if (stateConnecting && 1 == this.nextTaskType) {
                return;
            }
            if (stateLocal && 2 == this.nextTaskType) {
                return;
            }
            this.nextTaskType = stateConnecting ? 1 : (stateLocal ? 2 : 0);
            if (null != this.nextTask) {
                this.nextTask.cancel();
                this.nextTask = null;
            }
            this.timer.purge();
            if (this.nextTaskType == 0) {
                return;
            }
            this.nextTask = new TimerTask(){

                @Override
                public void run() {
                    NetworkDatum.this.handleEvent(Event.TIMEOUT);
                }
            };
            this.timer.schedule(this.nextTask, timeout);
        }

        private void handleEvent(Event ev) {
            try {
                this.fsm.handleEvent(ev, this);
            }
            catch (Exception e) {
                Log.d(ConnectivityStateManager.TAG, "cannot handle event", e);
            }
        }
    }

    public static interface ConnectivityStateChangeListener {
        public void onStateChanged(Network var1, State var2, State var3);
    }
}

