/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityColor;
import buzz.getcoco.iot.CapabilityContactSensing;
import buzz.getcoco.iot.CapabilityDoorLock;
import buzz.getcoco.iot.CapabilityEnergyMetering;
import buzz.getcoco.iot.CapabilityFireSensing;
import buzz.getcoco.iot.CapabilityFluidLevelSensing;
import buzz.getcoco.iot.CapabilityHumiditySensing;
import buzz.getcoco.iot.CapabilityIlluminance;
import buzz.getcoco.iot.CapabilityImageControl;
import buzz.getcoco.iot.CapabilityKeyPressSensing;
import buzz.getcoco.iot.CapabilityLevel;
import buzz.getcoco.iot.CapabilityMediaStreaming;
import buzz.getcoco.iot.CapabilityMotionSensing;
import buzz.getcoco.iot.CapabilityMotorControl;
import buzz.getcoco.iot.CapabilityNetworkConfiguration;
import buzz.getcoco.iot.CapabilityOccupancySensing;
import buzz.getcoco.iot.CapabilityOnOff;
import buzz.getcoco.iot.CapabilityPowerLevels;
import buzz.getcoco.iot.CapabilitySnapshot;
import buzz.getcoco.iot.CapabilityStorageConfig;
import buzz.getcoco.iot.CapabilityStorageControl;
import buzz.getcoco.iot.CapabilityTemperatureSensing;
import buzz.getcoco.iot.CapabilityTunnel;
import buzz.getcoco.iot.CapabilityWarning;
import java.util.HashMap;
import java.util.Map;

public class DataTypeFormatter {
    private static final Map<Capability.AttributeId, Attribute.DataType> DATA_TYPE_LUT = new HashMap<Capability.AttributeId, Attribute.DataType>();

    private DataTypeFormatter() {
        throw new IllegalArgumentException();
    }

    static Attribute.DataType getSupposedDataType(Capability.AttributeId attributeId) {
        return DATA_TYPE_LUT.get(attributeId);
    }

    static boolean isOfDataType(Object value, SimpleDataType dataType) {
        if (null == value) {
            return false;
        }
        switch (dataType) {
            case NUMBER: {
                return value instanceof Number;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case STRING: {
                return value instanceof String;
            }
            case BOOLEAN_ARR: {
                return value instanceof boolean[] || value instanceof Boolean[];
            }
            case STRING_ARR: {
                return value instanceof String[];
            }
            case NUMBER_ARR: {
                if (value instanceof Number[]) {
                    return true;
                }
                if (value instanceof int[]) {
                    return true;
                }
                if (value instanceof double[]) {
                    return true;
                }
                if (value instanceof long[]) {
                    return true;
                }
                return value instanceof float[];
            }
        }
        return true;
    }

    static {
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.RED, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.GREEN, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.BLUE, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.HUE_DEGREES, Attribute.DataType.UINT16);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.SATURATION_PCT, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.LUMINANCE_PCT, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.COLOR_X, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.COLOR_Y, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.COLOR_MODE, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.COLOR_TEMP_KELVIN, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.COMP_ID_ARR, Attribute.DataType.UINT8_ARR);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.COMP_VALUES_ARR, Attribute.DataType.UINT8_ARR);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.HSL, Attribute.DataType.UINT16_ARR);
        DATA_TYPE_LUT.put(CapabilityColor.AttributeId.RGB, Attribute.DataType.UINT8_ARR);
        DATA_TYPE_LUT.put(CapabilityLevel.AttributeId.LEVEL_PCT, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityOnOff.AttributeId.ON_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityDoorLock.AttributeId.LOCKED_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityDoorLock.AttributeId.USER_ID_ARR, Attribute.DataType.UINT32_ARR);
        DATA_TYPE_LUT.put(CapabilityDoorLock.AttributeId.PIN_CODE_ARR, Attribute.DataType.STRING_ARR);
        DATA_TYPE_LUT.put(CapabilityDoorLock.AttributeId.USER_STATUS_ARR, Attribute.DataType.UINT8_ARR);
        DATA_TYPE_LUT.put(CapabilityDoorLock.AttributeId.USER_TYPE_ARR, Attribute.DataType.UINT8_ARR);
        DATA_TYPE_LUT.put(CapabilityEnergyMetering.AttributeId.PRODUCTION, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityEnergyMetering.AttributeId.CONSUMPTION, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityEnergyMetering.AttributeId.DEMAND_WATT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityEnergyMetering.AttributeId.LAST_READ_TIME_ARR, Attribute.DataType.STRING_ARR);
        DATA_TYPE_LUT.put(CapabilityMotionSensing.AttributeId.DETECTED_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityMotionSensing.AttributeId.SENSING_ENABLED, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityMotionSensing.AttributeId.IMAGE_WIDTH, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityMotionSensing.AttributeId.IMAGE_HEIGHT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityMotionSensing.AttributeId.ROI_WIDTH, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityMotionSensing.AttributeId.ROI_HEIGHT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityMotionSensing.AttributeId.ROI_INDICES_COUNT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityMotionSensing.AttributeId.ROI_INDICES_ARR, Attribute.DataType.UINT32_ARR);
        DATA_TYPE_LUT.put(CapabilityMotionSensing.AttributeId.SENSITIVITY_PCT, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityOccupancySensing.AttributeId.PRESENCE_DETECTED_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityContactSensing.AttributeId.CONTACT_1_OPEN_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityContactSensing.AttributeId.CONTACT_2_OPEN_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityFluidLevelSensing.AttributeId.OVERFLOW_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityFluidLevelSensing.AttributeId.LEAK_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityFireSensing.AttributeId.CO_DETECTED_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityFireSensing.AttributeId.COOKING_IND_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityFireSensing.AttributeId.SMOKE_DETECTED_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityFireSensing.AttributeId.HEAT_DETECTED_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityFireSensing.AttributeId.OVERHEAT_DETECTED_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityFireSensing.AttributeId.COLD_DETECTED_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityFireSensing.AttributeId.FIRE_DETECTED_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityTemperatureSensing.AttributeId.CURRENT_TEMP_CELSIUS, Attribute.DataType.INT32);
        DATA_TYPE_LUT.put(CapabilityIlluminance.AttributeId.CURRENT_LUMINANCE_LUX, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityPowerLevels.AttributeId.VOLTAGE_MV, Attribute.DataType.DOUBLE);
        DATA_TYPE_LUT.put(CapabilityPowerLevels.AttributeId.LEVEL_PCT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityPowerLevels.AttributeId.VOLT_LOW_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityPowerLevels.AttributeId.LEVEL_LOW_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityPowerLevels.AttributeId.LEVEL_CRITICAL_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityTunnel.AttributeId.SUPPORTED_TRANSPORT_TYPE_COUNT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityTunnel.AttributeId.SUPPORTED_PROTOCOL_COUNT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityTunnel.AttributeId.CURRENT_ACTIVE_CLIENTS_COUNT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityTunnel.AttributeId.SUPPORTED_TRANSPORT_TYPE_ARR, Attribute.DataType.UINT8_ARR);
        DATA_TYPE_LUT.put(CapabilityTunnel.AttributeId.SUPPORTED_PROTOCOL_ARR, Attribute.DataType.UINT8_ARR);
        DATA_TYPE_LUT.put(CapabilityTunnel.AttributeId.SUPPORTED_PROTOCOL_METADATA_ARR, Attribute.DataType.STRING_ARR);
        DATA_TYPE_LUT.put(CapabilityTunnel.AttributeId.CURRENT_ACTIVE_CLIENTS_ARR, Attribute.DataType.UINT32_ARR);
        DATA_TYPE_LUT.put(CapabilityTunnel.AttributeId.MAX_ACTIVE_CLIENTS_COUNT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityHumiditySensing.AttributeId.CURRENT_REL_HUMIDITY_PCT, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityKeyPressSensing.AttributeId.SCENE_ID, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityKeyPressSensing.AttributeId.SCENE_KEY, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityKeyPressSensing.AttributeId.DISARM_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityKeyPressSensing.AttributeId.ARM_DAY_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityKeyPressSensing.AttributeId.ARM_NIGHT_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityKeyPressSensing.AttributeId.ARM_ALL_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityKeyPressSensing.AttributeId.PANIC_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityKeyPressSensing.AttributeId.EMERGENCY_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityWarning.AttributeId.STATE, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityNetworkConfiguration.AttributeId.RSSI, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityMediaStreaming.AttributeId.DESCRIPTOR, Attribute.DataType.STRING);
        DATA_TYPE_LUT.put(CapabilityMediaStreaming.AttributeId.ID_ARR, Attribute.DataType.INT8_ARR);
        DATA_TYPE_LUT.put(CapabilityMediaStreaming.AttributeId.ACTIVE_CLIENTS_ARR, Attribute.DataType.UINT32_ARR);
        DATA_TYPE_LUT.put(CapabilityMediaStreaming.AttributeId.MAX_ACTIVE_CLIENTS_ARR, Attribute.DataType.UINT32_ARR);
        DATA_TYPE_LUT.put(CapabilityMediaStreaming.AttributeId.REC_STATUS_ARR, Attribute.DataType.BOOLEAN_ARR);
        DATA_TYPE_LUT.put(CapabilityMediaStreaming.AttributeId.REC_SUPPORTED_ARR, Attribute.DataType.BOOLEAN_ARR);
        DATA_TYPE_LUT.put(CapabilityMediaStreaming.AttributeId.RECORDING_IN_PROGRESS, Attribute.DataType.UINT32_ARR);
        DATA_TYPE_LUT.put(CapabilityMotorControl.AttributeId.PAN_DOF, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityMotorControl.AttributeId.TILT_DOF, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityMotorControl.AttributeId.SPEED_RPM, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityMotorControl.AttributeId.PRESET_POINT_ARR, Attribute.DataType.UINT32_ARR);
        DATA_TYPE_LUT.put(CapabilityMotorControl.AttributeId.TRACK_PRESET_POINT_ARR, Attribute.DataType.UINT32_ARR);
        DATA_TYPE_LUT.put(CapabilityMotorControl.AttributeId.TRACK_ACTIVE_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityMotorControl.AttributeId.TRACK_REPEAT_COUNT, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityStorageControl.AttributeId.CONTENT_COUNT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityStorageControl.AttributeId.CAPACITY_MB, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityStorageControl.AttributeId.AVAILABLE_MB, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityStorageControl.AttributeId.SUPPORTED_TYPES_ARR, Attribute.DataType.UINT8_ARR);
        DATA_TYPE_LUT.put(CapabilityStorageControl.AttributeId.RECORDING_TIME_CONFIG, Attribute.DataType.JSON);
        DATA_TYPE_LUT.put(CapabilityStorageControl.AttributeId.RECORDING_SIZE_CONFIG, Attribute.DataType.JSON);
        DATA_TYPE_LUT.put(CapabilityStorageControl.AttributeId.LAST_UPDATED_CONTENT_METADATA, Attribute.DataType.JSON);
        DATA_TYPE_LUT.put(CapabilityStorageControl.AttributeId.COOL_OFF_PERIOD, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityStorageControl.AttributeId.RECORDING_STARTED, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityStorageControl.AttributeId.SUPPORTED_STREAM_PROTOCOLS, Attribute.DataType.UINT8_ARR);
        DATA_TYPE_LUT.put(CapabilityStorageConfig.AttributeId.STORAGE_NODE, Attribute.DataType.STRING);
        DATA_TYPE_LUT.put(CapabilitySnapshot.AttributeId.IMG_SUPPORT_RESOLUTION_HEIGHT_ARR, Attribute.DataType.UINT32_ARR);
        DATA_TYPE_LUT.put(CapabilitySnapshot.AttributeId.IMG_SUPPORT_RESOLUTION_WIDTH_ARR, Attribute.DataType.UINT32_ARR);
        DATA_TYPE_LUT.put(CapabilitySnapshot.AttributeId.IMG_DEFAULT_RESOLUTION_HEIGHT, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilitySnapshot.AttributeId.IMG_DEFAULT_RESOLUTION_WIDTH, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.AF_MODE_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.AE_MODE_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.AWB_MODE_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.ZOOM_TYPE, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IR_CUT_MODE_TYPE, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IMG_PRESET_TYPE, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IMG_HUE_PCT, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IMG_SATURATION_PCT, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IMG_CONTRAST_PCT, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IMG_BRIGHTNESS_PCT, Attribute.DataType.UINT8);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IMG_FLIP_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IMG_MIRROR_FLAG, Attribute.DataType.BOOLEAN);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IMG_TEXT, Attribute.DataType.STRING);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IMG_TEXT_X_POSITION, Attribute.DataType.UINT32);
        DATA_TYPE_LUT.put(CapabilityImageControl.AttributeId.IMG_TEXT_Y_POSITION, Attribute.DataType.UINT32);
    }

    public static enum SimpleDataType {
        NUMBER,
        BOOLEAN,
        STRING,
        NUMBER_ARR,
        BOOLEAN_ARR,
        STRING_ARR;

    }
}

