/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Factory;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.PowerSource;
import buzz.getcoco.iot.RadioProtocol;
import buzz.getcoco.iot.ReceiverType;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.ResourceAction;
import buzz.getcoco.iot.ResourceCondition;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.ScheduleCondition;
import buzz.getcoco.iot.Utils;
import buzz.getcoco.iot.Zone;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

class DeepDeserializer {
    private static final String TAG = "DeepDeserializer";
    private static final Gson GSON;
    private static final GsonBuilder BUILDER;
    private static final ConcurrentHashMap<String, Network> deserializationJobs;

    DeepDeserializer() {
    }

    static Network deserialize(String json) {
        return (Network)GSON.fromJson(json, Network.class);
    }

    static {
        BUILDER = new GsonBuilder();
        deserializationJobs = new ConcurrentHashMap(3);
        GsonBuilder localBuilder = new GsonBuilder();
        localBuilder.registerTypeAdapter(Resource.class, (json, typeOfT, context) -> {
            String resourceEui;
            long deviceNodeId;
            JsonObject jsonObject = json.getAsJsonObject();
            String networkId = jsonObject.get("networkId").getAsString();
            Resource resource = Utils.getResource(deserializationJobs, networkId, deviceNodeId = jsonObject.get("gatewayNodeId").getAsLong(), resourceEui = jsonObject.get("resourceEui").getAsString());
            if (null == resource) {
                throw new JsonParseException("cannot find resource for: " + networkId + ":" + deviceNodeId + ":" + resourceEui);
            }
            return resource;
        });
        localBuilder.registerTypeAdapter(Scene.class, (json, typeOfT, context) -> {
            JsonObject jsonObject = json.getAsJsonObject();
            String networkId = jsonObject.get("networkId").getAsString();
            int sceneId = jsonObject.get("sceneId").getAsInt();
            Network network = deserializationJobs.get(networkId);
            return network.getScene(sceneId);
        });
        localBuilder.registerTypeAdapter(ResourceAction.class, (json, typeOfT, context) -> {
            int capabilityId;
            String resourceEui;
            long deviceNodeId;
            JsonObject jsonObject = json.getAsJsonObject();
            String networkId = jsonObject.get("networkId").getAsString();
            Capability capability = Utils.getCapability(deserializationJobs, networkId, deviceNodeId = jsonObject.get("gatewayNodeId").getAsLong(), resourceEui = jsonObject.get("resourceEui").getAsString(), capabilityId = jsonObject.get("capabilityId").getAsInt());
            if (null == capability) {
                throw new JsonParseException("cannot find capability for: " + networkId + ":" + deviceNodeId + ":" + resourceEui + ":" + capabilityId);
            }
            int resourceActionId = jsonObject.get("resrcActionId").getAsInt();
            Command<? extends Capability.CommandId> command = capability.createCommand(jsonObject.get("cmdId").getAsInt(), jsonObject.get("cmdParams"));
            return new ResourceAction(resourceActionId, capability, command);
        });
        localBuilder.registerTypeAdapter(ScheduleCondition.class, (json, typeOfT, context) -> {
            JsonObject jsonObject = json.getAsJsonObject();
            int id = jsonObject.get("ruleSchedCondId").getAsInt();
            ScheduleCondition.ScheduleType scheduleType = ScheduleCondition.ScheduleType.getEnum(jsonObject.get("ruleSchedTypeId").getAsInt());
            Instant startTime = Instant.ofEpochSecond(jsonObject.get("ruleStartTime").getAsLong());
            Instant expiryTime = Instant.ofEpochSecond(jsonObject.get("ruleExpiryTime").getAsLong());
            return new ScheduleCondition(id, startTime, expiryTime, scheduleType);
        });
        localBuilder.registerTypeAdapter(ResourceCondition.class, (json, typeOfT, context) -> {
            Object thresholdAttributeValue;
            JsonObject jsonObject = json.getAsJsonObject();
            Gson gson = new Gson();
            String networkId = jsonObject.get("networkId").getAsString();
            String resourceEui = jsonObject.get("resourceEui").getAsString();
            long deviceNodeId = jsonObject.get("gatewayNodeId").getAsLong();
            int capabilityId = jsonObject.get("capabilityId").getAsInt();
            int attributeId = jsonObject.get("attributeId").getAsInt();
            long conditionDuration = jsonObject.get("condDurationMs").getAsLong();
            ResourceCondition.OperatorType operatorType = (ResourceCondition.OperatorType)((Object)((Object)context.deserialize(jsonObject.get("operatorId"), ResourceCondition.OperatorType.class)));
            Attribute.DataType attributeDataType = (Attribute.DataType)((Object)((Object)context.deserialize(jsonObject.get("valueDataTypeId"), Attribute.DataType.class)));
            JsonElement attributeValueJson = jsonObject.get("value");
            switch (attributeDataType) {
                case BOOLEAN: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, Boolean.TYPE);
                    break;
                }
                case BOOLEAN_ARR: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, boolean[].class);
                    break;
                }
                case STRING: 
                case JSON: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, String.class);
                    break;
                }
                case STRING_ARR: 
                case JSON_ARR: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, String[].class);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, Double.TYPE);
                    break;
                }
                case FLOAT_ARR: 
                case DOUBLE_ARR: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, double[].class);
                    break;
                }
                case UINT8: 
                case UINT16: 
                case INT8: 
                case INT16: 
                case INT32: 
                case UINT32: 
                case UINT64: 
                case INT64: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, Integer.TYPE);
                    break;
                }
                case UINT8_ARR: 
                case UINT16_ARR: 
                case INT8_ARR: 
                case INT16_ARR: 
                case INT32_ARR: 
                case UINT32_ARR: 
                case UINT64_ARR: 
                case INT64_ARR: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, int[].class);
                    break;
                }
                default: {
                    thresholdAttributeValue = null;
                }
            }
            Network network = deserializationJobs.get(networkId);
            Device device = null == network ? null : (Device)network.getDevice(deviceNodeId);
            Resource resource = null == device ? null : (Resource)device.getResource(resourceEui);
            Capability capability = null == resource ? null : (Capability)resource.getCapability(Capability.CapabilityId.getEnum(capabilityId));
            int id = jsonObject.get("ruleResCondId").getAsInt();
            return new ResourceCondition(id, capability, attributeId, operatorType.getInt(), conditionDuration, attributeDataType, thresholdAttributeValue);
        });
        Gson localGson = localBuilder.create();
        BUILDER.registerTypeAdapter(Zone.class, (json, typeOfT, context) -> {
            Type type = new TypeToken<HashSet<Resource>>(){}.getType();
            JsonObject jsonObject = json.getAsJsonObject();
            int zoneId = jsonObject.get("zoneId").getAsInt();
            String zoneName = jsonObject.get("zoneName").getAsString();
            HashSet resources = (HashSet)localGson.fromJson(jsonObject.get("resourceArr"), type);
            Zone zone = Factory.createZone(zoneId, null);
            zone.internalSetName(zoneName);
            for (Resource resource : resources) {
                zone.internalAddResource(resource);
                resource.internalSetParentZone(zone);
            }
            return zone;
        });
        BUILDER.registerTypeAdapter(Scene.class, (json, typeOfT, context) -> {
            JsonElement metadataElement;
            String sceneName = null;
            String sceneMetadata = null;
            Type type = new TypeToken<HashMap<Integer, ResourceAction>>(){}.getType();
            JsonObject jsonObject = json.getAsJsonObject();
            JsonElement nameElement = jsonObject.get("sceneName");
            if (null != nameElement) {
                sceneName = nameElement.getAsString();
            }
            if (null != (metadataElement = jsonObject.get("sceneMetadata"))) {
                sceneMetadata = metadataElement.getAsString();
            }
            int sceneId = jsonObject.get("sceneId").getAsInt();
            HashMap resourceActionMap = (HashMap)localGson.fromJson(jsonObject.get("resrcActionArr"), type);
            Scene scene = Factory.createScene(sceneId, null);
            scene.internalSetName(sceneName);
            scene.internalSetMetadata(sceneMetadata);
            for (ResourceAction action : resourceActionMap.values()) {
                scene.internalAddResourceAction(action);
            }
            return scene;
        });
        BUILDER.registerTypeAdapter(Rule.class, (json, typeOfT, context) -> {
            Type resourceConditionsType = new TypeToken<List<ResourceCondition>>(){}.getType();
            Type scheduleConditionsType = new TypeToken<List<ScheduleCondition>>(){}.getType();
            Type resourceActionsType = new TypeToken<List<ResourceAction>>(){}.getType();
            Type sceneActionsType = new TypeToken<List<Scene>>(){}.getType();
            JsonObject jsonObject = json.getAsJsonObject();
            JsonElement nameEle = jsonObject.get("ruleName");
            int ruleId = jsonObject.get("ruleId").getAsInt();
            String ruleName = null == nameEle || !nameEle.isJsonPrimitive() || !nameEle.getAsJsonPrimitive().isString() ? null : nameEle.getAsString();
            List resourceConditions = (List)localGson.fromJson(jsonObject.get("resrcCondnArr"), resourceConditionsType);
            List scheduleConditions = (List)localGson.fromJson(jsonObject.get("schedCondnArr"), scheduleConditionsType);
            List resourceActions = (List)localGson.fromJson(jsonObject.get("resrcActionArr"), resourceActionsType);
            List sceneActions = (List)localGson.fromJson(jsonObject.get("sceneActionArr"), sceneActionsType);
            Rule rule = Factory.createRule(ruleId, null);
            rule.internalSetName(ruleName);
            rule.internalClearAddSceneActions(sceneActions);
            rule.internalClearAddResourceActions(resourceActions);
            rule.internalClearAddResourceConditions(resourceConditions);
            rule.internalClearAddScheduleConditions(scheduleConditions);
            return rule;
        });
        BUILDER.registerTypeAdapter(Network.class, (Object)new JsonDeserializer<Network>(){

            public Network deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                Network.UserRole userRole = (Network.UserRole)((Object)GSON.fromJson(jsonObject.get("networkUserRole").getAsString(), Network.UserRole.class));
                Network.AccessType accessType = (Network.AccessType)((Object)GSON.fromJson(jsonObject.get("networkAccessType").getAsString(), Network.AccessType.class));
                Network.NetworkType networkType = (Network.NetworkType)((Object)GSON.fromJson(jsonObject.get("networkType").getAsString(), Network.NetworkType.class));
                String networkId = jsonObject.get("networkId").getAsString();
                String networkName = jsonObject.get("networkName").getAsString();
                if (deserializationJobs.containsKey(networkId)) {
                    throw new JsonParseException("Network deserialization already in progress");
                }
                Network network = Factory.createNetwork(networkId);
                network.internalSetName(networkName);
                network.internalSetUserRole(userRole);
                network.internalSetAccessType(accessType);
                network.internalSetNetworkType(networkType);
                deserializationJobs.put(networkId, network);
                Type deviceMapType = new TypeToken<HashMap<Long, Device>>(){}.getType();
                HashMap deviceMap = (HashMap)GSON.fromJson(jsonObject.get("networkDevices"), deviceMapType);
                if (null != deviceMap) {
                    for (Device device : deviceMap.values()) {
                        network.internalAddDevice(device);
                        device.internalSetParent(network);
                    }
                }
                Type zoneMapType = new TypeToken<HashMap<Integer, Zone>>(){}.getType();
                HashMap zoneMap = (HashMap)GSON.fromJson(jsonObject.get("networkZones"), zoneMapType);
                if (null != zoneMap) {
                    for (Object zone : zoneMap.values()) {
                        network.internalAddZone((Zone)zone);
                        ((Zone)zone).internalSetParent(network);
                    }
                }
                if (null != deviceMap) {
                    Object defaultZone = network.getZone(0);
                    Objects.requireNonNull(defaultZone);
                    for (Object d : deviceMap.values()) {
                        Iterator<Resource> iterator = ((Device)d).iterator();
                        while (iterator.hasNext()) {
                            Resource r = iterator.next();
                            Object parentZone = r.getParentZone();
                            if (null != parentZone && ((Zone)parentZone).containsResource(r)) continue;
                            Log.d(DeepDeserializer.TAG, "inconsistency detected: resource:" + r + ", zone: " + r.getParentZone() + ", assigning to default zone");
                            ((Zone)defaultZone).internalAddResource(r);
                            r.internalSetParentZone((Zone)defaultZone);
                        }
                    }
                }
                Type sceneMapType = new TypeToken<HashMap<Integer, Scene>>(){}.getType();
                HashMap sceneMap = (HashMap)GSON.fromJson(jsonObject.get("networkScenes"), sceneMapType);
                if (null != sceneMap) {
                    for (Scene scene : sceneMap.values()) {
                        network.internalAddScene(scene);
                        scene.internalSetParent(network);
                    }
                }
                Type ruleMapType = new TypeToken<HashMap<Integer, Rule>>(){}.getType();
                HashMap ruleMap = (HashMap)GSON.fromJson(jsonObject.get("networkRules"), ruleMapType);
                if (null != ruleMap) {
                    for (Rule rule : ruleMap.values()) {
                        network.internalAddRule(rule);
                        rule.internalSetParent(network);
                    }
                }
                deserializationJobs.remove(networkId);
                return network;
            }
        });
        BUILDER.registerTypeAdapter(Device.class, (Object)new JsonDeserializer<Device>(){

            public Device deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                long deviceNodeId = jsonObject.get("gatewayNodeId").getAsLong();
                PowerSource powerSource = (PowerSource)((Object)GSON.fromJson(jsonObject.get("powerSource"), PowerSource.class));
                ReceiverType receiverType = (ReceiverType)((Object)GSON.fromJson(jsonObject.get("receiverType"), ReceiverType.class));
                JsonElement jsonName = jsonObject.get("deviceName");
                JsonElement jsonDevicePsn = jsonObject.get("devicePsn");
                JsonElement jsonProductName = jsonObject.get("productName");
                String name = null == jsonName ? null : jsonName.getAsString();
                String devicePsn = null == jsonDevicePsn ? null : jsonDevicePsn.getAsString();
                String productName = null == jsonProductName ? null : jsonProductName.getAsString();
                JsonElement jsonMake = jsonObject.get("make");
                JsonElement jsonModel = jsonObject.get("model");
                JsonElement jsonFirmwareVersion = jsonObject.get("firmwareVersion");
                JsonElement jsonIsExtendable = jsonObject.get("isExtendable");
                String make = null == jsonMake ? null : jsonMake.getAsString();
                String model = null == jsonModel ? null : jsonModel.getAsString();
                String firmwareVersion = null == jsonFirmwareVersion ? null : jsonFirmwareVersion.getAsString();
                boolean isExtendable = null != jsonIsExtendable && jsonIsExtendable.getAsBoolean();
                Log.d(DeepDeserializer.TAG, "deserialize: Device name: " + name + " ,psn: " + devicePsn + " ,productName: " + productName + " ,make: " + make + " ,model: " + model + " ,firmwareVersion: " + firmwareVersion + " ,isExtendable: " + isExtendable);
                int[] protocolsSupported = (int[])GSON.fromJson(jsonObject.get("protocolIdArr"), int[].class);
                Device device = Factory.createDevice(deviceNodeId, null);
                device.internalSetExtendable(isExtendable);
                device.internalSetProtocolSupported(protocolsSupported);
                if (null != name) {
                    device.internalSetName(name);
                }
                if (null != devicePsn) {
                    device.internalSetDevicePsn(devicePsn);
                }
                if (null != productName) {
                    device.internalSetProductName(productName);
                }
                if (null != make) {
                    device.internalSetMake(make);
                }
                if (null != model) {
                    device.internalSetModel(model);
                }
                if (null != firmwareVersion) {
                    device.internalSetFirmwareVersion(firmwareVersion);
                }
                if (null != powerSource) {
                    device.internalSetPowerSource(powerSource);
                }
                if (null != receiverType) {
                    device.internalSetReceiverType(receiverType);
                }
                Type resourceMapType = new TypeToken<HashMap<String, Resource>>(){}.getType();
                HashMap resourceMap = (HashMap)GSON.fromJson(jsonObject.get("resourceMap"), resourceMapType);
                if (null != resourceMap) {
                    for (Resource resource : resourceMap.values()) {
                        device.internalAddResource(resource);
                        resource.internalSetParentDevice(device);
                    }
                }
                return device;
            }
        });
        BUILDER.registerTypeAdapter(Resource.class, (Object)new JsonDeserializer<Resource>(){

            public Resource deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                JsonElement jsonMetadata = jsonObject.get("metadata");
                JsonElement jsonName = jsonObject.get("resourceName");
                String name = null == jsonName ? null : jsonName.getAsString();
                String metadata = null == jsonMetadata ? null : jsonMetadata.getAsString();
                JsonElement jsonManufacturer = jsonObject.get("manufacturer");
                JsonElement jsonModel = jsonObject.get("model");
                JsonElement jsonFirmware = jsonObject.get("firmwareVersion");
                String manufacturer = null == jsonManufacturer ? null : jsonManufacturer.getAsString();
                String model = null == jsonModel ? null : jsonModel.getAsString();
                String firmware = null == jsonFirmware ? null : jsonFirmware.getAsString();
                Log.d(DeepDeserializer.TAG, "deserialize: Resource manufacturer: " + manufacturer + " ,model: " + model + " ,firmware: " + firmware);
                String resourceEui = jsonObject.get("resourceEui").getAsString();
                Resource resource = Factory.createResource(resourceEui, null, null);
                if (null != name) {
                    resource.internalSetName(name);
                }
                if (null != metadata) {
                    resource.internalSetMetadata(metadata);
                }
                if (null != manufacturer) {
                    resource.internalSetManufacturer(manufacturer);
                }
                if (null != model) {
                    resource.internalSetModel(model);
                }
                if (null != firmware) {
                    resource.internalSetFirmware(firmware);
                }
                PowerSource powerSource = (PowerSource)((Object)GSON.fromJson(jsonObject.get("powerSource"), PowerSource.class));
                ReceiverType receiverType = (ReceiverType)((Object)GSON.fromJson(jsonObject.get("receiverType"), ReceiverType.class));
                RadioProtocol protocol = (RadioProtocol)((Object)GSON.fromJson(jsonObject.get("protocolId"), RadioProtocol.class));
                if (null != powerSource) {
                    resource.internalSetPowerSource(powerSource);
                }
                if (null != receiverType) {
                    resource.internalSetReceiverType(receiverType);
                }
                if (null != protocol) {
                    resource.internalSetProtocol(protocol);
                }
                Type capabilityMapType = new TypeToken<HashMap<Capability.CapabilityId, Capability>>(){}.getType();
                HashMap capabilityMap = (HashMap)GSON.fromJson(jsonObject.get("capabilityMap"), capabilityMapType);
                if (null != capabilityMap) {
                    for (Capability capability : capabilityMap.values()) {
                        resource.internalAddCapability(capability);
                        capability.internalSetParent(resource);
                    }
                }
                return resource;
            }
        });
        BUILDER.registerTypeAdapter(Capability.class, (Object)new JsonDeserializer<Capability>(){

            public Capability deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                Capability.CapabilityId capabilityId = Capability.CapabilityId.valueOf(jsonObject.get("capabilityId").getAsString());
                JsonElement jsonName = jsonObject.get("capabilityName");
                String name = null == jsonName ? null : jsonName.getAsString();
                Capability capability = Factory.createCapability(capabilityId.getInt(), null);
                if (null != name) {
                    capability.internalSetName(name);
                }
                Type commandArrayType = new TypeToken<HashSet<Integer>>(){}.getType();
                HashSet commandArray = (HashSet)GSON.fromJson(jsonObject.get("commandArray"), commandArrayType);
                int[] commandArr = new int[commandArray.size()];
                int index = 0;
                for (Integer cmd : commandArray) {
                    commandArr[index] = cmd;
                    ++index;
                }
                capability.clearAndSetStandardCommandSet(commandArr);
                Type attributeMapType = new TypeToken<HashMap<Integer, Attribute>>(){}.getType();
                HashMap attributeMap = (HashMap)GSON.fromJson(jsonObject.get("attributeMap"), attributeMapType);
                if (null != attributeMap) {
                    for (Attribute attribute : attributeMap.values()) {
                        capability.internalAddAttribute(attribute);
                        attribute.internalSetParent(capability);
                    }
                }
                return capability;
            }
        });
        BUILDER.registerTypeAdapter(Attribute.class, (Object)new JsonDeserializer<Attribute>(){

            public Attribute deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Class<Object> defaultValueClass;
                Class<Object> currentValueClass;
                JsonObject jsonObject = json.getAsJsonObject();
                JsonElement idJson = jsonObject.get("attributeId");
                JsonElement nameJson = jsonObject.get("name");
                JsonElement descJson = jsonObject.get("description");
                JsonElement minReportJson = jsonObject.get("minReportingInterval");
                JsonElement maxReportJson = jsonObject.get("maxReportingInterval");
                if (null == idJson) {
                    throw new JsonParseException("unknown attribute: " + json);
                }
                int id = idJson.getAsInt();
                String name = null == nameJson ? null : nameJson.getAsString();
                String description = null == descJson ? null : descJson.getAsString();
                long minReportingInterval = null == minReportJson ? Long.MAX_VALUE : minReportJson.getAsLong();
                long maxReportingInterval = null == maxReportJson ? Long.MAX_VALUE : maxReportJson.getAsLong();
                int arrayLength = jsonObject.get("arrayLength").getAsInt();
                Log.d(DeepDeserializer.TAG, "deserialize: id: " + id + ", name: " + name + " ,description: " + description + " ,arrayLength: " + arrayLength);
                Attribute.DataType dataType = (Attribute.DataType)((Object)GSON.fromJson(jsonObject.get("attributeDataType"), Attribute.DataType.class));
                switch (dataType) {
                    case BOOLEAN: {
                        defaultValueClass = currentValueClass = Boolean.TYPE;
                        break;
                    }
                    case BOOLEAN_ARR: {
                        defaultValueClass = Boolean.TYPE;
                        currentValueClass = boolean[].class;
                        break;
                    }
                    case STRING: 
                    case JSON: {
                        currentValueClass = String.class;
                        defaultValueClass = String.class;
                        break;
                    }
                    case STRING_ARR: 
                    case JSON_ARR: {
                        defaultValueClass = String.class;
                        currentValueClass = String[].class;
                        break;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        defaultValueClass = currentValueClass = Double.TYPE;
                        break;
                    }
                    case FLOAT_ARR: 
                    case DOUBLE_ARR: {
                        defaultValueClass = Double.TYPE;
                        currentValueClass = double[].class;
                        break;
                    }
                    case UINT8: 
                    case UINT16: 
                    case INT8: 
                    case INT16: 
                    case INT32: {
                        defaultValueClass = currentValueClass = Integer.TYPE;
                        break;
                    }
                    case UINT32: 
                    case UINT64: 
                    case INT64: {
                        defaultValueClass = currentValueClass = Long.TYPE;
                        break;
                    }
                    case UINT8_ARR: 
                    case UINT16_ARR: 
                    case INT8_ARR: 
                    case INT16_ARR: 
                    case INT32_ARR: {
                        defaultValueClass = Integer.TYPE;
                        currentValueClass = int[].class;
                        break;
                    }
                    case UINT32_ARR: 
                    case UINT64_ARR: 
                    case INT64_ARR: {
                        defaultValueClass = Long.TYPE;
                        currentValueClass = long[].class;
                        break;
                    }
                    default: {
                        currentValueClass = null;
                        defaultValueClass = null;
                    }
                }
                if (null == defaultValueClass) {
                    throw new JsonParseException("unknown data type");
                }
                Object minValue = GSON.fromJson(jsonObject.get("minValue"), defaultValueClass);
                Object maxValue = GSON.fromJson(jsonObject.get("maxValue"), defaultValueClass);
                Object defaultValue = GSON.fromJson(jsonObject.get("defaultValue"), defaultValueClass);
                Object currentValue = GSON.fromJson(jsonObject.get("value"), currentValueClass);
                Log.d(DeepDeserializer.TAG, "deserialize: minValue: " + minValue + ", maxValue: " + maxValue + ", defaultValue: " + defaultValue + ", currentValue: " + currentValue);
                Attribute attribute = Factory.createAttribute(id, null);
                if (null != name) {
                    attribute.internalSetName(name);
                }
                if (null != description) {
                    attribute.internalSetDescription(description);
                }
                attribute.internalSetDataType(dataType.getInt());
                attribute.internalSetArrayLength(arrayLength);
                attribute.internalSetMinValue(minValue);
                attribute.internalSetMaxValue(maxValue);
                attribute.internalSetCurrentValue(currentValue);
                attribute.internalSetDefaultValue(defaultValue);
                attribute.internalSetMinReportingInterval(minReportingInterval);
                attribute.internalSetMaxReportingInterval(maxReportingInterval);
                return attribute;
            }
        });
        GSON = BUILDER.create();
    }
}

