/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityMediaStreaming;
import buzz.getcoco.iot.CapabilitySnapshot;
import buzz.getcoco.iot.CapabilityTunnel;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Context;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.InfoRequest;
import buzz.getcoco.iot.InfoResponse;
import buzz.getcoco.iot.JniLoader;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.Native;
import buzz.getcoco.iot.NativeException;
import buzz.getcoco.iot.NativeInterface;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.ResourceAction;
import buzz.getcoco.iot.Scene;
import com.google.gson.Gson;
import java.nio.ByteBuffer;
import java.util.Map;

class DefaultNativeHandler
extends NativeInterface {
    private static final String TAG = "NativeInterface";
    private static final String LISTENER_NULL = "listener is null";

    DefaultNativeHandler() {
    }

    private void verifyReturnValue(int retVal) {
        if (0 > retVal) {
            throw new NativeException(this.getErrorMessage());
        }
    }

    @Override
    protected void init(String cwdPath, String appAccessList, String clientId, String downloadPath, CocoClient.ConnectivityTimers timers) {
        JniLoader.load(cwdPath);
        int retVal = Native.nativeInit(cwdPath, appAccessList, clientId, downloadPath, timers.fastRetryDuration, timers.backgroundMaxRetryPeriod, timers.foregroundMaxRetryPeriod, timers.keepAliveInterval, timers.keepAliveTimeout);
        this.verifyReturnValue(retVal);
    }

    @Override
    protected Network[] getSavedNetworks() {
        Network[] networks = Native.nativeGetSavedNetworks();
        if (null == networks) {
            return null;
        }
        for (int i = 0; i < networks.length; ++i) {
            Object n = CocoClient.getInstance().getNetwork(networks[i].getId());
            if (null == n) continue;
            networks[i] = n;
        }
        return networks;
    }

    @Override
    protected void getAllNetworks(CocoClient.NetworkListListener listener) {
        int retVal = Native.nativeGetAllNetworks(new Context(listener, null));
        if (0 > retVal) {
            if (null != listener) {
                listener.onResponse(null, new NativeException(this.getErrorMessage()));
            } else {
                Log.d(TAG, "getAllNetworks: listener is null");
            }
        }
    }

    @Override
    protected void connect(Network network, int port) {
        int retVal = Native.nativeConnect(network.getId(), port, new Context(null, new Network.SdkContext(network.getId())));
        this.verifyReturnValue(retVal);
    }

    @Override
    protected void disconnect(Network network) {
        int retVal = Native.nativeDisconnect(network.getId());
        this.verifyReturnValue(retVal);
    }

    @Override
    protected void leaveNetwork(Network network, Network.LeaveStatusListener listener) {
        int retVal = Native.nativeLeaveNetwork(network.getId(), new Context(listener, network));
        if (0 > retVal) {
            if (null != listener) {
                listener.onResponse(null, new NativeException(this.getErrorMessage()));
            } else {
                Log.d(TAG, "leaveNetwork: listener is null");
            }
        }
    }

    @Override
    protected void sendInfoResponse(InfoResponse infoResponse, Device.InfoResponseStatusListener listener) {
        int retVal = Native.nativeSendInfoResponse(infoResponse.networkId, infoResponse.getRequestNodeId(), infoResponse.getInfoRequestId(), infoResponse.getCmdSeqNum(), infoResponse.toJson().toString(), new Context(listener, infoResponse));
        if (0 > retVal) {
            if (null != listener) {
                listener.onInfoResponseStatus(null, new NativeException(this.getErrorMessage()));
            } else {
                Log.d(TAG, "sendInfoResponse: listener is null");
            }
        }
    }

    @Override
    protected void sendResourceCommand(Capability capability, Command<? extends Capability.CommandId> command, Capability.CommandStatusListener<?> listener) {
        int cmdId = command.getCommandId().getInt();
        int capabilityId = capability.getId().getInt();
        String jsonCommand = command.toJsonObject().toString();
        String jsonCommandToSend = !jsonCommand.equals("{}") ? String.format("{\"capabilityId\":%d, \"cmdId\":%d, \"cmdParams\": %s}", capabilityId, cmdId, jsonCommand) : String.format("{\"capabilityId\":%d, \"cmdId\":%d}", capabilityId, cmdId);
        command.setTag(new Command.CapabilityTag(capability));
        Log.d(TAG, "resourceCommand: " + jsonCommandToSend);
        String networkId = ((Device)capability.getParent().getParent()).getParent().getId();
        long deviceNodeId = ((Device)capability.getParent().getParent()).getId();
        String resourceEui = capability.getParent().getId();
        int retVal = Native.nativeSendResourceCommand(networkId, deviceNodeId, resourceEui, capabilityId, cmdId, command.getTimeout(), new Context(listener, command), jsonCommandToSend);
        if (0 > retVal) {
            if (null != listener) {
                listener.onCommandStatus(null, new NativeException(this.getErrorMessage()));
            } else {
                Log.d(TAG, "sendResourceCommand: listener is null");
            }
        }
    }

    @Override
    protected void setTokens(String response) {
        int retVal = Native.nativeSetTokens(response);
        this.verifyReturnValue(retVal);
    }

    @Override
    protected void openTunnel(Capability tunnel, String forwardHostName, int forwardHostPort, String listeningHostName, int listeningHostPort, CapabilityTunnel.IpVersion ipVersion, CapabilityTunnel.Protocol tunnelProtocol, CapabilityTunnel.TunnelType tunnelType, CapabilityTunnel.TransportType transportType, long timeout, CapabilityTunnel.TunnelStatusListener listener) {
        Resource resource = tunnel.getParent();
        Object device = resource.getParent();
        Network network = ((Device)device).getParent();
        int retVal = Native.nativeOpenTunnel(network.getId(), ((Device)device).getId(), resource.getId(), forwardHostName, forwardHostPort, listeningHostName, listeningHostPort, ipVersion.getInt(), tunnelProtocol.getInt(), tunnelType.getInt(), transportType.getInt(), timeout, new Context(listener, tunnel));
        if (0 > retVal) {
            if (null != listener) {
                listener.onStatusChanged(0L, 0, CapabilityTunnel.State.OPEN_FAILED);
            } else {
                Log.d(TAG, "openTunnel: listener is null");
            }
        }
    }

    @Override
    protected void closeTunnel(Capability tunnel, long tunnelHandle, long timeout) {
        Network network = ((Device)tunnel.getParent().getParent()).getParent();
        int retVal = Native.nativeCloseTunnel(network.getId(), tunnelHandle, timeout);
        this.verifyReturnValue(retVal);
    }

    @Override
    protected void getAccessTokens(CocoClient.AccessTokensListener listener) {
        int retVal = Native.nativeGetAccessTokens(new Context(listener, null));
        if (0 > retVal) {
            if (null != listener) {
                listener.onResponse(null, new NativeException(this.getErrorMessage()));
            } else {
                Log.d(TAG, "getAccessTokens: listener is null");
            }
        }
    }

    @Override
    protected void sendNetworkManagementCommand(Network network, Command<Network.CommandId> command, Network.NetworkManagementStatusListener listener) {
        String jsonCommand = command.toJsonObject().toString();
        String jsonCommandToSend = !jsonCommand.equals("{}") ? String.format("{\"cmdId\":%d, \"cmdParams\":%s}", command.getCommandId().getInt(), jsonCommand) : String.format("{\"cmdId\":%d}", command.getCommandId().getInt());
        command.setTag(new Command.NetworkTag(network));
        Log.d(TAG, "networkCommand: " + jsonCommandToSend);
        int retVal = Native.nativeSendNetworkManagementCommand(network.getId(), command.getTimeout(), jsonCommandToSend, new Context(listener, command));
        if (0 > retVal) {
            if (null != listener) {
                listener.onStatusChanged(null, new NativeException(this.getErrorMessage()));
            } else {
                Log.d(TAG, "sendNetworkManagementCommand: listener is null");
            }
        }
    }

    @Override
    protected void sendDeviceManagementCommand(Device device, Command<Device.CommandId> command, Device.DeviceManagementStatusListener listener) {
        String jsonCommand = command.toJsonObject().toString();
        String jsonCommandToSend = !jsonCommand.equals("{}") ? String.format("{\"cmdId\":%d, \"cmdParams\":%s}", command.getCommandId().getInt(), jsonCommand) : String.format("{\"cmdId\":%d}", command.getCommandId().getInt());
        command.setTag(new Command.DeviceTag(device));
        Log.d(TAG, "deviceCommand: " + jsonCommandToSend);
        int retVal = Native.nativeSendDeviceManagementCommand(device.getParent().getId(), device.getId(), command.getTimeout(), jsonCommandToSend, new Context(listener, command));
        if (0 > retVal) {
            if (null != listener) {
                listener.onStatusChanged(null, null, new NativeException(this.getErrorMessage()));
            } else {
                Log.d(TAG, "sendDeviceManagementCommand: listener is null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeScene(Scene scene) {
        Map<Integer, ResourceAction> actionMap;
        Map<Integer, ResourceAction> map = actionMap = scene.getResourceActionMap();
        synchronized (actionMap) {
            int i = 0;
            Gson gson = Command.GSON_BUILDER.create();
            String[] actions = new String[actionMap.size()];
            for (ResourceAction action : actionMap.values()) {
                actions[i++] = gson.toJson((Object)action);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            int retVal = Native.nativeExecuteScene(scene.getParent().getId(), scene.getId(), scene.getName(), scene.getMetadata(), actions);
            this.verifyReturnValue(retVal);
            return;
        }
    }

    @Override
    protected void connectWithInvite(Network network, String inviteUrl, long nodeId) {
        int retVal = Native.nativeConnectWithInvite(inviteUrl, network.getId(), network.getName(), network.getNetworkType().getInt(), network.getUserRole().getInt(), network.getAccessType().getInt(), nodeId, new Context(null, new Network.SdkContext(network.getId())));
        this.verifyReturnValue(retVal);
    }

    @Override
    protected void sendInfoRequest(InfoRequest infoRequest, Device.InfoRequestStatusListener listener) {
        String infoRequestJson = infoRequest.toJson().toString();
        Log.d(TAG, "sendInfoRequest: " + infoRequestJson);
        int retVal = Native.nativeSendInfoRequest(infoRequest.networkId, infoRequest.deviceNodeId, infoRequest.requestId, infoRequest.timeout, infoRequest.messageText, infoRequestJson, new Context(listener, infoRequest));
        if (0 > retVal) {
            if (null != listener) {
                listener.onInfoRequestStatus(infoRequest, new NativeException(this.getErrorMessage()));
            } else {
                Log.d(TAG, "sendInfoRequest: listener is null");
            }
        }
    }

    @Override
    protected void startMediaStream(Capability capability, long streamId, int streamSessionId, String streamDescription, int[] channelPorts, CapabilityMediaStreaming.TransportType[] transportTypes, CapabilityMediaStreaming.MediaSessionType sessionType, long timeout, CapabilityMediaStreaming.MediaStreamListener listener) {
        int[] nativeTransportTypes = new int[transportTypes.length];
        Resource resource = capability.getParent();
        Object device = resource.getParent();
        Network network = ((Device)device).getParent();
        for (int i = 0; i < transportTypes.length; ++i) {
            nativeTransportTypes[i] = transportTypes[i].getInt();
        }
        int retVal = Native.nativeStartMediaStream(network.getId(), ((Device)device).getId(), resource.getId(), capability.getId().getInt(), streamId, streamSessionId, streamDescription, channelPorts, nativeTransportTypes, sessionType.getInt(), timeout, new Context(listener, null));
        if (0 > retVal) {
            if (null != listener) {
                listener.onStatusChanged(0L, 0, CapabilityMediaStreaming.Status.FAILED);
            } else {
                Log.d(TAG, "startMediaStream: listener is null");
            }
        }
    }

    @Override
    protected void stopMediaStream(long streamHandle) {
        if (0L == streamHandle) {
            throw new NullPointerException("pass a handle that was passed in callback");
        }
        int retVal = Native.nativeStopMediaStream(streamHandle);
        this.verifyReturnValue(retVal);
    }

    @Override
    protected void captureSnapshot(Capability capability, String downloadPath, int heightPx, int widthPx, long timeout, CapabilitySnapshot.SnapshotListener listener) {
        Resource resource = capability.getParent();
        Object device = resource.getParent();
        Network network = ((Device)device).getParent();
        int retVal = Native.nativeCaptureSnapshot(network.getId(), ((Device)device).getId(), resource.getId(), downloadPath, heightPx, widthPx, timeout, new Context(listener, null));
        if (0 > retVal) {
            if (null != listener) {
                listener.onSnapshotCaptured(null, 2);
            } else {
                Log.d(TAG, "captureSnapshot: listener is null");
            }
        }
    }

    @Override
    protected int sendMediaStreamData(long streamHandle, int channelPort, long frameIndex, int frameType, long frameDuration, long framePts, ByteBuffer data) {
        if (0L == streamHandle) {
            throw new NullPointerException("pass a handle that was passed in callback");
        }
        int dataQueuedSize = Native.nativeSendMediaStreamData(streamHandle, channelPort, frameIndex, frameType, frameDuration, framePts, data.limit(), data);
        if (-1 == dataQueuedSize) {
            throw new NativeException(this.getErrorMessage());
        }
        return dataQueuedSize;
    }

    @Override
    protected int[] getAvailableChannelPorts(Device device, int portCount) {
        return Native.nativeGetAvailableChannelPorts(device.getParent().getId(), device.getId(), portCount);
    }

    @Override
    protected Resource getHandlingResource(long streamHandle) {
        if (0L == streamHandle) {
            throw new NullPointerException("stream handle cannot be 0 in a fetch");
        }
        String networkId = Native.nativeGetHandlingNetworkId(streamHandle);
        long deviceNodeId = Native.nativeGetHandlingDeviceId(streamHandle);
        String resourceEui = Native.nativeGetHandlingResourceId(streamHandle);
        Network network = CocoClient.getInstance().getNetworkMap().get(networkId);
        Device device = null == network ? null : (Device)network.getDevice(deviceNodeId);
        return null == device ? null : (Resource)device.getResource(resourceEui);
    }

    @Override
    protected long getHandlingStreamId(long streamHandle) {
        if (0L == streamHandle) {
            throw new NullPointerException("stream handle cannot be 0 in a fetch");
        }
        return Native.nativeGetHandlingStreamId(streamHandle);
    }

    @Override
    protected int getHandlingStreamSessionId(long streamHandle) {
        if (0L == streamHandle) {
            throw new NullPointerException("stream handle cannot be 0 in a fetch");
        }
        return Native.nativeGetHandlingStreamSessionId(streamHandle);
    }

    @Override
    protected int[] getHandlingChannelPorts(long streamHandle) {
        if (0L == streamHandle) {
            throw new NullPointerException("stream handle cannot be 0 in a fetch");
        }
        return Native.nativeGetHandlingChannelPorts(streamHandle);
    }

    @Override
    protected String getVersion() {
        return Native.nativeGetVersion();
    }

    @Override
    protected void setConnectivityMode(CocoClient.ConnectivityMode mode) {
        int retVal = Native.nativeSetConnectivityMode(mode.getInt());
        this.verifyReturnValue(retVal);
    }

    @Override
    protected void invalidateAccessToken() {
        int retVal = Native.nativeInvalidateAccessToken();
        this.verifyReturnValue(retVal);
    }

    @Override
    protected void informNetworkChange() {
        int retVal = Native.nativeInformNetworkChange();
        this.verifyReturnValue(retVal);
    }

    @Override
    protected void sendData(Network network, String data, long[] nodeIds) {
        int retVal = Native.nativeSendData(network.getId(), data, nodeIds);
        this.verifyReturnValue(retVal);
    }

    @Override
    protected void sendContentInfo(Network network, long contentTime, String data, long[] nodeIds) {
        int retVal = Native.nativeSendContentInfo(network.getId(), contentTime, data, nodeIds);
        this.verifyReturnValue(retVal);
    }

    private String getErrorMessage() {
        return "Internal Native Error";
    }
}

