/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.CommandIdInterface;
import buzz.getcoco.iot.CommandResponse;
import buzz.getcoco.iot.InfoRequest;
import buzz.getcoco.iot.InfoResponse;
import buzz.getcoco.iot.Listener;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.MessageType;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Parameter;
import buzz.getcoco.iot.PowerSource;
import buzz.getcoco.iot.RadioProtocol;
import buzz.getcoco.iot.ReceiverType;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Device
implements Iterable<Resource> {
    private static final String TAG = "Device";
    private static final String NOT_AN_EXTENDABLE_DEVICE_MESSAGE = "the selected device is not an extendable device to send commands";
    @SerializedName(value="gatewayNodeId")
    private final long deviceNodeId;
    @SerializedName(value="deviceName")
    private String name;
    @SerializedName(value="devicePsn")
    private String devicePsn;
    @SerializedName(value="productName")
    private String productName;
    @SerializedName(value="make")
    private String make;
    @SerializedName(value="model")
    private String model;
    @SerializedName(value="firmwareVersion")
    private String firmwareVersion;
    @SerializedName(value="powerSource")
    private PowerSource powerSource;
    @SerializedName(value="receiverType")
    private ReceiverType receiverType;
    @SerializedName(value="isExtendable")
    private boolean isExtendable = false;
    @SerializedName(value="protocolIdArr")
    private int[] supportedProtocols;
    private transient Network parent;
    private transient boolean ready = false;
    private transient long supportedProtocolFlags = -1L;
    @SerializedName(value="resourceMap")
    private Map<String, Resource> resourceMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Device(long deviceNodeId, Network parent) {
        this.deviceNodeId = deviceNodeId;
        this.parent = parent;
    }

    public void sendDeviceManagementCommand(Command<CommandId> command, DeviceManagementStatusListener listener) {
        if (!(CommandId.ADD_RES != command.getCommandId() && CommandId.DISCOVER_RES != command.getCommandId() || this.isExtendable)) {
            throw new IllegalArgumentException(NOT_AN_EXTENDABLE_DEVICE_MESSAGE);
        }
        CocoClient.getInstance().getNativeHandler().sendDeviceManagementCommand(this, command, listener);
    }

    public void reboot(DeviceManagementStatusListener listener) {
        this.sendDeviceManagementCommand(new Command<CommandId>(CommandId.REBOOT), listener);
    }

    protected void setResourceName(Resource resource, String name, DeviceManagementStatusListener listener) {
        this.sendDeviceManagementCommand(new SetResourceName(resource, name), listener);
    }

    protected void setResourceMetadata(Resource resource, String metadata, DeviceManagementStatusListener listener) {
        this.sendDeviceManagementCommand(new SetResourceMetadata(resource, metadata), listener);
    }

    public final long getId() {
        return this.deviceNodeId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExtendable() {
        return this.isExtendable;
    }

    public final Network getParent() {
        return this.parent;
    }

    public Map<String, Resource> getResourceMap() {
        if (null == this.resourceMap) {
            this.resourceMap = new ConcurrentHashMap<String, Resource>();
        }
        return this.resourceMap;
    }

    public final <T extends Resource> T getResource(String resourceEui) {
        return (T)((Resource)Utils.castUp(this.getResourceMap().get(resourceEui)));
    }

    public boolean isReady() {
        return this.ready;
    }

    public void discoverResources(RadioProtocol protocol, DiscoverResourceListener listener) {
        this.discoverResources(protocol, Command.defaultTimeOut, listener);
    }

    public void discoverResources(RadioProtocol protocol, long timeout, DiscoverResourceListener listener) {
        if (!this.isExtendable) {
            throw new IllegalArgumentException(NOT_AN_EXTENDABLE_DEVICE_MESSAGE);
        }
        this.sendDeviceManagementCommand(new DiscoverResource(protocol).setTimeout(timeout), listener);
    }

    public void addZwaveResource(String metadata, List<Parameter<InfoResponse.Value>> parameters, long timeout, AddResourceListener listener) {
        if (!this.isExtendable) {
            throw new IllegalArgumentException(NOT_AN_EXTENDABLE_DEVICE_MESSAGE);
        }
        this.sendDeviceManagementCommand(new AddResource(metadata, parameters).setTimeout(timeout), listener);
    }

    public void addZigbeeResource(String resourceEui, String metadata, List<Parameter<InfoResponse.Value>> parameters, long timeout, AddResourceListener listener) {
        if (!this.isExtendable) {
            throw new IllegalArgumentException(NOT_AN_EXTENDABLE_DEVICE_MESSAGE);
        }
        this.sendDeviceManagementCommand(new AddResource(resourceEui, metadata, parameters).setTimeout(timeout), listener);
    }

    public void addTuyaResource(String metadata, List<Parameter<InfoResponse.Value>> parameters, long timeout, AddResourceListener listener) {
        if (!this.isExtendable) {
            throw new IllegalArgumentException(NOT_AN_EXTENDABLE_DEVICE_MESSAGE);
        }
        this.sendDeviceManagementCommand(new AddResource(RadioProtocol.TUYA, metadata, parameters).setTimeout(timeout), listener);
    }

    public void removeResource(Resource resource, List<Parameter<InfoResponse.Value>> parameters, long timeout, RemoveResourceListener listener) {
        if (!this.isExtendable) {
            throw new IllegalArgumentException(NOT_AN_EXTENDABLE_DEVICE_MESSAGE);
        }
        this.sendDeviceManagementCommand(new RemoveResource(resource, parameters).setTimeout(timeout), listener);
    }

    public void forceRemoveResource(Resource resource, RemoveResourceListener listener) {
        if (!this.isExtendable) {
            throw new IllegalArgumentException(NOT_AN_EXTENDABLE_DEVICE_MESSAGE);
        }
        this.sendDeviceManagementCommand(new ForceRemoveResource(resource), listener);
    }

    public void configureWiFi(String ssid, String password, DeviceManagementStatusListener listener) {
        this.sendDeviceManagementCommand(new ConfigureWiFi(ssid, password), listener);
    }

    public void sendInfoResponse(InfoResponse infoResponse, InfoResponseStatusListener listener) {
        if (0L > infoResponse.getRequestNodeId()) {
            infoResponse.setRequestNodeId(this.deviceNodeId);
        }
        CocoClient.getInstance().getNativeHandler().sendInfoResponse(infoResponse, listener);
    }

    public void sendInfoRequest(InfoRequest infoRequest, InfoRequestStatusListener listener) {
        infoRequest.deviceNodeId = this.deviceNodeId;
        infoRequest.networkId = this.parent.getId();
        CocoClient.getInstance().getNativeHandler().sendInfoRequest(infoRequest, listener);
    }

    public String getDevicePsn() {
        return this.devicePsn;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getMake() {
        return this.make;
    }

    public String getModel() {
        return this.model;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public PowerSource getPowerSource() {
        return this.powerSource;
    }

    public ReceiverType getReceiverType() {
        return this.receiverType;
    }

    public int[] getAvailableChannelPorts(int portCount) {
        return CocoClient.getInstance().getNativeHandler().getAvailableChannelPorts(this, portCount);
    }

    private boolean supportsProtocol(int protocol) {
        if (null == this.supportedProtocols) {
            return true;
        }
        for (int supportedProtocol : this.supportedProtocols) {
            if (protocol != supportedProtocol) continue;
            return true;
        }
        return false;
    }

    public boolean supportsProtocol(RadioProtocol radioProtocol) {
        int protocolInt = radioProtocol.getInt();
        long protocolFlag = 1L << protocolInt;
        return (this.supportedProtocolFlags & protocolFlag) == protocolFlag;
    }

    protected void internalSetProtocolSupported(int[] supportedProtocols) {
        if (null == supportedProtocols) {
            Log.d(TAG, "ignoring supported protocols");
            return;
        }
        this.supportedProtocols = supportedProtocols;
        this.supportedProtocolFlags = 0L;
        for (int sp : this.supportedProtocols) {
            this.supportedProtocolFlags |= 1L << sp;
        }
    }

    public List<RadioProtocol> getSupportedProtocols() {
        if (null == this.supportedProtocols) {
            return Collections.emptyList();
        }
        ArrayList<RadioProtocol> radioProtocols = new ArrayList<RadioProtocol>(3);
        for (int sp : this.supportedProtocols) {
            radioProtocols.add(RadioProtocol.getEnum(sp));
        }
        return radioProtocols;
    }

    protected void internalRemoveDevice() {
    }

    protected void internalSetName(String deviceName) {
        this.name = deviceName;
    }

    protected void internalSetDevicePsn(String devicePsn) {
        this.devicePsn = devicePsn;
    }

    protected void internalSetProductName(String productName) {
        this.productName = productName;
    }

    protected void internalSetMake(String make) {
        this.make = make;
    }

    protected void internalSetModel(String model) {
        this.model = model;
    }

    protected void internalSetFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    protected void internalSetPowerSource(PowerSource powerSource) {
        this.powerSource = powerSource;
    }

    protected void internalSetReceiverType(ReceiverType receiverType) {
        this.receiverType = receiverType;
    }

    protected void internalSetExtendable(boolean extendable) {
        this.isExtendable = extendable;
    }

    protected void internalSetParent(Network parent) {
        this.parent = parent;
    }

    protected void internalSetReady(boolean ready) {
        this.ready = ready;
    }

    public boolean containsResource(String resourceEui) {
        return this.getResourceMap().containsKey(resourceEui);
    }

    protected void internalAddResource(Resource resource) {
        this.getResourceMap().put(resource.getId(), resource);
    }

    protected void internalRemoveResource(String resourceEui) {
        this.getResourceMap().remove(resourceEui);
    }

    public final int hashCode() {
        return Long.hashCode(this.getId());
    }

    public String toString() {
        return "Device{deviceNodeId=" + this.deviceNodeId + ", name='" + this.name + '\'' + ", devicePsn='" + this.devicePsn + '\'' + ", productName='" + this.productName + '\'' + ", make='" + this.make + '\'' + ", model='" + this.model + '\'' + ", firmwareVersion='" + this.firmwareVersion + '\'' + ", powerSource=" + (Object)((Object)this.powerSource) + ", receiverType=" + (Object)((Object)this.receiverType) + ", isExtendable=" + this.isExtendable + ", supportedProtocols=" + Arrays.toString(this.supportedProtocols) + ", parent=" + this.parent + ", ready=" + this.ready + ", supportedProtocolFlags=" + this.supportedProtocolFlags + ", resourceMap=" + this.resourceMap + '}';
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.getResourceMap().values().iterator();
    }

    static {
        boolean bl = $assertionsDisabled = !Device.class.desiredAssertionStatus();
        if (!$assertionsDisabled && PowerSource.values().length > 64) {
            throw new AssertionError();
        }
    }

    public static interface RemoveResourceListener
    extends DeviceManagementStatusListener,
    MessageListener {
    }

    public static interface AddResourceListener
    extends DeviceManagementStatusListener,
    InfoRequestListener,
    MessageListener {
    }

    public static interface DiscoverResourceListener
    extends DeviceManagementStatusListener,
    InfoRequestListener,
    MessageListener {
    }

    public static interface InfoResponseStatusListener
    extends Listener {
        public void onInfoResponseStatus(InfoResponse var1, Throwable var2);
    }

    public static interface InfoRequestStatusListener
    extends Listener {
        public void onInfoRequestStatus(InfoRequest var1, Throwable var2);

        public void onInfoResponse(InfoResponse var1);
    }

    public static interface InfoRequestListener
    extends Listener {
        public void onInfoRequest(InfoRequest var1);
    }

    public static interface MessageListener
    extends Listener {
        public void onMessage(String var1, String var2, MessageType var3);
    }

    public static interface DeviceManagementStatusListener
    extends Listener {
        public void onStatusChanged(CommandResponse<CommandId> var1, Resource[] var2, Throwable var3);
    }

    public static class ConfigureWiFi
    extends Command<CommandId> {
        @SerializedName(value="ssid")
        public String ssid;
        @SerializedName(value="password")
        public String password;

        public ConfigureWiFi() {
            super(CommandId.CONFIGURE_WIFI);
        }

        public ConfigureWiFi(String ssid, String password) {
            this();
            this.ssid = ssid;
            this.password = password;
        }
    }

    public static class ForceRemoveResource
    extends Command<CommandId> {
        @SerializedName(value="resourceEui")
        public String resourceEui;

        public ForceRemoveResource(Resource resource) {
            super(CommandId.FORCE_REM_RES);
            this.resourceEui = resource.getId();
        }
    }

    public static class RemoveResource
    extends Command<CommandId> {
        @SerializedName(value="resourceEui")
        public String resourceEui;
        @SerializedName(value="paramArr")
        public List<Parameter<InfoResponse.Value>> parameters;

        public RemoveResource(Resource resource, List<Parameter<InfoResponse.Value>> parameters) {
            super(CommandId.REM_RES);
            this.resourceEui = resource.getId();
            this.parameters = null == parameters ? Collections.emptyList() : new ArrayList<Parameter<InfoResponse.Value>>(parameters);
        }
    }

    public static class AddResource
    extends Command<CommandId> {
        @SerializedName(value="protocolId")
        public RadioProtocol protocolId;
        @SerializedName(value="resourceEui")
        public String resourceEui = null;
        @SerializedName(value="metadata")
        public String metadata;
        @SerializedName(value="paramArr")
        public List<Parameter<InfoResponse.Value>> parameters;

        private AddResource(RadioProtocol protocol, String metadata, List<Parameter<InfoResponse.Value>> parameters) {
            super(CommandId.ADD_RES);
            this.protocolId = protocol;
            this.metadata = metadata;
            this.parameters = null == parameters ? Collections.emptyList() : new ArrayList<Parameter<InfoResponse.Value>>(parameters);
        }

        public AddResource(String metadata, List<Parameter<InfoResponse.Value>> parameters) {
            this(RadioProtocol.ZWAVE, metadata, parameters);
            this.resourceEui = null;
        }

        public AddResource(String resourceEui, String metadata, List<Parameter<InfoResponse.Value>> parameters) {
            this(RadioProtocol.ZIGBEE, metadata, parameters);
            this.resourceEui = resourceEui;
        }
    }

    public static class DiscoverResource
    extends Command<CommandId> {
        @SerializedName(value="protocolId")
        public RadioProtocol protocol;

        public DiscoverResource(RadioProtocol radioProtocol) {
            super(CommandId.DISCOVER_RES);
            this.protocol = radioProtocol;
        }
    }

    public static class SetResourceMetadata
    extends Command<CommandId> {
        @SerializedName(value="resourceEui")
        public String resourceEui;
        @SerializedName(value="metadata")
        public String resourceMetadata;

        public SetResourceMetadata(Resource resource, String metadata) {
            super(CommandId.UPD_RES_META);
            this.resourceMetadata = metadata;
            this.resourceEui = resource.getId();
        }
    }

    public static class SetResourceName
    extends Command<CommandId> {
        @SerializedName(value="resourceEui")
        public String resourceEui;
        @SerializedName(value="resourceName")
        public String resourceName;

        public SetResourceName(Resource resource, String newName) {
            super(CommandId.UPD_RES_NAME);
            this.resourceName = newName;
            this.resourceEui = resource.getId();
        }
    }

    public static enum CommandId implements CommandIdInterface
    {
        DISCOVER_RES,
        ADD_RES,
        REM_RES,
        REBOOT,
        UPD_RES_NAME,
        UPD_RES_META,
        FORCE_REM_RES,
        CONFIGURE_WIFI;


        static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }
}

