/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Log;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

class Formatters {
    private static final String TAG = "Formatters";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Object ACCESS_LOCK = new Object();
    private static ZoneId zoneId = ZoneOffset.UTC;
    private static DateTimeFormatter dateFormatter;
    private static DateTimeFormatter timeFormatter;
    private static DateTimeFormatter dateTimeFormatter;

    Formatters() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTimezone(ZoneId zoneId) {
        if (null == zoneId) {
            throw new IllegalArgumentException("invalid zone id");
        }
        Log.d(TAG, "changing to zone: " + zoneId + ", from zone: " + Formatters.getZoneId());
        if (zoneId.equals(Formatters.getZoneId())) {
            return;
        }
        Object object = ACCESS_LOCK;
        synchronized (object) {
            dateFormatter = null;
            timeFormatter = null;
            dateTimeFormatter = null;
            Formatters.zoneId = zoneId;
        }
    }

    static ZoneId getZoneId() {
        return zoneId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DateTimeFormatter getDateFormatter() {
        DateTimeFormatter copy = dateFormatter;
        if (null != copy) {
            return copy;
        }
        Object object = ACCESS_LOCK;
        synchronized (object) {
            DateTimeFormatter dateFormatter = Formatters.dateFormatter;
            if (null != dateFormatter) {
                return dateFormatter;
            }
            Formatters.dateFormatter = dateFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT).withZone(Formatters.getZoneId());
            return Formatters.dateFormatter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DateTimeFormatter getTimeFormatter() {
        DateTimeFormatter copy = timeFormatter;
        if (null != copy) {
            return copy;
        }
        Object object = ACCESS_LOCK;
        synchronized (object) {
            DateTimeFormatter timeFormatter = Formatters.timeFormatter;
            if (null != timeFormatter) {
                return timeFormatter;
            }
            Formatters.timeFormatter = timeFormatter = DateTimeFormatter.ofPattern(TIME_FORMAT).withZone(Formatters.getZoneId());
            return Formatters.timeFormatter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DateTimeFormatter getDateTimeFormatter() {
        DateTimeFormatter copy = dateFormatter;
        if (null != copy) {
            return copy;
        }
        Object object = ACCESS_LOCK;
        synchronized (object) {
            DateTimeFormatter dateTimeFormatter = Formatters.dateTimeFormatter;
            if (null != dateTimeFormatter) {
                return dateTimeFormatter;
            }
            Formatters.dateTimeFormatter = dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_TIME_FORMAT).withZone(Formatters.getZoneId());
            return Formatters.dateTimeFormatter;
        }
    }

    static {
        Log.d(TAG, "using zone: " + zoneId);
    }
}

