/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityRemoteControl;
import buzz.getcoco.iot.CapabilityStorageControl;
import buzz.getcoco.iot.CapabilityTunnel;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Formatters;
import buzz.getcoco.iot.Identifier;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Parameter;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.StorageContentMetadata;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InfoRequest {
    private static final Class<?>[] PARAM_CLASS_LUT = new Class[Parameter.Key.values().length];
    protected transient Command.State state;
    protected transient long requestId = 0L;
    protected transient long cmdSeqNum = 0L;
    protected transient String networkId;
    protected transient long deviceNodeId;
    public long timeout;
    public final String messageText;
    public final List<Parameter<Value>> mandatoryParameters;
    public final List<Parameter<Value>> optionalParameters;

    public InfoRequest(String messageText, List<Parameter<Value>> mandatoryParameters) {
        this(messageText, mandatoryParameters, null);
    }

    public InfoRequest(String messageText, List<Parameter<Value>> mandatoryParameters, List<Parameter<Value>> optionalParameters) {
        this(null, -1L, messageText, mandatoryParameters, optionalParameters);
    }

    protected InfoRequest(String networkId, long deviceNodeId, String messageText, List<Parameter<Value>> mandatoryParameters, List<Parameter<Value>> optionalParameters) {
        this(networkId, deviceNodeId, messageText, 0L, mandatoryParameters, optionalParameters);
    }

    protected InfoRequest(String networkId, long deviceNodeId, String messageText, long timeout, List<Parameter<Value>> mandatoryParameters, List<Parameter<Value>> optionalParameters) {
        this.networkId = networkId;
        this.deviceNodeId = deviceNodeId;
        this.messageText = messageText;
        this.timeout = timeout;
        this.mandatoryParameters = null == mandatoryParameters ? Collections.emptyList() : new ArrayList<Parameter<Value>>(mandatoryParameters);
        this.optionalParameters = null == optionalParameters ? Collections.emptyList() : new ArrayList<Parameter<Value>>(optionalParameters);
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(InfoRequest.class, (Object)new InfoRequestParser());
        Command.GSON_BUILDER.registerTypeAdapter(ContentSearch.class, (Object)new ContentSearchParser());
        Command.GSON_BUILDER.registerTypeAdapter(SortOrder.class, (Object)new SortOrderParser());
        Command.GSON_BUILDER.registerTypeAdapter(SortType.class, (Object)new SortTypeParser());
    }

    public Device getDevice() {
        return Utils.getDevice(CocoClient.getInstance().getNetworkMap(), this.networkId, this.deviceNodeId);
    }

    public long getCmdSeqNum() {
        return this.cmdSeqNum;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public Command.State getState() {
        return this.state;
    }

    public Parameter.Key[] mandatoryKeys() {
        if (null == this.mandatoryParameters) {
            return new Parameter.Key[0];
        }
        Parameter.Key[] keys = new Parameter.Key[this.mandatoryParameters.size()];
        for (int i = 0; i < this.mandatoryParameters.size(); ++i) {
            keys[i] = this.mandatoryParameters.get((int)i).key;
        }
        return keys;
    }

    public Parameter.Key[] optionalKeys() {
        if (null == this.optionalParameters) {
            return new Parameter.Key[0];
        }
        Parameter.Key[] keys = new Parameter.Key[this.optionalParameters.size()];
        for (int i = 0; i < this.optionalParameters.size(); ++i) {
            keys[i] = this.optionalParameters.get((int)i).key;
        }
        return keys;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected JsonElement toJson() {
        return Command.GSON_BUILDER.create().toJsonTree((Object)this);
    }

    static {
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.USER_DEFINED.ordinal()] = UserDefined.class;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.USERNAME.ordinal()] = null;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.PASSWORD.ordinal()] = null;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.PIN.ordinal()] = null;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.OTP.ordinal()] = null;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.INSTALL_CODE.ordinal()] = null;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.CSA.ordinal()] = null;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.DSK.ordinal()] = null;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.RESOURCE_NAME.ordinal()] = null;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.AVAIL_LISTEN_PORT.ordinal()] = ListenPort.class;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.CONTENT_SEARCH.ordinal()] = ContentSearch.class;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.CONTENT_PLAYBACK.ordinal()] = ContentPlayback.class;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.STREAM_BUFFER_SIZES.ordinal()] = Parameter.BufferSizeValue.class;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.PAIRING_TYPE.ordinal()] = Parameter.PairingTypeValue.class;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.TIMEZONE.ordinal()] = Parameter.TimeZoneValue.class;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.REMOTE_PAIRING_CODES.ordinal()] = RemotePairingCode.class;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.REMOTE_PAIR_CAPABILITIES.ordinal()] = RemotePairingCapabilities.class;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.REMOTE_SEARCH.ordinal()] = Search.class;
        InfoRequest.PARAM_CLASS_LUT[Parameter.Key.REMOTE_BUTTON_INFO.ordinal()] = RemoteButtonInfo.class;
    }

    private static final class SortOrderParser
    implements JsonSerializer<SortOrder>,
    JsonDeserializer<SortOrder> {
        private SortOrderParser() {
        }

        public SortOrder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return SortOrder.getEnum(json.getAsInt());
        }

        public JsonElement serialize(SortOrder src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getInt());
        }
    }

    private static final class SortTypeParser
    implements JsonSerializer<SortType>,
    JsonDeserializer<SortType> {
        private SortTypeParser() {
        }

        public SortType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return SortType.getEnum(json.getAsInt());
        }

        public JsonElement serialize(SortType src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getInt());
        }
    }

    private static final class ContentSearchParser
    implements JsonSerializer<ContentSearch>,
    JsonDeserializer<ContentSearch> {
        private static final boolean TIME_AS_STRING = true;

        private ContentSearchParser() {
        }

        public JsonElement serialize(ContentSearch src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            Instant startTime = src.startTime;
            Instant endTime = src.endTime;
            SortOrder sortOrder = src.sortOrder;
            SortType sortType = src.sortType;
            jsonObject.addProperty("reqSearchCount", (Number)src.reqSearchCount);
            jsonObject.addProperty("contentType", (Number)src.contentType.getInt());
            jsonObject.addProperty("uploadTriggerType", (Number)src.triggerType.getInt());
            jsonObject.addProperty("offsetIndex", (Number)src.offsetIndex);
            jsonObject.add("sortByOrder", context.serialize((Object)sortOrder));
            jsonObject.add("sortByType", context.serialize((Object)sortType));
            Identifier.TriggerIdentifier uploadTriggeredUri = src.uploadTriggeredUri;
            Identifier.SourceIdentifier sourceUri = src.sourceUri;
            if (null != uploadTriggeredUri) {
                jsonObject.add("uploadTriggeredUri", uploadTriggeredUri.toJsonTree());
            }
            if (null != sourceUri) {
                jsonObject.add("sourceUri", sourceUri.toJsonTree());
            }
            String startTimeStr = null == startTime ? null : Formatters.getDateTimeFormatter().format(startTime);
            String endTimeStr = null == endTime ? null : Formatters.getDateTimeFormatter().format(endTime);
            jsonObject.addProperty("startEpochTime", startTimeStr);
            jsonObject.addProperty("endEpochTime", endTimeStr);
            return jsonObject;
        }

        public ContentSearch deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            int contentType = json.get("contentType").getAsInt();
            int triggerType = json.get("uploadTriggerType").getAsInt();
            ContentSearch contentSearch = new ContentSearch(StorageContentMetadata.ContentType.getEnum(contentType), StorageContentMetadata.TriggerType.getEnum(triggerType));
            JsonElement startTime = json.get("startEpochTime");
            JsonElement endTime = json.get("endEpochTime");
            contentSearch.startTime = this.getEpochTime(startTime);
            contentSearch.endTime = this.getEpochTime(endTime);
            JsonElement reqSearchCount = json.get("reqSearchCount");
            JsonElement offsetIndex = json.get("offsetIndex");
            contentSearch.reqSearchCount = null == reqSearchCount || !reqSearchCount.isJsonPrimitive() ? 0 : reqSearchCount.getAsInt();
            contentSearch.offsetIndex = null == offsetIndex || !offsetIndex.isJsonPrimitive() ? 0L : (long)offsetIndex.getAsJsonPrimitive().getAsInt();
            JsonElement triggerUri = json.get("uploadTriggeredUri");
            JsonElement sourceUri = json.get("sourceUri");
            contentSearch.sourceUri = new Identifier.SourceIdentifier(null == sourceUri ? null : Identifier.fromJsonTree(sourceUri));
            contentSearch.uploadTriggeredUri = new Identifier.TriggerIdentifier(null == triggerUri ? null : Identifier.fromJsonTree(triggerUri));
            JsonElement sortOrder = json.get("sortByOrder");
            JsonElement sortType = json.get("sortByType");
            contentSearch.sortOrder = (SortOrder)((Object)context.deserialize(sortOrder, SortOrder.class));
            contentSearch.sortType = (SortType)((Object)context.deserialize(sortType, SortType.class));
            return contentSearch;
        }

        private Instant getEpochTime(JsonElement json) {
            if (null != json && json.isJsonPrimitive()) {
                JsonPrimitive timePrim = json.getAsJsonPrimitive();
                if (timePrim.isString()) {
                    String endTimeStr = timePrim.getAsString();
                    return Instant.from(Formatters.getDateTimeFormatter().parse(endTimeStr));
                }
                if (timePrim.isNumber()) {
                    long endTimeLong = timePrim.getAsLong();
                    return Instant.ofEpochSecond(endTimeLong);
                }
            }
            return Instant.EPOCH;
        }
    }

    private static final class InfoRequestParser
    implements JsonSerializer<InfoRequest>,
    JsonDeserializer<InfoRequest> {
        private InfoRequestParser() {
        }

        public JsonElement serialize(InfoRequest infoRequest, Type typeOfSrc, JsonSerializationContext context) {
            Gson gson = Command.GSON_BUILDER.create();
            JsonObject json = new JsonObject();
            List<Parameter<Value>> mandatoryParameters = infoRequest.mandatoryParameters;
            List<Parameter<Value>> optionalParameters = infoRequest.optionalParameters;
            JsonElement mandatoryParamJson = gson.toJsonTree(mandatoryParameters);
            JsonElement optionalParamJson = gson.toJsonTree(optionalParameters);
            json.addProperty("messageText", infoRequest.messageText);
            json.add("mandatoryInfoRequestArr", mandatoryParamJson);
            json.add("optionalInfoRequestArr", optionalParamJson);
            return json;
        }

        public InfoRequest deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<Parameter<Value>> optionalParams;
            Class keyType;
            Parameter.Key key;
            JsonObject paramJson;
            Value value;
            List<Parameter<Value>> mandatoryParams;
            Gson gson = Command.GSON_BUILDER.create();
            JsonObject json = jsonElement.getAsJsonObject();
            JsonArray mandatoryParamsJson = json.getAsJsonArray("mandatoryInfoRequestArr");
            JsonArray optionalParamsJson = json.getAsJsonArray("optionalInfoRequestArr");
            if (null != mandatoryParamsJson) {
                mandatoryParams = new ArrayList(mandatoryParamsJson.size());
                for (JsonElement paramJsonElement : mandatoryParamsJson) {
                    value = null;
                    paramJson = paramJsonElement.getAsJsonObject();
                    key = (Parameter.Key)((Object)gson.fromJson(paramJson.get("key"), Parameter.Key.class));
                    keyType = PARAM_CLASS_LUT[key.ordinal()];
                    if (null != keyType) {
                        value = (Value)gson.fromJson(paramJson.get("value"), (Type)keyType);
                    }
                    mandatoryParams.add(new Parameter<Object>(key, value));
                }
            } else {
                mandatoryParams = Collections.emptyList();
            }
            if (null != optionalParamsJson) {
                optionalParams = new ArrayList(optionalParamsJson.size());
                for (JsonElement paramJsonElement : optionalParamsJson) {
                    value = null;
                    paramJson = paramJsonElement.getAsJsonObject();
                    key = (Parameter.Key)((Object)gson.fromJson(paramJson.get("key"), Parameter.Key.class));
                    keyType = PARAM_CLASS_LUT[key.ordinal()];
                    if (null != keyType) {
                        value = (Value)gson.fromJson(paramJson.get("value"), (Type)keyType);
                    }
                    optionalParams.add(new Parameter<Value>(key, value));
                }
            } else {
                optionalParams = Collections.emptyList();
            }
            return new InfoRequest(json.getAsJsonPrimitive("messageText").getAsString(), mandatoryParams, optionalParams);
        }
    }

    public static class RemoteButtonInfo
    implements Value {
        @SerializedName(value="applianceId")
        public final String applianceId;
        @SerializedName(value="resourceEui")
        public final String resourceEui;

        public RemoteButtonInfo(String applianceId, String resourceEui) {
            this.applianceId = applianceId;
            this.resourceEui = resourceEui;
        }
    }

    public static class RemotePairingCapabilities
    implements Value {
        @SerializedName(value="pairingCode")
        public int pairingCode;
        @SerializedName(value="categoryId")
        public CapabilityRemoteControl.Category categoryId;
        @SerializedName(value="resourceEui")
        public String resourceEui;

        public RemotePairingCapabilities(int pairingCode, CapabilityRemoteControl.Category category, Resource remoteControlResource) {
            this.pairingCode = pairingCode;
            this.categoryId = category;
            this.resourceEui = remoteControlResource.getId();
        }
    }

    public static class RemotePairingCode
    implements Value {
        @SerializedName(value="brandId")
        public int brandId;
        @SerializedName(value="categoryId")
        public CapabilityRemoteControl.Category categoryId;
        @SerializedName(value="resourceEui")
        public String resourceEui;

        public RemotePairingCode(int brandId, CapabilityRemoteControl.Category categoryId, Resource remoteControlResource) {
            this.brandId = brandId;
            this.categoryId = categoryId;
            this.resourceEui = remoteControlResource.getId();
        }
    }

    public static class UserDefined
    implements Value {
        public String request;
    }

    public static class Search
    implements Value {
        @SerializedName(value="reqSearchCount")
        public final int requestSearchCount;
        @SerializedName(value="offsetIndex")
        public final int offsetIndex;
        @SerializedName(value="sortByType")
        public final SortType sortType;
        @SerializedName(value="sortByOrder")
        public final SortOrder sortOrder;
        @SerializedName(value="searchCriteria")
        public final SearchCriteria criteria;
        @SerializedName(value="searchType")
        public final Parameter.SearchType searchType;
        @SerializedName(value="sourceUri")
        public final Identifier.SourceIdentifier source;

        public Search(int requestSearchCount, int offsetIndex, Parameter.SearchType searchType, Identifier.SourceIdentifier source, SortType sortType, SortOrder sortOrder, SearchCriteria criteria) {
            this.requestSearchCount = requestSearchCount;
            this.offsetIndex = offsetIndex;
            this.searchType = searchType;
            this.source = source;
            this.sortType = sortType;
            this.sortOrder = sortOrder;
            this.criteria = criteria;
        }
    }

    public static class BrandSearchCriteria
    implements SearchCriteria {
        @SerializedName(value="categoryId")
        public final CapabilityRemoteControl.Category category;
        @SerializedName(value="brandSearchString")
        public final String brandSearchQuery;

        public BrandSearchCriteria(CapabilityRemoteControl.Category category, String brandSearchQuery) {
            this.category = category;
            this.brandSearchQuery = brandSearchQuery;
        }

        public String toString() {
            return "BrandSearchCriteria{category=" + this.category + ", brandSearchQuery='" + this.brandSearchQuery + '\'' + '}';
        }
    }

    public static interface SearchCriteria {
    }

    public static class ContentSearch
    implements Value {
        @SerializedName(value="reqSearchCount")
        public int reqSearchCount;
        @SerializedName(value="offsetIndex")
        public long offsetIndex;
        @SerializedName(value="startEpochTime")
        public Instant startTime;
        @SerializedName(value="endEpochTime")
        public Instant endTime;
        @SerializedName(value="contentType")
        public StorageContentMetadata.ContentType contentType;
        @SerializedName(value="uploadTriggerType")
        public StorageContentMetadata.TriggerType triggerType;
        @SerializedName(value="uploadTriggeredUri")
        public Identifier.TriggerIdentifier uploadTriggeredUri;
        @SerializedName(value="sourceUri")
        public Identifier.SourceIdentifier sourceUri;
        @SerializedName(value="sortByType")
        public SortType sortType;
        @SerializedName(value="sortByOrder")
        public SortOrder sortOrder;

        public ContentSearch(StorageContentMetadata.ContentType contentType, StorageContentMetadata.TriggerType triggerType) {
            this.contentType = contentType;
            this.triggerType = triggerType;
        }

        public static Identifier getRegex(Network n) {
            return new Identifier(n.getId(), 0L, null, -1, -1, 0, 0, 0);
        }

        public static Identifier getRegex(Device d) {
            Network n = d.getParent();
            return new Identifier(n.getId(), d.getId(), null, -1, -1, 0, 0, 0);
        }

        public static Identifier getRegex(Resource r) {
            Object d = r.getParent();
            Network n = ((Device)d).getParent();
            return new Identifier(n.getId(), ((Device)d).getId(), r.getId(), -1, -1, 0, 0, 0);
        }

        public static Identifier getRegex(Capability c) {
            Resource r = c.getParent();
            Object d = r.getParent();
            Network n = ((Device)d).getParent();
            return new Identifier(n.getId(), ((Device)d).getId(), r.getId(), c.getId().getInt(), -1, 0, 0, 0);
        }

        public static Identifier getRegex(Attribute a) {
            Capability c = a.getParent();
            Resource r = c.getParent();
            Object d = r.getParent();
            Network n = ((Device)d).getParent();
            return new Identifier(n.getId(), ((Device)d).getId(), r.getId(), c.getId().getInt(), a.getMapKey(), 0, 0, 0);
        }
    }

    public static class ListenPort
    implements Value {
        @SerializedName(value="portCount")
        public int portCount;
        @SerializedName(value="transportType")
        public CapabilityTunnel.TransportType transportType;
        @SerializedName(value="consecutivePort")
        public boolean consecutivePorts;
    }

    public static class ContentPlayback
    implements Value {
        @SerializedName(value="contentId")
        public long contentId;
        @SerializedName(value="streamProtocolType")
        public CapabilityStorageControl.StreamProtocol streamProtocol;
    }

    public static interface Value
    extends Parameter.Value {
    }

    public static enum SortType {
        NONE,
        CREATED_TIME;


        static SortType getEnum(int index) {
            return (SortType)Utils.findEnum((int)index, (Enum[])SortType.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum SortOrder {
        NONE,
        ASCENDING,
        DESCENDING;


        static SortOrder getEnum(int index) {
            return (SortOrder)Utils.findEnum((int)index, (Enum[])SortOrder.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }
}

