/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.InfoRequest;
import buzz.getcoco.iot.InfoResponse;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.time.ZoneId;

public class Parameter<T extends Value> {
    private static final String[] PARAM_KEY_LUT = new String[Key.values().length];
    @SerializedName(value="key")
    public Key key;
    @SerializedName(value="value")
    public T value;

    public Parameter(Key key, T value) {
        this.key = key;
        this.value = value;
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(Key.class, (Object)new KeyParser());
        Command.GSON_BUILDER.registerTypeAdapter(StringValue.class, (Object)new StringValueParser());
        Command.GSON_BUILDER.registerTypeAdapter(PairingType.class, (Object)new PairingTypeParser());
        Command.GSON_BUILDER.registerTypeAdapter(SearchType.class, (Object)new SearchTypeParser());
    }

    static {
        Parameter.PARAM_KEY_LUT[Key.USERNAME.ordinal()] = "username";
        Parameter.PARAM_KEY_LUT[Key.PASSWORD.ordinal()] = "password";
        Parameter.PARAM_KEY_LUT[Key.PIN.ordinal()] = "pin";
        Parameter.PARAM_KEY_LUT[Key.OTP.ordinal()] = "otp";
        Parameter.PARAM_KEY_LUT[Key.INSTALL_CODE.ordinal()] = "installCode";
        Parameter.PARAM_KEY_LUT[Key.CSA.ordinal()] = "csa";
        Parameter.PARAM_KEY_LUT[Key.DSK.ordinal()] = "dsk";
        Parameter.PARAM_KEY_LUT[Key.RESOURCE_NAME.ordinal()] = "resourceName";
    }

    public static class TimeZoneValue
    implements InfoResponse.Value,
    InfoRequest.Value {
        @SerializedName(value="timezone")
        public String timezone;

        public TimeZoneValue(String timezone) {
            this.timezone = timezone;
        }

        public TimeZoneValue(ZoneId zoneId) {
            this.timezone = zoneId.getId();
        }
    }

    public static class PairingTypeValue
    implements InfoResponse.Value,
    InfoRequest.Value {
        @SerializedName(value="pairingType")
        public PairingType pairingType;

        public PairingTypeValue(PairingType pairingType) {
            this.pairingType = pairingType;
        }
    }

    public static class StringValue
    implements InfoResponse.Value,
    InfoRequest.Value {
        public String key;
        public String value;

        public StringValue(String key, String value) {
            this.key = key;
            this.value = value;
            if (null == this.key) {
                throw new IllegalArgumentException();
            }
        }

        public StringValue(Key key, String value) {
            this(PARAM_KEY_LUT[key.ordinal()], value);
        }
    }

    public static class BufferSizeValue
    implements InfoResponse.Value,
    InfoRequest.Value {
        @SerializedName(value="sendBufferSize")
        public long sendBufferSize;
        @SerializedName(value="receiveBufferSize")
        public long receiveBufferSize;

        public BufferSizeValue(long sendBufferSize, long receiveBufferSize) {
            this.sendBufferSize = sendBufferSize;
            this.receiveBufferSize = receiveBufferSize;
        }
    }

    static interface Value {
    }

    public static enum SearchType {
        BRAND;


        static SearchType getEnum(int index) {
            return (SearchType)Utils.findEnum((int)index, (Enum[])SearchType.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum PairingType {
        SMART_CONFIG,
        AP;


        static PairingType getEnum(int index) {
            return (PairingType)Utils.findEnum((int)index, (Enum[])PairingType.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum Key {
        USER_DEFINED,
        USERNAME,
        PASSWORD,
        PIN,
        OTP,
        INSTALL_CODE,
        CSA,
        DSK,
        RESOURCE_NAME,
        AVAIL_LISTEN_PORT,
        CONTENT_SEARCH,
        CONTENT_PLAYBACK,
        STREAM_BUFFER_SIZES,
        PAIRING_TYPE,
        TIMEZONE,
        REMOTE_PAIRING_CODES,
        REMOTE_PAIR_CAPABILITIES,
        REMOTE_BUTTON_INFO,
        REMOTE_SEARCH;


        static Key getEnum(int index) {
            return (Key)Utils.findEnum((int)index, (Enum[])Key.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    private static final class StringValueParser
    implements JsonSerializer<StringValue>,
    JsonDeserializer<StringValue> {
        private StringValueParser() {
        }

        public JsonElement serialize(StringValue src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty(src.key, src.value);
            return json;
        }

        public StringValue deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            String key = json.getAsJsonPrimitive(PARAM_KEY_LUT[Key.USER_DEFINED.ordinal()]).getAsString();
            key = null != key ? key : json.getAsJsonPrimitive(PARAM_KEY_LUT[Key.USERNAME.ordinal()]).getAsString();
            key = null != key ? key : json.getAsJsonPrimitive(PARAM_KEY_LUT[Key.PASSWORD.ordinal()]).getAsString();
            key = null != key ? key : json.getAsJsonPrimitive(PARAM_KEY_LUT[Key.PIN.ordinal()]).getAsString();
            key = null != key ? key : json.getAsJsonPrimitive(PARAM_KEY_LUT[Key.OTP.ordinal()]).getAsString();
            key = null != key ? key : json.getAsJsonPrimitive(PARAM_KEY_LUT[Key.INSTALL_CODE.ordinal()]).getAsString();
            key = null != key ? key : json.getAsJsonPrimitive(PARAM_KEY_LUT[Key.CSA.ordinal()]).getAsString();
            key = null != key ? key : json.getAsJsonPrimitive(PARAM_KEY_LUT[Key.DSK.ordinal()]).getAsString();
            String string = key = null != key ? key : json.getAsJsonPrimitive(PARAM_KEY_LUT[Key.RESOURCE_NAME.ordinal()]).getAsString();
            if (null == key) {
                return null;
            }
            String value = json.getAsJsonPrimitive(key).getAsString();
            return new StringValue(key, value);
        }
    }

    private static final class SearchTypeParser
    implements JsonSerializer<SearchType>,
    JsonDeserializer<SearchType> {
        private SearchTypeParser() {
        }

        public SearchType deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return SearchType.getEnum(jsonElement.getAsInt());
        }

        public JsonElement serialize(SearchType searchType, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)searchType.getInt());
        }
    }

    private static final class PairingTypeParser
    implements JsonSerializer<PairingType>,
    JsonDeserializer<PairingType> {
        private PairingTypeParser() {
        }

        public PairingType deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            int pairingType = jsonElement.getAsInt();
            return PairingType.getEnum(pairingType);
        }

        public JsonElement serialize(PairingType pairingType, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)pairingType.getInt());
        }
    }

    private static final class KeyParser
    implements JsonSerializer<Key>,
    JsonDeserializer<Key> {
        private KeyParser() {
        }

        public JsonElement serialize(Key key, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)key.getInt());
        }

        public Key deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int key = json.getAsInt();
            return Key.getEnum(key);
        }
    }
}

