/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public enum RadioProtocol {
    ZWAVE,
    ZIGBEE,
    TUYA;


    static RadioProtocol getEnum(int index) {
        return (RadioProtocol)Utils.findEnum((int)index, (Enum[])RadioProtocol.values());
    }

    public int getInt() {
        return this.ordinal();
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(RadioProtocol.class, (Object)new RadioProtocolParser());
    }

    private static final class RadioProtocolParser
    implements JsonSerializer<RadioProtocol>,
    JsonDeserializer<RadioProtocol> {
        private RadioProtocolParser() {
        }

        public RadioProtocol deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int protocol = json.getAsInt();
            return RadioProtocol.getEnum(protocol);
        }

        public JsonElement serialize(RadioProtocol radioProtocol, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)radioProtocol.getInt());
        }
    }
}

