/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class ResourceAction {
    public static final int DEFAULT_RESOURCE_ACTION_ID = 0;
    private final int id;
    private final Command<? extends Capability.CommandId> command;
    private final Capability capability;

    public ResourceAction(Capability capability, Command<? extends Capability.CommandId> command) {
        this(0, capability, command);
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(ResourceAction.class, (Object)new ResourceActionParser());
    }

    protected ResourceAction(int id, Capability capability, Command<? extends Capability.CommandId> command) {
        this.id = id;
        this.capability = capability;
        this.command = command;
    }

    public int getId() {
        return this.id;
    }

    public Command<? extends Capability.CommandId> getCommand() {
        return this.command;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public String toJson() {
        return Command.GSON_BUILDER.create().toJson((Object)this);
    }

    public String toString() {
        return "ResourceAction{id=" + this.id + ", command=" + Command.GSON_BUILDER.create().toJson(this.command) + ", capability=" + this.capability + '}';
    }

    public static ResourceAction fromJson(String jsonAction) {
        return (ResourceAction)Command.GSON_BUILDER.create().fromJson(jsonAction, ResourceAction.class);
    }

    private static class ResourceActionParser
    implements JsonSerializer<ResourceAction>,
    JsonDeserializer<ResourceAction> {
        private ResourceActionParser() {
        }

        public JsonElement serialize(ResourceAction resourceAction, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            Capability capability = resourceAction.capability;
            Resource resource = capability.getParent();
            Object device = resource.getParent();
            Network network = ((Device)device).getParent();
            jsonObject.addProperty("capabilityId", (Number)capability.getId().getInt());
            jsonObject.addProperty("resourceEui", resource.getId());
            jsonObject.addProperty("gatewayNodeId", (Number)((Device)device).getId());
            jsonObject.addProperty("networkId", network.getId());
            jsonObject.addProperty("cmdId", (Number)((Capability.CommandId)resourceAction.command.getCommandId()).getInt());
            jsonObject.addProperty("resrcActionId", (Number)resourceAction.id);
            JsonObject commandJson = resourceAction.command.toJsonObject();
            if (0 < commandJson.entrySet().size()) {
                jsonObject.add("cmdParams", (JsonElement)commandJson);
            }
            return jsonObject;
        }

        public ResourceAction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            int capabilityId = jsonObject.get("capabilityId").getAsInt();
            String resourceEui = jsonObject.get("resourceEui").getAsString();
            long deviceNodeId = jsonObject.get("gatewayNodeId").getAsLong();
            String networkId = jsonObject.get("networkId").getAsString();
            Capability capability = Utils.addMissingCapability(networkId, deviceNodeId, resourceEui, capabilityId, null);
            Command<? extends Capability.CommandId> command = capability.createCommand(jsonObject.get("cmdId").getAsInt(), jsonObject.get("cmdParams"));
            int resourceActionId = jsonObject.get("resrcActionId").getAsInt();
            return new ResourceAction(resourceActionId, capability, command);
        }
    }
}

