/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.ResourceAction;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Scene
implements Iterable<ResourceAction> {
    public static final int DEFAULT_SCENE_ID = 0;
    private final int sceneId;
    private Map<Integer, ResourceAction> resourceActionMap;
    private String name;
    private String metadata;
    private transient Network parent;
    private transient boolean ready = false;

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(Scene.class, (Object)new SceneParser());
    }

    protected Scene(int sceneId, Network parent) {
        this.sceneId = sceneId;
        this.parent = parent;
    }

    public int getId() {
        return this.sceneId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name, Network.NetworkManagementStatusListener listener) {
        this.parent.sendNetworkManagementCommand(new Network.SetScene(this, name), listener);
    }

    public void addResourceActions(ResourceAction[] resourceActions, Network.NetworkManagementStatusListener listener) {
        this.parent.sendNetworkManagementCommand(new Network.AddSceneResourceAction(this, resourceActions), listener);
    }

    public void updateResourceActions(int[] resourceActionIds, ResourceAction[] resourceActions, Network.NetworkManagementStatusListener listener) {
        this.parent.sendNetworkManagementCommand(new Network.UpdateSceneResourceActions(this, resourceActionIds, resourceActions), listener);
    }

    public void saveResourceActions(ResourceAction[] resourceActions, Network.NetworkManagementStatusListener listener) {
        this.parent.sendNetworkManagementCommand(new Network.SaveSceneResourceActions(this, resourceActions), listener);
    }

    public void removeResourceActions(ResourceAction[] resourceActions, Network.NetworkManagementStatusListener listener) {
        this.parent.sendNetworkManagementCommand(new Network.RemoveSceneResourceActions(this, resourceActions), listener);
    }

    public void setMetadata(String metadata, Network.NetworkManagementStatusListener listener) {
        this.parent.sendNetworkManagementCommand(new Network.SetSceneMetadata(this, metadata), listener);
    }

    public void execute() {
        CocoClient.getInstance().getNativeHandler().executeScene(this);
    }

    public String getMetadata() {
        return this.metadata;
    }

    public Network getParent() {
        return this.parent;
    }

    public Map<Integer, ResourceAction> getResourceActionMap() {
        if (null == this.resourceActionMap) {
            this.resourceActionMap = new ConcurrentHashMap<Integer, ResourceAction>();
        }
        return this.resourceActionMap;
    }

    public ResourceAction getResourceAction(int resourceActionId) {
        return this.getResourceActionMap().get(resourceActionId);
    }

    protected void internalAddResourceAction(ResourceAction resourceAction) {
        this.getResourceActionMap().put(resourceAction.getId(), resourceAction);
    }

    public boolean containsResourceAction(int resourceActionId) {
        return this.getResourceActionMap().containsKey(resourceActionId);
    }

    protected void internalUpdateResourceAction(ResourceAction resourceAction) {
        this.internalRemoveResourceAction(resourceAction.getId());
        this.internalAddResourceAction(resourceAction);
    }

    protected void internalRemoveResourceAction(int resourceActionId) {
        this.getResourceActionMap().remove(resourceActionId);
    }

    public final int hashCode() {
        return this.getId();
    }

    public boolean isReady() {
        return this.ready;
    }

    protected void internalSetName(String name) {
        this.name = name;
    }

    protected void internalSetMetadata(String metadata) {
        this.metadata = metadata;
    }

    protected void internalSetParent(Network parent) {
        this.parent = parent;
    }

    protected void internalMarkAsReady() {
        this.ready = true;
    }

    public String toString() {
        String networkId = null == this.parent ? "?" : this.parent.getId();
        return "Scene{networkId=" + networkId + ", sceneId=" + this.sceneId + ", name='" + this.name + '\'' + ", metadata='" + this.metadata + '\'' + ", ready=" + this.ready + ", resourceActionMap=" + this.resourceActionMap + '}';
    }

    @Override
    public Iterator<ResourceAction> iterator() {
        return this.getResourceActionMap().values().iterator();
    }

    private static class SceneParser
    implements JsonSerializer<Scene>,
    JsonDeserializer<Scene> {
        private SceneParser() {
        }

        public JsonElement serialize(Scene scene, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)scene.sceneId);
        }

        public Scene deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            String networkId = jsonObject.get("networkId").getAsString();
            int sceneId = jsonObject.get("sceneId").getAsInt();
            return Utils.addMissingScene(networkId, sceneId);
        }
    }
}

