/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class ScheduleCondition
implements Rule.Condition {
    private final int id;
    private final Instant startTime;
    private final Instant expiryTime;
    private final ScheduleType scheduleType;
    public static final int DEFAULT_SCHEDULE_CONDITION_ID = 0;

    ScheduleCondition(int id, Instant startTime, Instant expiryTime, ScheduleType scheduleType) {
        this.id = id;
        this.startTime = startTime;
        this.expiryTime = expiryTime;
        this.scheduleType = scheduleType;
    }

    private ScheduleCondition(Instant startTime, LocalTime expiryTime, ScheduleType scheduleType) {
        this(0, startTime, ScheduleCondition.getExpiryTimeInstant(startTime, expiryTime), scheduleType);
    }

    private static Instant getExpiryTimeInstant(Instant startTime, LocalTime expiryTime) {
        return LocalDateTime.of(startTime.atZone(ZoneOffset.UTC).toLocalDate(), expiryTime).toInstant(ZoneOffset.UTC);
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(ScheduleCondition.class, (Object)new ScheduleConditionParser());
    }

    public int getId() {
        return this.id;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    Instant getInstantExpiryTime() {
        return this.expiryTime;
    }

    public LocalTime getExpiryTime() {
        return ZonedDateTime.ofInstant(this.expiryTime, ZoneOffset.UTC).toLocalTime();
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    @Override
    public ScheduleCondition duplicate() {
        return new ScheduleCondition(0, this.startTime, this.expiryTime, this.scheduleType);
    }

    public String toString() {
        return "ScheduleCondition{id=" + this.id + ", startTime=" + this.startTime + ", expiryTime=" + this.expiryTime + ", scheduleType=" + (Object)((Object)this.scheduleType) + '}';
    }

    public static final class Builder {
        private Instant startTime = Instant.now();
        private LocalTime expiryTime = LocalTime.MAX;
        private ScheduleType scheduleType = ScheduleType.ONETIME;

        public ScheduleCondition build() {
            return new ScheduleCondition(this.startTime, this.expiryTime, this.scheduleType);
        }

        public Builder setStartTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder setExpiryTime(LocalTime expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public Builder setScheduleType(ScheduleType scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        public Instant getStartTime() {
            return this.startTime;
        }

        public LocalTime getExpiryTime() {
            return this.expiryTime;
        }

        public ScheduleType getScheduleType() {
            return this.scheduleType;
        }
    }

    public static enum ScheduleType {
        ONETIME,
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY;


        static ScheduleType getEnum(int index) {
            return (ScheduleType)Utils.findEnum((int)index, (Enum[])ScheduleType.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    private static final class ScheduleConditionParser
    implements JsonSerializer<ScheduleCondition>,
    JsonDeserializer<ScheduleCondition> {
        private ScheduleConditionParser() {
        }

        public ScheduleCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            int id = jsonObject.get("ruleSchedCondId").getAsInt();
            ScheduleType scheduleType = ScheduleType.getEnum(jsonObject.get("ruleSchedTypeId").getAsInt());
            Instant startTime = (Instant)context.deserialize(jsonObject.get("ruleStartTime"), Instant.class);
            Instant expiryTime = (Instant)context.deserialize(jsonObject.get("ruleExpiryTime"), Instant.class);
            return new ScheduleCondition(id, startTime, expiryTime, scheduleType);
        }

        public JsonElement serialize(ScheduleCondition condition, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("ruleSchedCondId", (Number)condition.getId());
            json.addProperty("ruleSchedTypeId", (Number)condition.getScheduleType().getInt());
            json.add("ruleExpiryTime", context.serialize((Object)condition.expiryTime));
            json.add("ruleStartTime", context.serialize((Object)condition.startTime));
            return json;
        }
    }
}

