/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Identifier;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Objects;

public class StorageContentMetadata {
    @SerializedName(value="contentId")
    public final long contentId;
    @SerializedName(value="contentType")
    public final ContentType contentType;
    @SerializedName(value="uploadTriggerType")
    public final TriggerType triggerType;
    @SerializedName(value="size")
    public final long size;
    @SerializedName(value="staticLink")
    public final String staticLink;
    @SerializedName(value="userMetaData")
    public final String metadata;
    @SerializedName(value="sourceUri")
    public final Identifier.SourceIdentifier sourceUri;
    @SerializedName(value="uploadTriggeredUri")
    public final Identifier.TriggerIdentifier uploadTriggeredUri;
    @SerializedName(value="createdTimestamp")
    public final Instant createdTimeStamp;
    @SerializedName(value="contentDuration")
    public final long duration;

    protected StorageContentMetadata(long contentId, Identifier.SourceIdentifier sourceUri, int contentType, int triggerType, Identifier.TriggerIdentifier triggerUri, long size, String staticLink, String metadata, long createdTimeStamp, long duration) {
        this.contentId = contentId;
        this.sourceUri = sourceUri;
        this.contentType = ContentType.getEnum(contentType);
        this.triggerType = TriggerType.getEnum(triggerType);
        this.uploadTriggeredUri = triggerUri;
        this.size = size;
        this.staticLink = staticLink;
        this.metadata = metadata;
        this.duration = duration;
        this.createdTimeStamp = Instant.ofEpochSecond(createdTimeStamp);
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(ContentType.class, (Object)new ContentTypeParser());
        Command.GSON_BUILDER.registerTypeAdapter(TriggerType.class, (Object)new TriggerTypeParser());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageContentMetadata that = (StorageContentMetadata)o;
        return this.contentId == that.contentId && this.size == that.size && this.duration == that.duration && this.contentType == that.contentType && this.triggerType == that.triggerType && Objects.equals(this.staticLink, that.staticLink) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.sourceUri, that.sourceUri) && Objects.equals(this.uploadTriggeredUri, that.uploadTriggeredUri) && Objects.equals(this.createdTimeStamp, that.createdTimeStamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentId, this.contentType, this.triggerType, this.size, this.staticLink, this.metadata, this.sourceUri, this.uploadTriggeredUri, this.createdTimeStamp, this.duration});
    }

    public String toString() {
        return "StorageContentMetadata{contentId=" + this.contentId + ", contentType=" + (Object)((Object)this.contentType) + ", triggerType=" + (Object)((Object)this.triggerType) + ", size=" + this.size + ", staticLink='" + this.staticLink + '\'' + ", metadata='" + this.metadata + '\'' + ", sourceUri=" + this.sourceUri + ", uploadTriggeredUri=" + this.uploadTriggeredUri + ", createdTimeStamp=" + this.createdTimeStamp + ", duration=" + this.duration + '}';
    }

    private static final class TriggerTypeParser
    implements JsonSerializer<TriggerType>,
    JsonDeserializer<TriggerType> {
        private TriggerTypeParser() {
        }

        public TriggerType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return TriggerType.getEnum(json.getAsInt());
        }

        public JsonElement serialize(TriggerType src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getInt());
        }
    }

    private static final class ContentTypeParser
    implements JsonSerializer<ContentType>,
    JsonDeserializer<ContentType> {
        private ContentTypeParser() {
        }

        public ContentType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return ContentType.getEnum(json.getAsInt());
        }

        public JsonElement serialize(ContentType src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getInt());
        }
    }

    public static enum TriggerType {
        ALL,
        USER,
        ATTR,
        SCENE,
        RULE;

        private static final int offset = -1;

        static TriggerType getEnum(int index) {
            return (TriggerType)Utils.findEnum((int)(index - -1), (Enum[])TriggerType.values());
        }

        int getInt() {
            return this.ordinal() + -1;
        }
    }

    public static enum ContentType {
        ALL,
        STREAM,
        ATTRIBUTE,
        FILE;

        private static final int offset = -1;

        static ContentType getEnum(int index) {
            return (ContentType)Utils.findEnum((int)(index - -1), (Enum[])ContentType.values());
        }

        int getInt() {
            return this.ordinal() + -1;
        }
    }
}

