/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.CallbackMultiplexer;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Factory;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;
import java.util.Map;

class Utils {
    Utils() {
    }

    static <T, U extends T> U castUp(T t) {
        return (U)t;
    }

    static Network addMissingNetwork(String networkId) {
        if (!CocoClient.getInstance().containsNetwork(networkId)) {
            CocoClient.getInstance().internalAddNetwork(Factory.createNetwork(networkId));
            CallbackMultiplexer.getInstance().connectStatusCallback((Network)CocoClient.getInstance().getNetwork(networkId));
        }
        return CocoClient.getInstance().getNetwork(networkId);
    }

    static Device addMissingDevice(String networkId, long deviceNodeId) {
        Network network = Utils.addMissingNetwork(networkId);
        if (!network.containsDevice(deviceNodeId)) {
            Device device = Factory.createDevice(deviceNodeId, network);
            network.internalAddDevice(device);
            CallbackMultiplexer.getInstance().deviceInfoCallback(device);
        }
        return network.getDevice(deviceNodeId);
    }

    static Resource addMissingResource(String networkId, long deviceNodeId, String resourceEui, Object developerContext) {
        Network parentNetwork = Utils.addMissingNetwork(networkId);
        Object parentZone = parentNetwork.getZone(0);
        return Utils.addMissingResource(networkId, deviceNodeId, resourceEui, parentZone, developerContext);
    }

    static Resource addMissingResource(String networkId, long deviceNodeId, String resourceEui, Zone parentZone, Object developerContext) {
        Device device = Utils.addMissingDevice(networkId, deviceNodeId);
        if (!device.containsResource(resourceEui)) {
            Resource resource = Factory.createResource(resourceEui, device, parentZone);
            device.internalAddResource(resource);
            parentZone.internalAddResource(resource);
            CallbackMultiplexer.getInstance().resourceCallback(resource);
        }
        return device.getResource(resourceEui);
    }

    static Capability addMissingCapability(String networkId, long deviceNodeId, String resourceEui, int capabilityId, Object developerContext) {
        Capability capability;
        Resource resource = Utils.addMissingResource(networkId, deviceNodeId, resourceEui, developerContext);
        if (!resource.containsCapability(Utils.capIdConverter(capabilityId))) {
            capability = Factory.createCapability(capabilityId, resource);
            resource.internalAddCapability(capability);
            CallbackMultiplexer.getInstance().resourceCapabilityCallback(capability);
        } else {
            capability = resource.getCapability(Utils.capIdConverter(capabilityId));
        }
        return capability;
    }

    static Scene addMissingScene(String networkId, int sceneId) {
        Scene scene;
        Network parent = Utils.addMissingNetwork(networkId);
        if (!parent.containsScene(sceneId)) {
            scene = Factory.createScene(sceneId, parent);
            parent.internalAddScene(scene);
        } else {
            scene = parent.getScene(sceneId);
        }
        return scene;
    }

    static Scene getScene(String networkId, int sceneId) {
        Network parent = Utils.getNetwork(networkId);
        return null == parent ? null : (Scene)parent.getScene(sceneId);
    }

    static Zone getZone(String networkId, int zoneId) {
        Network parent = Utils.getNetwork(networkId);
        return null == parent ? null : (Zone)parent.getZone(zoneId);
    }

    static Rule getRule(String networkId, int ruleId) {
        Network parent = Utils.getNetwork(networkId);
        return null == parent ? null : (Rule)parent.getRule(ruleId);
    }

    static Network getNetwork(String networkId) {
        return Utils.getNetwork(CocoClient.getInstance().getNetworkMap(), networkId);
    }

    static Network getNetwork(Map<String, Network> networkMap, String networkId) {
        return networkMap.get(networkId);
    }

    static Device getDevice(String networkId, long deviceNodeId) {
        return Utils.getDevice(CocoClient.getInstance().getNetworkMap(), networkId, deviceNodeId);
    }

    static Device getDevice(Map<String, Network> networkMap, String networkId, long deviceNodeId) {
        Network parentNetwork = Utils.getNetwork(networkMap, networkId);
        return null == parentNetwork ? null : (Device)parentNetwork.getDevice(deviceNodeId);
    }

    static Resource getResource(String networkId, long deviceNodeId, String resourceEui) {
        return Utils.getResource(CocoClient.getInstance().getNetworkMap(), networkId, deviceNodeId, resourceEui);
    }

    static Resource getResource(Map<String, Network> networkMap, String networkId, long deviceNodeId, String resourceEui) {
        Device parentDevice = Utils.getDevice(networkMap, networkId, deviceNodeId);
        return null == parentDevice ? null : (Resource)parentDevice.getResource(resourceEui);
    }

    static Capability getCapability(Map<String, Network> networkMap, String networkId, long deviceNodeId, String resourceEui, int capabilityId) {
        Resource parentResource = Utils.getResource(networkMap, networkId, deviceNodeId, resourceEui);
        return null == parentResource ? null : (Capability)parentResource.getCapability(Utils.capIdConverter(capabilityId));
    }

    private static Capability.CapabilityId capIdConverter(int index) {
        return Capability.CapabilityId.getEnum(index);
    }

    static <T extends Enum<T>> T findEnum(int index, T[] arr) {
        int size = arr.length;
        if (0 > index || index >= size) {
            throw new IllegalArgumentException("Requested index: " + index + ", Size of Enum: " + size);
        }
        return arr[index];
    }
}

