/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.mocks;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.RetryOptions;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class HttpClientMock
extends HttpClient {
    private Function<HttpRequestOptions, CompletableFuture<String>> requestMock;

    public HttpClientMock(Function<HttpRequestOptions, CompletableFuture<String>> requestMock) throws ValidationException {
        this(requestMock, 60000, 60000);
    }

    public HttpClientMock(Function<HttpRequestOptions, CompletableFuture<String>> requestMock, int requestTimeout, int connectTimeout) throws ValidationException {
        this(requestMock, requestTimeout, connectTimeout, new RetryOptions());
    }

    public HttpClientMock(Function<HttpRequestOptions, CompletableFuture<String>> requestMock, int requestTimeout, int connectTimeout, RetryOptions retryOpts) throws ValidationException {
        super(requestTimeout, connectTimeout, retryOpts);
        this.requestMock = requestMock;
    }

    @Override
    public CompletableFuture<String> request(HttpRequestOptions options) {
        return this.requestMock.apply(options);
    }

    @Override
    public CompletableFuture<String> request(HttpRequestOptions options, int retryCounter) {
        return this.requestMock.apply(options);
    }

    public void setRequestMock(Function<HttpRequestOptions, CompletableFuture<String>> mock) {
        this.requestMock = mock;
    }
}

