/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.util;

import cloud.metaapi.sdk.util.JsonMapper;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.apache.commons.lang3.tuple.Pair;

public class Js {
    public static <U, T> U reduce(List<T> list, BiFunction<U, T, U> reducer, U initialValue) {
        U result = initialValue;
        for (T item : new ArrayList<T>(list)) {
            result = reducer.apply(result, item);
        }
        return result;
    }

    @SafeVarargs
    public static <T> T or(T ... values) {
        T last = null;
        for (T value : values) {
            last = value;
            if (value == null || value.equals(0) || value.equals("")) continue;
            return value;
        }
        return last;
    }

    @SafeVarargs
    public static <T, U> Map<T, U> asMap(Pair<T, U> ... pairs) {
        ConcurrentHashMap<Object, Object> result = new ConcurrentHashMap<Object, Object>();
        for (Pair<T, U> pair : pairs) {
            result.put(pair.getLeft(), pair.getRight());
        }
        return result;
    }

    @SafeVarargs
    public static <T> Map<T, T> asMap(T ... pairs) {
        ConcurrentHashMap<T, T> result = new ConcurrentHashMap<T, T>();
        for (int i = 0; i < pairs.length; i += 2) {
            result.put(pairs[i], pairs[i + 1]);
        }
        return result;
    }

    @SafeVarargs
    public static <T> JsonNode asJson(T ... pairs) {
        return JsonMapper.getInstance().valueToTree(Js.asMap(pairs));
    }

    public static Timer setTimeout(final Runnable callback, int msInterval) {
        Timer result = new Timer();
        result.schedule(new TimerTask(){

            @Override
            public void run() {
                callback.run();
            }
        }, msInterval);
        return result;
    }

    public static Timer setInterval(final Runnable callback, int msInterval) {
        Timer result = new Timer();
        result.schedule(new TimerTask(){

            @Override
            public void run() {
                callback.run();
            }
        }, msInterval, (long)msInterval);
        return result;
    }

    public static void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void log(Object ... data) {
        String out = "";
        for (Object item : data) {
            out = out + item.toString() + " ";
        }
        System.out.println(out);
    }

    public static void trace(Object data) {
        System.out.println(data.toString());
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stackTrace.length; ++i) {
            System.out.println("  " + stackTrace[i].toString());
        }
    }
}

