/*
 * Decompiled with CFR 0.152.
 */
package cn.letcode.email.service;

import cn.letcode.email.auth.MyAuthenticator;
import cn.letcode.email.bean.Email;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class EmailService {
    private Email email;

    public boolean sendEmail(String toAddr, String subJect, String content) throws Exception {
        this.email.setSubject(subJect);
        this.email.setContent(content);
        this.email.setToAddress(toAddr);
        return this.sendHtmlMail(this.email);
    }

    public boolean sendEmail(String toAddr, String subJect, String content, String type) throws Exception {
        this.email.setSubject(subJect);
        this.email.setContent(content);
        this.email.setToAddress(toAddr);
        if ("HTML".equals(type.toUpperCase())) {
            return this.sendHtmlMail(this.email);
        }
        if ("TEXT".equals(type)) {
            return this.sendTextMail(this.email);
        }
        throw new Exception("email type is not defined!!");
    }

    public boolean sendEmail(String toAddr, String subJect, String content, String type, File[] files) throws Exception {
        this.email.setSubject(subJect);
        this.email.setContent(content);
        this.email.setToAddress(toAddr);
        this.email.setAttachFiles(files);
        if ("HTML".equals(type.toUpperCase())) {
            return this.sendHtmlMail(this.email);
        }
        if ("TEXT".equals(type.toUpperCase())) {
            return this.sendTextMail(this.email);
        }
        throw new Exception("email type is not defined!!");
    }

    public boolean sendEmail(String toAddr, String subJect, String content, String type, File file) throws Exception {
        this.email.setSubject(subJect);
        this.email.setContent(content);
        this.email.setToAddress(toAddr);
        File[] s = new File[]{file};
        this.email.setAttachFiles(s);
        if ("HTML".equals(type.toUpperCase())) {
            return this.sendHtmlMail(this.email);
        }
        if ("TEXT".equals(type.toUpperCase())) {
            return this.sendTextMail(this.email);
        }
        throw new Exception("email type is not defined!!");
    }

    public boolean sendTextMail(Email mail) {
        Session mSession = null;
        MimeMultipart mainPart = null;
        Message mailMessage = null;
        MimeBodyPart msgBodyPart = null;
        try {
            mSession = this.getMailSession(mail);
            mailMessage = this.getMimeMessage(mSession, mail);
            mainPart = new MimeMultipart();
            msgBodyPart = new MimeBodyPart();
            msgBodyPart.setText(mail.getContent());
            mainPart = this.getFileMultipart((Multipart)mainPart, mail);
            mainPart.addBodyPart((BodyPart)msgBodyPart);
            mailMessage.setContent((Multipart)mainPart);
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean sendHtmlMail(Email mail) {
        Session mSession = null;
        MimeMultipart mainPart = null;
        MimeBodyPart html = null;
        Message mailMessage = null;
        try {
            mSession = this.getMailSession(mail);
            mailMessage = this.getMimeMessage(mSession, mail);
            html = new MimeBodyPart();
            html.setContent((Object)mail.getContent(), "text/html; charset=utf-8");
            mainPart = new MimeMultipart();
            mainPart.addBodyPart((BodyPart)html);
            mainPart = this.getFileMultipart((Multipart)mainPart, mail);
            mailMessage.setContent((Multipart)mainPart);
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Session getMailSession(Email mail) {
        MyAuthenticator authenticator = null;
        Properties pro = mail.getProperties();
        if (mail.isValidate()) {
            authenticator = new MyAuthenticator(mail.getUserName(), mail.getPassword());
        }
        return Session.getInstance((Properties)pro, authenticator);
    }

    public Message getMimeMessage(Session mSession, Email mail) throws Exception {
        MimeMessage msg = null;
        InternetAddress from = null;
        InternetAddress[] to = null;
        try {
            msg = new MimeMessage(mSession);
            from = new InternetAddress(MimeUtility.encodeText((String)mail.getFromUserName()) + '<' + mail.getFromAddress() + ">");
            new InternetAddress();
            to = InternetAddress.parse((String)this.getToAddress(mail.getToAddress()));
            msg.setFrom((Address)from);
            msg.setRecipients(Message.RecipientType.TO, (Address[])to);
            msg.setSubject(mail.getSubject());
            msg.setSentDate(new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return msg;
    }

    public Multipart getFileMultipart(Multipart mainPart, Email email) {
        try {
            MimeBodyPart fPart = null;
            FileDataSource source = null;
            if (email == null || email.getAttachFiles() == null) {
                return mainPart;
            }
            for (File f : email.getAttachFiles()) {
                if (f == null || !f.exists()) continue;
                fPart = new MimeBodyPart();
                source = new FileDataSource(f);
                fPart.setDataHandler(new DataHandler((DataSource)source));
                fPart.setFileName(MimeUtility.encodeWord((String)f.getName()));
                mainPart.addBodyPart((BodyPart)fPart);
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return mainPart;
    }

    public String getToAddress(String toAddress) {
        String addrs = "";
        try {
            if (toAddress.contains(",")) {
                String[] s;
                for (String t : s = toAddress.split(",")) {
                    addrs = t.contains("<") ? addrs + this.getMimeEcodeAddr(t) + "," : addrs + t + ", ";
                }
            } else {
                addrs = toAddress.contains("<") ? addrs + this.getMimeEcodeAddr(toAddress) : toAddress;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return addrs;
    }

    public String getMimeEcodeAddr(String addr) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord((String)addr.substring(0, addr.indexOf(60))) + addr.substring(addr.indexOf(60));
    }

    public void setEmail(Email email) {
        this.email = email;
    }
}

