/*
 * Decompiled with CFR 0.152.
 */
package cn.openjava.basic.crypto.factory;

import cn.openjava.basic.crypto.enums.CryptoType;
import cn.openjava.basic.crypto.factory.Base64Crypto;
import cn.openjava.basic.crypto.factory.OpenJavaCrypto;
import cn.openjava.basic.crypto.factory.Sm234Crypto;
import cn.openjava.basic.crypto.factory.Sm2Crypto;

public class CryptoFactory {
    private OpenJavaCrypto openJavaCrypto;

    public OpenJavaCrypto newInstance(CryptoType cryptoType) {
        switch (cryptoType) {
            case SM2: {
                return new Sm2Crypto();
            }
            case SM234: {
                return new Sm234Crypto();
            }
            case BASE64: {
                return new Base64Crypto();
            }
        }
        return null;
    }

    public OpenJavaCrypto getInstance() {
        if (this.openJavaCrypto == null) {
            this.openJavaCrypto = this.newInstance(CryptoType.defaultType());
        }
        return this.openJavaCrypto;
    }

    public OpenJavaCrypto getInstance(CryptoType cryptoType) {
        if (this.openJavaCrypto == null) {
            this.openJavaCrypto = this.newInstance(cryptoType);
        }
        return this.openJavaCrypto;
    }
}

