package cn.openjava.basic.format.exception;

import cn.openjava.basic.format.message.IComplexMessage;
import cn.openjava.basic.format.message.IMessage;

public class OpenJavaException extends BaseException {
    /**
     * 构造方法
     *
     * @param message 编码
     */
    public OpenJavaException(IMessage message) {
        super(message);
    }

    public OpenJavaException(IComplexMessage message) {
        super(message);
    }

    /**
     * 构造方法
     *
     * @param message 消息
     */
    public OpenJavaException(final String message) {
        super(500, message);
    }

    /**
     * 构造方法
     *
     * @param code    编码
     * @param message 消息
     */
    public OpenJavaException(final int code, final String message) {
        super(code, message);
    }

    /**
     * 构造方法
     *
     * @param code    编码
     * @param fillStr 文本
     */
    public OpenJavaException(IMessage code, Object... fillStr) {
        super(code, fillStr);
    }
}
