/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.criteria;

import ai.djl.Device;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.translator.YoloV8TranslatorFactory;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.objectdetection.config.DetectorModelConfig;
import cn.smartjavaai.objectdetection.criteria.CriteriaBuilderStrategy;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class YoloCriteriaBuilder
implements CriteriaBuilderStrategy {
    @Override
    public Criteria<Image, DetectedObjects> buildCriteria(DetectorModelConfig config) {
        Device device = null;
        if (!Objects.isNull(config.getDevice())) {
            device = config.getDevice() == DeviceEnum.CPU ? Device.cpu() : Device.gpu((int)config.getGpuId());
        }
        Map<String, Object> customParams = this.getDefaultConfig();
        if (config.getCustomParams() != null) {
            customParams.putAll(config.getCustomParams());
        }
        Criteria.Builder criteriaBuilder = Criteria.builder().setTypes(Image.class, DetectedObjects.class).optModelPath(Paths.get(config.getModelPath(), new String[0])).optEngine("OnnxRuntime").optArguments(customParams).optDevice(device).optTranslatorFactory((TranslatorFactory)new YoloV8TranslatorFactory()).optProgress((Progress)new ProgressBar()).optArgument("threshold", (Object)Float.valueOf(config.getThreshold() > 0.0f ? config.getThreshold() : 0.5f));
        if (config.getMaxBox() > 0) {
            criteriaBuilder.optArgument("maxBox", (Object)config.getMaxBox());
        }
        Criteria criteria = criteriaBuilder.build();
        return criteria;
    }

    public Map<String, Object> getDefaultConfig() {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("width", 640);
        arguments.put("height", 640);
        arguments.put("resize", true);
        arguments.put("toTensor", true);
        arguments.put("applyRatio", true);
        return arguments;
    }
}

