/*
 * Decompiled with CFR 0.152.
 */
package dk.eSoftware.commandLineParser;

import dk.eSoftware.commandLineParser.Configuration;
import dk.eSoftware.commandLineParser.NoSuchBuilderException;
import dk.eSoftware.commandLineParser.WrongFormatException;
import java.util.ArrayList;
import java.util.List;

public abstract class CommandLineParser {
    public Configuration parse(String[] input) throws NoSuchBuilderException, WrongFormatException {
        String firstParam = input == null || input.length == 0 ? null : input[0];
        ConfigBuilder configBuilder = this.getConfigBuilder(firstParam);
        this.doParse(input, configBuilder);
        return configBuilder.build();
    }

    protected abstract ConfigBuilder getConfigBuilder(String var1) throws NoSuchBuilderException;

    private void doParse(String[] s, ConfigBuilder configBuilder) throws WrongFormatException {
        if (s == null || s.length == 0) {
            return;
        }
        String currCommand = s[0];
        ArrayList<String> currCommands = new ArrayList<String>();
        for (int i = 1; i < s.length; ++i) {
            String curr = s[i];
            if (curr.startsWith("--")) {
                configBuilder.applyCommand(new Command(currCommand, currCommands));
                currCommand = curr.replaceFirst("--", "");
                currCommands = new ArrayList();
                continue;
            }
            if (curr.startsWith("-")) {
                currCommands.add(curr.replaceFirst("-", ""));
                continue;
            }
            throw new WrongFormatException("Unable to parse argument: " + curr);
        }
        configBuilder.applyCommand(new Command(currCommand, currCommands));
    }

    public abstract String help();

    public static class Command {
        private String command;
        private List<String> params;

        Command(String command, List<String> params) {
            this.command = command;
            this.params = params;
        }

        public String getCommand() {
            return this.command;
        }

        public List<String> getParams() {
            return this.params;
        }
    }

    public static interface ConfigBuilder {
        public void applyCommand(Command var1);

        public Configuration build();

        public String help();
    }
}

