/*
 * Decompiled with CFR 0.152.
 */
package dk.eSoftware.commandLineParser.generalized.documentation;

import dk.eSoftware.commandLineParser.Configuration;
import dk.eSoftware.commandLineParser.generalized.annotations.Help;
import dk.eSoftware.commandLineParser.generalized.annotations.Name;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class HelpUtilities {
    public static String generateHelpString(Class<? extends Configuration> subjectClass) {
        return subjectClass.getSimpleName() + ": \n" + HelpUtilities.generateFieldsString(1, subjectClass);
    }

    private static String generateFieldsString(int level, Class<? extends Configuration> subjectClass) {
        StringBuilder sb = new StringBuilder();
        for (Field field : subjectClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            for (int i = 0; i < level; ++i) {
                sb.append("\t");
            }
            String helpString = HelpUtilities.getHelpString(field);
            sb.append(HelpUtilities.getName(field)).append("(").append(field.getType().getSimpleName()).append("): ").append(helpString).append("\n");
            if (!Configuration.class.isAssignableFrom(field.getType())) continue;
            sb.append(HelpUtilities.generateFieldsString(level + 1, field.getType()));
        }
        return sb.toString();
    }

    private static String getName(Field field) {
        Name annotation = field.getAnnotation(Name.class);
        return annotation != null ? annotation.name() : field.getName();
    }

    private static String getHelpString(Field field) {
        Help annotation = field.getAnnotation(Help.class);
        return annotation != null ? annotation.helpString() : "";
    }
}

