/*
 * Decompiled with CFR 0.152.
 */
package eu.aschuetz.nativeutils.api.structs;

import eu.aschuetz.nativeutils.api.structs.Iovec;
import eu.aschuetz.nativeutils.api.structs.Sockaddr;
import java.util.Objects;

public class Msghdr {
    private final Iovec[] msg_iov;
    private final byte[] msg_control;
    private final Sockaddr msg_name;
    private boolean complete;
    private boolean truncated;
    private boolean controlDataTruncated;
    private boolean outOfBand;
    private boolean errQueue;
    private int msg_controllen;

    public Msghdr(byte[] buf, int off, int len) {
        this(new Iovec(buf, off, len));
    }

    public Msghdr(Iovec msg_iov) {
        this(new Iovec[]{msg_iov});
    }

    public Msghdr(Iovec[] msg_iov) {
        this(msg_iov, null, null);
    }

    public Msghdr(Iovec[] msg_iov, Sockaddr sockaddr) {
        this(msg_iov, sockaddr, null);
    }

    public Msghdr(Iovec[] msg_iov, byte[] msg_control) {
        this(msg_iov, null, msg_control);
    }

    public Msghdr(Iovec msg_iov, Sockaddr sockaddr, byte[] msg_control) {
        this(new Iovec[]{msg_iov}, sockaddr, msg_control);
    }

    public Msghdr(Iovec[] msg_iov, Sockaddr sockaddr, byte[] msg_control) {
        this.msg_iov = Objects.requireNonNull(msg_iov);
        this.msg_control = msg_control;
        this.msg_controllen = msg_control == null ? 0 : msg_control.length;
        this.msg_name = sockaddr;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public boolean isControlDataTruncated() {
        return this.controlDataTruncated;
    }

    public boolean isOutOfBand() {
        return this.outOfBand;
    }

    public boolean isErrQueue() {
        return this.errQueue;
    }

    public Iovec[] getMsg_iov() {
        return this.msg_iov;
    }

    public byte[] getMsg_control() {
        return this.msg_control;
    }

    public Sockaddr getMsg_name() {
        return this.msg_name;
    }

    public int getMsg_controllen() {
        return this.msg_controllen;
    }
}

