/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg.ColorManager;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class SVGColorManager
extends ColorManager {
    protected String property;
    protected Value defaultValue;

    public SVGColorManager(String prop) {
        this(prop, ValueConstants.BLACK_RGB_VALUE);
    }

    public SVGColorManager(String prop, Value v) {
        this.property = prop;
        this.defaultValue = v;
    }

    public boolean isInheritedProperty() {
        return false;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return true;
    }

    public int getPropertyType() {
        return 6;
    }

    public String getPropertyName() {
        return this.property;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        if (lu.getLexicalUnitType() == 35 && lu.getStringValue().equalsIgnoreCase("currentcolor")) {
            return SVGValueConstants.CURRENTCOLOR_VALUE;
        }
        Value v = super.createValue(lu, engine);
        if ((lu = lu.getNextLexicalUnit()) == null) {
            return v;
        }
        if (lu.getLexicalUnitType() != 41 || !lu.getFunctionName().equalsIgnoreCase("icc-color")) {
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        }
        if ((lu = lu.getParameters()).getLexicalUnitType() != 35) {
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        }
        ListValue result2 = new ListValue(' ');
        result2.append(v);
        ICCColor icc = new ICCColor(lu.getStringValue());
        result2.append(icc);
        for (lu = lu.getNextLexicalUnit(); lu != null; lu = lu.getNextLexicalUnit()) {
            if (lu.getLexicalUnitType() != 0) {
                throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
            }
            if ((lu = lu.getNextLexicalUnit()) == null) {
                throw this.createInvalidLexicalUnitDOMException((short)-1);
            }
            icc.append(this.getColorValue(lu));
        }
        return result2;
    }

    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value2) {
        if (value2 == SVGValueConstants.CURRENTCOLOR_VALUE) {
            sm.putColorRelative(idx, true);
            int ci = engine.getColorIndex();
            return engine.getComputedStyle(elt, pseudo, ci);
        }
        if (value2.getCssValueType() == 2) {
            ListValue lv = (ListValue)value2;
            Value v = lv.item(0);
            Value t = super.computeValue(elt, pseudo, engine, idx, sm, v);
            if (t != v) {
                ListValue result2 = new ListValue(' ');
                result2.append(t);
                result2.append(lv.item(1));
                return result2;
            }
            return value2;
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value2);
    }

    protected float getColorValue(LexicalUnit lu) {
        switch (lu.getLexicalUnitType()) {
            case 13: {
                return lu.getIntegerValue();
            }
            case 14: {
                return lu.getFloatValue();
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }
}

