/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.batik.dom.util.DOMUtilitiesSupport;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtilities
extends XMLUtilities {
    protected static final String[] LOCK_STRINGS = new String[]{"", "CapsLock", "NumLock", "NumLock CapsLock", "Scroll", "Scroll CapsLock", "Scroll NumLock", "Scroll NumLock CapsLock", "KanaMode", "KanaMode CapsLock", "KanaMode NumLock", "KanaMode NumLock CapsLock", "KanaMode Scroll", "KanaMode Scroll CapsLock", "KanaMode Scroll NumLock", "KanaMode Scroll NumLock CapsLock"};
    protected static final String[] MODIFIER_STRINGS = new String[]{"", "Shift", "Control", "Control Shift", "Meta", "Meta Shift", "Control Meta", "Control Meta Shift", "Alt", "Alt Shift", "Alt Control", "Alt Control Shift", "Alt Meta", "Alt Meta Shift", "Alt Control Meta", "Alt Control Meta Shift", "AltGraph", "AltGraph Shift", "AltGraph Control", "AltGraph Control Shift", "AltGraph Meta", "AltGraph Meta Shift", "AltGraph Control Meta", "AltGraph Control Meta Shift", "Alt AltGraph", "Alt AltGraph Shift", "Alt AltGraph Control", "Alt AltGraph Control Shift", "Alt AltGraph Meta", "Alt AltGraph Meta Shift", "Alt AltGraph Control Meta", "Alt AltGraph Control Meta Shift"};

    protected DOMUtilities() {
    }

    public static void writeDocument(Document doc, Writer w) throws IOException {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            DOMUtilities.writeNode(n, w);
        }
    }

    public static void writeNode(Node n, Writer w) throws IOException {
        switch (n.getNodeType()) {
            case 1: {
                Node c;
                w.write("<");
                w.write(n.getNodeName());
                if (n.hasAttributes()) {
                    NamedNodeMap attr = n.getAttributes();
                    int len = attr.getLength();
                    for (int i = 0; i < len; ++i) {
                        Attr a = (Attr)attr.item(i);
                        w.write(" ");
                        w.write(a.getNodeName());
                        w.write("=\"");
                        w.write(DOMUtilities.contentToString(a.getNodeValue()));
                        w.write("\"");
                    }
                }
                if ((c = n.getFirstChild()) != null) {
                    w.write(">");
                    while (c != null) {
                        DOMUtilities.writeNode(c, w);
                        c = c.getNextSibling();
                    }
                    w.write("</");
                    w.write(n.getNodeName());
                    w.write(">");
                    break;
                }
                w.write("/>");
                break;
            }
            case 3: {
                w.write(DOMUtilities.contentToString(n.getNodeValue()));
                break;
            }
            case 4: {
                w.write("<![CDATA[");
                w.write(n.getNodeValue());
                w.write("]]>");
                break;
            }
            case 5: {
                w.write("&");
                w.write(n.getNodeName());
                w.write(";");
                break;
            }
            case 7: {
                w.write("<?");
                w.write(n.getNodeName());
                w.write(" ");
                w.write(n.getNodeValue());
                w.write("?>");
                break;
            }
            case 8: {
                w.write("<!--");
                w.write(n.getNodeValue());
                w.write("-->");
                break;
            }
            case 10: {
                DocumentType dt = (DocumentType)n;
                w.write("<!DOCTYPE ");
                w.write(n.getOwnerDocument().getDocumentElement().getNodeName());
                String pubID = dt.getPublicId();
                if (pubID != null) {
                    w.write(" PUBLIC \"" + dt.getNodeName() + "\" \"" + pubID + "\">");
                    break;
                }
                String sysID = dt.getSystemId();
                if (sysID == null) break;
                w.write(" SYSTEM \"" + sysID + "\">");
                break;
            }
            default: {
                throw new IOException("Unknown DOM node type " + n.getNodeType());
            }
        }
    }

    public static String getXML(Node n) {
        StringWriter writer = new StringWriter();
        try {
            DOMUtilities.writeNode(n, writer);
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            return "";
        }
        return ((Object)writer).toString();
    }

    public static String contentToString(String s2) {
        StringBuffer result2 = new StringBuffer(s2.length());
        block7: for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '<': {
                    result2.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result2.append("&gt;");
                    continue block7;
                }
                case '&': {
                    result2.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    result2.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    result2.append("&apos;");
                    continue block7;
                }
                default: {
                    result2.append(c);
                }
            }
        }
        return result2.toString();
    }

    public static int getChildIndex(Node child, Node parent) {
        if (child == null || child.getParentNode() != parent || child.getParentNode() == null) {
            return -1;
        }
        return DOMUtilities.getChildIndex(child);
    }

    public static int getChildIndex(Node child) {
        NodeList children2 = child.getParentNode().getChildNodes();
        for (int i = 0; i < children2.getLength(); ++i) {
            Node currentChild = children2.item(i);
            if (currentChild != child) continue;
            return i;
        }
        return -1;
    }

    public static boolean isAnyNodeAncestorOf(ArrayList ancestorNodes, Node node) {
        int n = ancestorNodes.size();
        for (int i = 0; i < n; ++i) {
            Node ancestor = (Node)ancestorNodes.get(i);
            if (!DOMUtilities.isAncestorOf(ancestor, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncestorOf(Node node, Node descendant2) {
        if (node == null || descendant2 == null) {
            return false;
        }
        for (Node currentNode = descendant2.getParentNode(); currentNode != null; currentNode = currentNode.getParentNode()) {
            if (currentNode != node) continue;
            return true;
        }
        return false;
    }

    public static boolean isParentOf(Node node, Node parentNode) {
        return node != null && parentNode != null && node.getParentNode() == parentNode;
    }

    public static boolean canAppend(Node node, Node parentNode) {
        return node != null && parentNode != null && node != parentNode && !DOMUtilities.isAncestorOf(node, parentNode);
    }

    public static boolean canAppendAny(ArrayList children2, Node parentNode) {
        if (!DOMUtilities.canHaveChildren(parentNode)) {
            return false;
        }
        int n = children2.size();
        for (int i = 0; i < n; ++i) {
            Node child = (Node)children2.get(i);
            if (!DOMUtilities.canAppend(child, parentNode)) continue;
            return true;
        }
        return false;
    }

    public static boolean canHaveChildren(Node parentNode) {
        if (parentNode == null) {
            return false;
        }
        switch (parentNode.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    public static Node parseXML(String text2, Document doc, String uri, Map prefixes, String wrapperElementName, SAXDocumentFactory documentFactory) {
        String wrapperElementPrefix = "";
        String wrapperElementSuffix = "";
        if (wrapperElementName != null) {
            wrapperElementPrefix = "<" + wrapperElementName;
            if (prefixes != null) {
                wrapperElementPrefix = wrapperElementPrefix + " ";
                Set keySet = prefixes.keySet();
                Iterator iter2 = keySet.iterator();
                while (iter2.hasNext()) {
                    String currentKey = (String)iter2.next();
                    String currentValue = (String)prefixes.get(currentKey);
                    wrapperElementPrefix = wrapperElementPrefix + currentKey + "=\"" + currentValue + "\" ";
                }
            }
            wrapperElementPrefix = wrapperElementPrefix + ">";
            wrapperElementSuffix = wrapperElementSuffix + "</" + wrapperElementName + ">";
        }
        if (wrapperElementPrefix.trim().length() == 0 && wrapperElementSuffix.trim().length() == 0) {
            try {
                Document d = documentFactory.createDocument(uri, new StringReader(text2));
                if (doc == null) {
                    return d;
                }
                DocumentFragment result2 = doc.createDocumentFragment();
                result2.appendChild(doc.importNode(d.getDocumentElement(), true));
                return result2;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        StringBuffer sb = new StringBuffer(wrapperElementPrefix.length() + text2.length() + wrapperElementSuffix.length());
        sb.append(wrapperElementPrefix);
        sb.append(text2);
        sb.append(wrapperElementSuffix);
        String newText = sb.toString();
        try {
            Document d = documentFactory.createDocument(uri, new StringReader(newText));
            if (doc == null) {
                return d;
            }
            for (Node node = d.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                node = doc.importNode(node, true);
                DocumentFragment result3 = doc.createDocumentFragment();
                result3.appendChild(node);
                return result3;
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        return null;
    }

    public static Document deepCloneDocument(Document doc, DOMImplementation impl) {
        Element root2 = doc.getDocumentElement();
        Document result2 = impl.createDocument(root2.getNamespaceURI(), root2.getNodeName(), null);
        Element rroot = result2.getDocumentElement();
        boolean before = true;
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n == root2) {
                before = false;
                if (root2.hasAttributes()) {
                    NamedNodeMap attr = root2.getAttributes();
                    int len = attr.getLength();
                    for (int i = 0; i < len; ++i) {
                        rroot.setAttributeNode((Attr)result2.importNode(attr.item(i), true));
                    }
                }
                for (Node c = root2.getFirstChild(); c != null; c = c.getNextSibling()) {
                    rroot.appendChild(result2.importNode(c, true));
                }
                continue;
            }
            if (n.getNodeType() == 10) continue;
            if (before) {
                result2.insertBefore(result2.importNode(n, true), rroot);
                continue;
            }
            result2.appendChild(result2.importNode(n, true));
        }
        return result2;
    }

    public static boolean isValidName(String s2) {
        int m;
        int len = s2.length();
        if (len == 0) {
            return false;
        }
        char c = s2.charAt(0);
        int d = c / 32;
        if ((NAME_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = s2.charAt(i);
            d = c / 32;
            if ((NAME_CHARACTER[d] & 1 << (m = c % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidName11(String s2) {
        int m;
        int len = s2.length();
        if (len == 0) {
            return false;
        }
        char c = s2.charAt(0);
        int d = c / 32;
        if ((NAME11_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = s2.charAt(i);
            d = c / 32;
            if ((NAME11_CHARACTER[d] & 1 << (m = c % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPrefix(String s2) {
        return s2.indexOf(58) == -1;
    }

    public static String getPrefix(String s2) {
        int i = s2.indexOf(58);
        return i == -1 || i == s2.length() - 1 ? null : s2.substring(0, i);
    }

    public static String getLocalName(String s2) {
        int i = s2.indexOf(58);
        return i == -1 || i == s2.length() - 1 ? s2 : s2.substring(i + 1);
    }

    public static void parseStyleSheetPIData(String data2, HashTable table) {
        char c;
        int i;
        for (i = 0; i < data2.length() && XMLUtilities.isXMLSpace(c = data2.charAt(i)); ++i) {
        }
        while (i < data2.length()) {
            int m;
            c = data2.charAt(i);
            int d = c / 32;
            if ((NAME_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + c);
            }
            StringBuffer ident2 = new StringBuffer();
            ident2.append(c);
            while (++i < data2.length() && (NAME_CHARACTER[d = (c = data2.charAt(i)) / 32] & 1 << (m = c % 32)) != 0) {
                ident2.append(c);
            }
            if (i >= data2.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data2);
            }
            while (i < data2.length() && XMLUtilities.isXMLSpace(c = data2.charAt(i))) {
                ++i;
            }
            if (i >= data2.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data2);
            }
            if (data2.charAt(i) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data2);
            }
            ++i;
            while (i < data2.length() && XMLUtilities.isXMLSpace(c = data2.charAt(i))) {
                ++i;
            }
            if (i >= data2.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data2);
            }
            c = data2.charAt(i);
            ++i;
            StringBuffer value2 = new StringBuffer();
            if (c == '\'') {
                while (i < data2.length() && (c = data2.charAt(i)) != '\'') {
                    value2.append(c);
                    ++i;
                }
                if (i >= data2.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data2);
                }
            } else if (c == '\"') {
                while (i < data2.length() && (c = data2.charAt(i)) != '\"') {
                    value2.append(c);
                    ++i;
                }
                if (i >= data2.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data2);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data2);
            }
            table.put(ident2.toString().intern(), value2.toString());
            ++i;
            while (i < data2.length() && XMLUtilities.isXMLSpace(c = data2.charAt(i))) {
                ++i;
            }
        }
    }

    public static String getModifiersList(int lockState, int modifiers) {
        return DOMUtilitiesSupport.getModifiersList(lockState, modifiers);
    }
}

