/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    private PathEntry[] paths;

    public ClassPath(String class_path) {
        ArrayList<PathEntry> vec = new ArrayList<PathEntry>();
        StringTokenizer tok = new StringTokenizer(class_path, System.getProperty("path.separator"));
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (path.equals("")) continue;
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    vec.add(new Dir(path));
                    continue;
                }
                vec.add(new Zip(new ZipFile(file)));
            }
            catch (IOException e) {
                System.err.println("CLASSPATH component " + file + ": " + e);
            }
        }
        this.paths = new PathEntry[vec.size()];
        vec.toArray(this.paths);
    }

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    private static final void getPathComponents(String path, ArrayList list2) {
        if (path != null) {
            StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                list2.add(name);
            }
        }
    }

    public static final String getClassPath() {
        String class_path = System.getProperty("java.class.path");
        String boot_path = System.getProperty("sun.boot.class.path");
        String ext_path = System.getProperty("java.ext.dirs");
        ArrayList<String> list2 = new ArrayList<String>();
        ClassPath.getPathComponents(class_path, list2);
        ClassPath.getPathComponents(boot_path, list2);
        ArrayList dirs = new ArrayList();
        ClassPath.getPathComponents(ext_path, dirs);
        Iterator e = ((AbstractList)dirs).iterator();
        while (e.hasNext()) {
            File ext_dir = new File((String)e.next());
            String[] extensions = ext_dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase()).endsWith(".zip") || name.endsWith(".jar");
                }
            });
            if (extensions == null) continue;
            int i = 0;
            while (i < extensions.length) {
                list2.add(ext_path + File.separatorChar + extensions[i]);
                ++i;
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator e2 = ((AbstractList)list2).iterator();
        while (e2.hasNext()) {
            buf.append((String)e2.next());
            if (!e2.hasNext()) continue;
            buf.append(File.pathSeparatorChar);
        }
        return buf.toString();
    }

    public InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, ".class");
    }

    public InputStream getInputStream(String name, String suffix) throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(name + suffix);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is != null) {
            return is;
        }
        return this.getClassFile(name, suffix).getInputStream();
    }

    public ClassFile getClassFile(String name, String suffix) throws IOException {
        int i = 0;
        while (i < this.paths.length) {
            ClassFile cf = this.paths[i].getClassFile(name, suffix);
            if (cf != null) {
                return cf;
            }
            ++i;
        }
        throw new IOException("Couldn't find: " + name + suffix);
    }

    public ClassFile getClassFile(String name) throws IOException {
        return this.getClassFile(name, ".class");
    }

    public byte[] getBytes(String name, String suffix) throws IOException {
        InputStream is = this.getInputStream(name, suffix);
        if (is == null) {
            throw new IOException("Couldn't find: " + name + suffix);
        }
        DataInputStream dis = new DataInputStream(is);
        byte[] bytes = new byte[is.available()];
        dis.readFully(bytes);
        dis.close();
        is.close();
        return bytes;
    }

    public byte[] getBytes(String name) throws IOException {
        return this.getBytes(name, ".class");
    }

    public String getPath(String name) throws IOException {
        int index2 = name.lastIndexOf(46);
        String suffix = "";
        if (index2 > 0) {
            suffix = name.substring(index2);
            name = name.substring(0, index2);
        }
        return this.getPath(name, suffix);
    }

    public String getPath(String name, String suffix) throws IOException {
        return this.getClassFile(name, suffix).getPath();
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile z) {
            this.zip = z;
        }

        ClassFile getClassFile(String name, String suffix) throws IOException {
            ZipEntry entry = this.zip.getEntry(name.replace('.', '/') + suffix);
            return entry != null ? new ClassFile(this, entry){
                private final /* synthetic */ ZipEntry val$entry;
                private final /* synthetic */ Zip this$0;
                {
                    this.this$0 = this$0;
                    this.val$entry = val$entry;
                }

                public InputStream getInputStream() throws IOException {
                    return Zip.access$100(this.this$0).getInputStream(this.val$entry);
                }

                public String getPath() {
                    return this.val$entry.toString();
                }

                public long getTime() {
                    return this.val$entry.getTime();
                }

                public long getSize() {
                    return this.val$entry.getSize();
                }
            } : null;
        }

        static /* synthetic */ ZipFile access$100(Zip x0) {
            return x0.zip;
        }
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(String d) {
            this.dir = d;
        }

        ClassFile getClassFile(String name, String suffix) throws IOException {
            File file = new File(this.dir + File.separatorChar + name.replace('.', File.separatorChar) + suffix);
            return file.exists() ? new ClassFile(this, file){
                private final /* synthetic */ File val$file;
                private final /* synthetic */ Dir this$0;
                {
                    this.this$0 = this$0;
                    this.val$file = val$file;
                }

                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(this.val$file);
                }

                public String getPath() {
                    try {
                        return this.val$file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                public long getTime() {
                    return this.val$file.lastModified();
                }

                public long getSize() {
                    return this.val$file.length();
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }
    }

    public static abstract class ClassFile {
        public abstract InputStream getInputStream() throws IOException;

        public abstract String getPath();

        public abstract long getTime();

        public abstract long getSize();
    }

    private static abstract class PathEntry {
        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;
    }
}

