/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ioca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.util.BinaryUtils;

public class ImageOutputControl
extends AbstractAFPObject {
    private int orientation = 0;
    private int xCoord = 0;
    private int yCoord = 0;
    private boolean singlePoint = true;

    public ImageOutputControl(int x, int y) {
        this.xCoord = x;
        this.yCoord = y;
    }

    public void writeToStream(OutputStream os) throws IOException {
        byte[] data2 = new byte[33];
        data2[0] = 90;
        data2[1] = 0;
        data2[2] = 32;
        data2[3] = -45;
        data2[4] = -89;
        data2[5] = 123;
        data2[6] = 0;
        data2[7] = 0;
        data2[8] = 0;
        byte[] x1 = BinaryUtils.convert(this.xCoord, 3);
        data2[9] = x1[0];
        data2[10] = x1[1];
        data2[11] = x1[2];
        byte[] x2 = BinaryUtils.convert(this.yCoord, 3);
        data2[12] = x2[0];
        data2[13] = x2[1];
        data2[14] = x2[2];
        switch (this.orientation) {
            case 0: {
                data2[15] = 0;
                data2[16] = 0;
                data2[17] = 45;
                data2[18] = 0;
                break;
            }
            case 90: {
                data2[15] = 45;
                data2[16] = 0;
                data2[17] = 90;
                data2[18] = 0;
                break;
            }
            case 180: {
                data2[15] = 90;
                data2[16] = 0;
                data2[17] = -121;
                data2[18] = 0;
                break;
            }
            case 270: {
                data2[15] = -121;
                data2[16] = 0;
                data2[17] = 0;
                data2[18] = 0;
                break;
            }
            default: {
                data2[15] = 0;
                data2[16] = 0;
                data2[17] = 45;
                data2[18] = 0;
            }
        }
        data2[19] = 0;
        data2[20] = 0;
        data2[21] = 0;
        data2[22] = 0;
        data2[23] = 0;
        data2[24] = 0;
        data2[25] = 0;
        data2[26] = 0;
        if (this.singlePoint) {
            data2[27] = 3;
            data2[28] = -24;
            data2[29] = 3;
            data2[30] = -24;
        } else {
            data2[27] = 7;
            data2[28] = -48;
            data2[29] = 7;
            data2[30] = -48;
        }
        data2[31] = -1;
        data2[32] = -1;
        os.write(data2);
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 90 && orientation != 180 && orientation != 270) {
            throw new IllegalArgumentException("The orientation must be one of the values 0, 90, 180, 270");
        }
        this.orientation = orientation;
    }

    public void setSinglepoint(boolean singlepoint) {
        this.singlePoint = singlepoint;
    }
}

