/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.AbstractTripletStructuredObject;
import org.apache.fop.afp.modca.ImageObject;
import org.apache.fop.afp.modca.Overlay;
import org.apache.fop.afp.util.BinaryUtils;

public class PreprocessPresentationObject
extends AbstractTripletStructuredObject {
    private static final byte TYPE_OTHER = -110;
    private static final byte TYPE_OVERLAY = -33;
    private static final byte TYPE_IMAGE = -5;
    private byte objType = (byte)-110;
    private byte objOrent = 0;
    private int objXOffset = -1;
    private int objYOffset = -1;
    public static final byte ORIENTATION_ZERO_DEGREES = 1;
    public static final byte ORIENTATION_90_DEGREES = 2;
    public static final byte ORIENTATION_180_DEGREES = 4;
    public static final byte ORIENTATION_270_DEGREES = 8;

    public PreprocessPresentationObject(AbstractTripletStructuredObject prePresObj) {
        if (prePresObj instanceof ImageObject || prePresObj instanceof Overlay) {
            this.objType = prePresObj instanceof ImageObject ? (byte)-5 : (byte)-33;
            this.setFullyQualifiedName((byte)-124, (byte)0, prePresObj.getFullyQualifiedName());
        } else {
            this.objType = (byte)-110;
        }
    }

    public void setOrientation(byte orientation) {
        this.objOrent = orientation;
    }

    public void setXOffset(int xOffset) {
        this.objXOffset = xOffset;
    }

    public void setYOffset(int yOffset) {
        this.objYOffset = yOffset;
    }

    public void writeStart(OutputStream os) throws IOException {
        super.writeStart(os);
        byte[] data2 = new byte[9];
        this.copySF(data2, (byte)-83, (byte)-61);
        byte[] l = BinaryUtils.convert(19 + this.getTripletDataLength(), 2);
        data2[1] = l[0];
        data2[2] = l[1];
        os.write(data2);
    }

    public void writeContent(OutputStream os) throws IOException {
        byte[] data2 = new byte[12];
        byte[] l = BinaryUtils.convert(12 + this.getTripletDataLength(), 2);
        data2[0] = l[0];
        data2[1] = l[1];
        data2[2] = this.objType;
        data2[3] = 0;
        data2[4] = 0;
        data2[5] = this.objOrent;
        if (this.objXOffset > 0) {
            byte[] xOff = BinaryUtils.convert(this.objYOffset, 3);
            data2[6] = xOff[0];
            data2[7] = xOff[1];
            data2[8] = xOff[2];
        } else {
            data2[6] = -1;
            data2[7] = -1;
            data2[8] = -1;
        }
        if (this.objYOffset > 0) {
            byte[] yOff = BinaryUtils.convert(this.objYOffset, 3);
            data2[9] = yOff[0];
            data2[10] = yOff[1];
            data2[11] = yOff[2];
        } else {
            data2[9] = -1;
            data2[10] = -1;
            data2[11] = -1;
        }
        os.write(data2);
        this.writeTriplets(os);
    }
}

