/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.ptoca.PtocaConstants;
import org.apache.fop.afp.util.BinaryUtils;

public class PresentationTextData
extends AbstractAFPObject
implements PtocaConstants {
    private static final int MAX_SIZE = 8192;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private static final int HEADER_LENGTH = 9;

    public PresentationTextData() {
        this(false);
    }

    public PresentationTextData(boolean controlInd) {
        byte[] data2 = new byte[]{90, 0, 0, -45, -18, -101, 0, 0, 0};
        this.baos.write(data2, 0, 9);
        if (controlInd) {
            this.baos.write(new byte[]{43, -45}, 0, 2);
        }
    }

    public int getBytesAvailable() {
        return 8192 - this.baos.size() + 9;
    }

    protected OutputStream getOutputStream() {
        return this.baos;
    }

    public void writeToStream(OutputStream os) throws IOException {
        assert (this.getBytesAvailable() >= 0);
        byte[] data2 = this.baos.toByteArray();
        byte[] size2 = BinaryUtils.convert(data2.length - 1, 2);
        data2[1] = size2[0];
        data2[2] = size2[1];
        os.write(data2);
    }
}

