/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.modca.ResourceObject;
import org.apache.fop.afp.parser.MODCAParser;
import org.apache.fop.afp.parser.UnparsedStructuredField;

public final class AFPResourceUtil {
    private static final byte TYPE_CODE_BEGIN = -88;
    private static final byte TYPE_CODE_END = -87;
    private static final Log LOG = LogFactory.getLog(AFPResourceUtil.class);

    private AFPResourceUtil() {
    }

    public static byte[] getNext(byte[] identifier, InputStream inputStream) throws IOException {
        UnparsedStructuredField field2;
        MODCAParser parser = new MODCAParser(inputStream);
        do {
            if ((field2 = parser.readNextStructuredField()) != null) continue;
            return null;
        } while (field2.getSfClassCode() != identifier[0] || field2.getSfTypeCode() != identifier[1] || field2.getSfCategoryCode() != identifier[2]);
        return field2.getCompleteFieldAsBytes();
    }

    private static String getResourceName(UnparsedStructuredField field2) throws UnsupportedEncodingException {
        byte[] nameBytes = new byte[8];
        byte[] fieldData = field2.getData();
        if (fieldData.length < 8) {
            throw new IllegalArgumentException("Field data does not contain a resource name");
        }
        System.arraycopy(fieldData, 0, nameBytes, 0, 8);
        return new String(nameBytes, "Cp1146");
    }

    public static void copyResourceFile(InputStream in, OutputStream out) throws IOException {
        UnparsedStructuredField field2;
        MODCAParser parser = new MODCAParser(in);
        while ((field2 = parser.readNextStructuredField()) != null) {
            out.write(90);
            field2.writeTo(out);
        }
    }

    public static void copyNamedResource(String name, InputStream in, final OutputStream out) throws IOException {
        boolean wrapInResource;
        UnparsedStructuredField field2;
        final MODCAParser parser = new MODCAParser(in);
        HashSet<String> resourceNames = new HashSet<String>();
        while (true) {
            if ((field2 = parser.readNextStructuredField()) == null) {
                throw new IOException("Requested resource '" + name + "' not found. Encountered resource names: " + resourceNames);
            }
            if (field2.getSfTypeCode() != -88) continue;
            String resourceName = AFPResourceUtil.getResourceName(field2);
            resourceNames.add(resourceName);
            if (resourceName.equals(name)) break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start of requested structured field found:\n" + field2);
        }
        final UnparsedStructuredField fieldBegin = field2;
        if (fieldBegin.getSfCategoryCode() == 95) {
            wrapInResource = true;
        } else if (fieldBegin.getSfCategoryCode() == -50) {
            wrapInResource = false;
        } else {
            throw new IOException("Cannot handle resource: " + fieldBegin);
        }
        if (wrapInResource) {
            ResourceObject resourceObject = new ResourceObject(name){

                protected void writeContent(OutputStream os) throws IOException {
                    AFPResourceUtil.copyNamedStructuredFields(this.name, fieldBegin, parser, out);
                }
            };
            resourceObject.setType((byte)-5);
            resourceObject.writeToStream(out);
        } else {
            AFPResourceUtil.copyNamedStructuredFields(name, fieldBegin, parser, out);
        }
    }

    private static void copyNamedStructuredFields(String name, UnparsedStructuredField fieldBegin, MODCAParser parser, OutputStream out) throws IOException {
        UnparsedStructuredField field2 = fieldBegin;
        while (true) {
            if (field2 == null) {
                throw new IOException("Ending structured field not found for resource " + name);
            }
            out.write(90);
            field2.writeTo(out);
            if (field2.getSfTypeCode() == -87 && fieldBegin.getSfCategoryCode() == field2.getSfCategoryCode() && name.equals(AFPResourceUtil.getResourceName(field2))) break;
            field2 = parser.readNextStructuredField();
        }
    }
}

