/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.Span;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.traits.WritingModeTraitsGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageViewport
extends AreaTreeObject
implements Resolvable {
    private Page page;
    private Rectangle viewArea;
    private String simplePageMasterName;
    private String pageKey;
    private int pageNumber = -1;
    private String pageNumberString = null;
    private int pageIndex = -1;
    private boolean blank;
    private transient PageSequence pageSequence;
    private Set<String> idFirsts = new HashSet<String>();
    private Map<String, List<Resolvable>> unresolvedIDRefs = new HashMap<String, List<Resolvable>>();
    private Map<String, List<PageViewport>> pendingResolved = null;
    private Map<String, Marker> markerFirstStart = null;
    private Map<String, Marker> markerLastStart = null;
    private Map<String, Marker> markerFirstAny = null;
    private Map<String, Marker> markerLastEnd = null;
    private Map<String, Marker> markerLastAny = null;
    protected static final Log log = LogFactory.getLog(PageViewport.class);

    public PageViewport(SimplePageMaster spm, int pageNumber, String pageStr, boolean blank, boolean spanAll) {
        this.simplePageMasterName = spm.getMasterName();
        this.setExtensionAttachments(spm.getExtensionAttachments());
        this.setForeignAttributes(spm.getForeignAttributes());
        this.blank = blank;
        int pageWidth = spm.getPageWidth().getValue();
        int pageHeight = spm.getPageHeight().getValue();
        this.pageNumber = pageNumber;
        this.pageNumberString = pageStr;
        this.viewArea = new Rectangle(0, 0, pageWidth, pageHeight);
        this.page = new Page(spm);
        this.createSpan(spanAll);
    }

    public PageViewport(SimplePageMaster spm, int pageNumber, String pageStr, boolean blank) {
        this(spm, pageNumber, pageStr, blank, false);
    }

    public PageViewport(PageViewport original) throws FOPException {
        if (original.extensionAttachments != null) {
            this.setExtensionAttachments(original.extensionAttachments);
        }
        if (original.foreignAttributes != null) {
            this.setForeignAttributes(original.foreignAttributes);
        }
        this.pageIndex = original.pageIndex;
        this.pageNumber = original.pageNumber;
        this.pageNumberString = original.pageNumberString;
        try {
            this.page = (Page)original.page.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new FOPException(e);
        }
        this.viewArea = new Rectangle(original.viewArea);
        this.simplePageMasterName = original.simplePageMasterName;
        this.blank = original.blank;
    }

    public PageViewport(Rectangle viewArea, int pageNumber, String pageStr, String simplePageMasterName, boolean blank) {
        this.viewArea = viewArea;
        this.pageNumber = pageNumber;
        this.pageNumberString = pageStr;
        this.simplePageMasterName = simplePageMasterName;
        this.blank = blank;
    }

    public void setPageSequence(PageSequence seq) {
        this.pageSequence = seq;
    }

    public PageSequence getPageSequence() {
        return this.pageSequence;
    }

    public Rectangle getViewArea() {
        return this.viewArea;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public String getPageNumberString() {
        return this.pageNumberString;
    }

    public void setPageIndex(int index2) {
        this.pageIndex = index2;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setKey(String key) {
        this.pageKey = key;
    }

    public String getKey() {
        if (this.pageKey == null) {
            throw new IllegalStateException("No page key set on the PageViewport: " + this.toString());
        }
        return this.pageKey;
    }

    public void setFirstWithID(String id) {
        if (id != null) {
            this.idFirsts.add(id);
        }
    }

    public boolean isFirstWithID(String id) {
        return this.idFirsts.contains(id);
    }

    public void addUnresolvedIDRef(String idref, Resolvable res) {
        List<Resolvable> pageViewports;
        if (this.unresolvedIDRefs == null) {
            this.unresolvedIDRefs = new HashMap<String, List<Resolvable>>();
        }
        if ((pageViewports = this.unresolvedIDRefs.get(idref)) == null) {
            pageViewports = new ArrayList<Resolvable>();
            this.unresolvedIDRefs.put(idref, pageViewports);
        }
        pageViewports.add(res);
    }

    @Override
    public boolean isResolved() {
        return this.unresolvedIDRefs == null || this.unresolvedIDRefs.size() == 0;
    }

    @Override
    public String[] getIDRefs() {
        return this.unresolvedIDRefs == null ? null : this.unresolvedIDRefs.keySet().toArray(new String[this.unresolvedIDRefs.keySet().size()]);
    }

    @Override
    public void resolveIDRef(String id, List<PageViewport> pages) {
        List<Resolvable> todo;
        if (this.page == null) {
            if (this.pendingResolved == null) {
                this.pendingResolved = new HashMap<String, List<PageViewport>>();
            }
            this.pendingResolved.put(id, pages);
        } else if (this.unresolvedIDRefs != null && (todo = this.unresolvedIDRefs.get(id)) != null) {
            for (Resolvable res : todo) {
                res.resolveIDRef(id, pages);
            }
        }
        if (this.unresolvedIDRefs != null && pages != null) {
            this.unresolvedIDRefs.remove(id);
            if (this.unresolvedIDRefs.isEmpty()) {
                this.unresolvedIDRefs = null;
            }
        }
    }

    public void addMarkers(Map<String, Marker> marks, boolean starting, boolean isfirst, boolean islast) {
        if (marks == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("--" + marks.keySet() + ": " + (starting ? "starting" : "ending") + (isfirst ? ", first" : "") + (islast ? ", last" : ""));
        }
        if (starting) {
            if (isfirst) {
                if (this.markerFirstStart == null) {
                    this.markerFirstStart = new HashMap<String, Marker>();
                }
                if (this.markerFirstAny == null) {
                    this.markerFirstAny = new HashMap<String, Marker>();
                }
                for (String key : marks.keySet()) {
                    if (!this.markerFirstStart.containsKey(key)) {
                        this.markerFirstStart.put(key, marks.get(key));
                        if (log.isTraceEnabled()) {
                            log.trace("page " + this.pageNumberString + ": " + "Adding marker " + key + " to FirstStart");
                        }
                    }
                    if (this.markerFirstAny.containsKey(key)) continue;
                    this.markerFirstAny.put(key, marks.get(key));
                    if (!log.isTraceEnabled()) continue;
                    log.trace("page " + this.pageNumberString + ": " + "Adding marker " + key + " to FirstAny");
                }
                if (this.markerLastStart == null) {
                    this.markerLastStart = new HashMap<String, Marker>();
                }
                this.markerLastStart.putAll(marks);
                if (log.isTraceEnabled()) {
                    log.trace("page " + this.pageNumberString + ": " + "Adding all markers to LastStart");
                }
            } else {
                if (this.markerFirstAny == null) {
                    this.markerFirstAny = new HashMap<String, Marker>();
                }
                for (String key : marks.keySet()) {
                    if (this.markerFirstAny.containsKey(key)) continue;
                    this.markerFirstAny.put(key, marks.get(key));
                    if (!log.isTraceEnabled()) continue;
                    log.trace("page " + this.pageNumberString + ": " + "Adding marker " + key + " to FirstAny");
                }
            }
        } else {
            if (islast) {
                if (this.markerLastEnd == null) {
                    this.markerLastEnd = new HashMap<String, Marker>();
                }
                this.markerLastEnd.putAll(marks);
                if (log.isTraceEnabled()) {
                    log.trace("page " + this.pageNumberString + ": " + "Adding all markers to LastEnd");
                }
            }
            if (this.markerLastAny == null) {
                this.markerLastAny = new HashMap<String, Marker>();
            }
            this.markerLastAny.putAll(marks);
            if (log.isTraceEnabled()) {
                log.trace("page " + this.pageNumberString + ": " + "Adding all markers to LastAny");
            }
        }
    }

    public Marker getMarker(String name, int pos) {
        Marker mark = null;
        String posName = null;
        switch (pos) {
            case 54: {
                if (this.markerFirstStart != null) {
                    mark = this.markerFirstStart.get(name);
                    posName = "FSWP";
                }
                if (mark != null || this.markerFirstAny == null) break;
                mark = this.markerFirstAny.get(name);
                posName = "FirstAny after " + posName;
                break;
            }
            case 49: {
                if (this.markerFirstAny == null) break;
                mark = this.markerFirstAny.get(name);
                posName = "FIC";
                break;
            }
            case 81: {
                if (this.markerLastStart != null) {
                    mark = this.markerLastStart.get(name);
                    posName = "LSWP";
                }
                if (mark != null || this.markerLastAny == null) break;
                mark = this.markerLastAny.get(name);
                posName = "LastAny after " + posName;
                break;
            }
            case 74: {
                if (this.markerLastEnd != null) {
                    mark = this.markerLastEnd.get(name);
                    posName = "LEWP";
                }
                if (mark != null || this.markerLastAny == null) break;
                mark = this.markerLastAny.get(name);
                posName = "LastAny after " + posName;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("page " + this.pageNumberString + ": " + "Retrieving marker " + name + " at position " + posName);
        }
        return mark;
    }

    public void dumpMarkers() {
        if (log.isTraceEnabled()) {
            log.trace("FirstAny: " + this.markerFirstAny);
            log.trace("FirstStart: " + this.markerFirstStart);
            log.trace("LastAny: " + this.markerLastAny);
            log.trace("LastEnd: " + this.markerLastEnd);
            log.trace("LastStart: " + this.markerLastStart);
        }
    }

    public void savePage(ObjectOutputStream out) throws IOException {
        this.page.setUnresolvedReferences(this.unresolvedIDRefs);
        out.writeObject(this.page);
        this.page = null;
    }

    public void loadPage(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.page = (Page)in.readObject();
        this.unresolvedIDRefs = this.page.getUnresolvedReferences();
        if (this.unresolvedIDRefs != null && this.pendingResolved != null) {
            for (String id : this.pendingResolved.keySet()) {
                this.resolveIDRef(id, this.pendingResolved.get(id));
            }
            this.pendingResolved = null;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PageViewport pvp = (PageViewport)super.clone();
        pvp.page = (Page)this.page.clone();
        pvp.viewArea = (Rectangle)this.viewArea.clone();
        return pvp;
    }

    public void clear() {
        this.page = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("PageViewport: page=");
        sb.append(this.getPageNumberString());
        return sb.toString();
    }

    public String getSimplePageMasterName() {
        return this.simplePageMasterName;
    }

    public boolean isBlank() {
        return this.blank;
    }

    public BodyRegion getBodyRegion() {
        return (BodyRegion)this.getPage().getRegionViewport(58).getRegionReference();
    }

    public Span createSpan(boolean spanAll) {
        return this.getBodyRegion().getMainReference().createSpan(spanAll);
    }

    public Span getCurrentSpan() {
        return this.getBodyRegion().getMainReference().getCurrentSpan();
    }

    public NormalFlow getCurrentFlow() {
        return this.getCurrentSpan().getCurrentFlow();
    }

    public NormalFlow moveToNextFlow() {
        return this.getCurrentSpan().moveToNextFlow();
    }

    public RegionReference getRegionReference(int id) {
        return this.getPage().getRegionViewport(id).getRegionReference();
    }

    public void setWritingModeTraits(WritingModeTraitsGetter wmtg) {
        if (this.page != null) {
            this.page.setWritingModeTraits(wmtg);
        }
    }
}

