/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFColorHandler;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPaintingState;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFTextUtil;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.pdf.CTMHelper;

public class PDFContentGenerator {
    protected static final boolean WRITE_COMMENTS = true;
    private PDFDocument document;
    private OutputStream outputStream;
    private PDFResourceContext resourceContext;
    private PDFStream currentStream;
    private PDFColorHandler colorHandler;
    protected PDFPaintingState currentState = null;
    protected PDFTextUtil textutil;
    private boolean inMarkedContentSequence;
    private boolean inArtifactMode;

    public PDFContentGenerator(PDFDocument document2, OutputStream out, PDFResourceContext resourceContext) {
        this.document = document2;
        this.outputStream = out;
        this.resourceContext = resourceContext;
        this.currentStream = document2.getFactory().makeStream("content", false);
        this.textutil = new PDFTextUtil(){

            protected void write(String code) {
                PDFContentGenerator.this.currentStream.add(code);
            }
        };
        this.currentState = new PDFPaintingState();
        this.colorHandler = new PDFColorHandler(document2.getResources());
    }

    public PDFDocument getDocument() {
        return this.document;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public PDFResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public PDFStream getStream() {
        return this.currentStream;
    }

    public PDFPaintingState getState() {
        return this.currentState;
    }

    public PDFTextUtil getTextUtil() {
        return this.textutil;
    }

    public void flushPDFDoc() throws IOException {
        this.document.output(this.outputStream);
    }

    protected void comment(String text2) {
        this.currentStream.add("% " + text2 + "\n");
    }

    protected void saveGraphicsState() {
        this.endTextObject();
        this.currentState.save();
        this.currentStream.add("q\n");
    }

    protected void saveGraphicsState(String structElemType, int sequenceNum) {
        this.endTextObject();
        this.currentState.save();
        this.beginMarkedContentSequence(structElemType, sequenceNum);
        this.currentStream.add("q\n");
    }

    protected void beginMarkedContentSequence(String structElemType, int mcid) {
        assert (!this.inMarkedContentSequence);
        assert (!this.inArtifactMode);
        if (structElemType != null) {
            this.currentStream.add(structElemType + " <</MCID " + String.valueOf(mcid) + ">>\n" + "BDC\n");
        } else {
            this.currentStream.add("/Artifact\nBMC\n");
            this.inArtifactMode = true;
        }
        this.inMarkedContentSequence = true;
    }

    void endMarkedContentSequence() {
        this.currentStream.add("EMC\n");
        this.inMarkedContentSequence = false;
        this.inArtifactMode = false;
    }

    protected void restoreGraphicsState(boolean popState) {
        this.endTextObject();
        this.currentStream.add("Q\n");
        if (popState) {
            this.currentState.restore();
        }
    }

    protected void restoreGraphicsState() {
        this.restoreGraphicsState(true);
    }

    protected void restoreGraphicsStateAccess() {
        this.endTextObject();
        this.currentStream.add("Q\n");
        if (this.inMarkedContentSequence) {
            this.endMarkedContentSequence();
        }
        this.currentState.restore();
    }

    protected void separateTextElements(String structElemType, int mcid) {
        this.textutil.endTextObject();
        this.endMarkedContentSequence();
        this.beginMarkedContentSequence(structElemType, mcid);
        this.textutil.beginTextObject();
    }

    protected void beginTextObject() {
        if (!this.textutil.isInTextObject()) {
            this.textutil.beginTextObject();
        }
    }

    protected void beginTextObject(String structElemType, int mcid) {
        if (!this.textutil.isInTextObject()) {
            this.beginMarkedContentSequence(structElemType, mcid);
            this.textutil.beginTextObject();
        }
    }

    protected void endTextObject() {
        if (this.textutil.isInTextObject()) {
            this.textutil.endTextObject();
            if (this.inMarkedContentSequence) {
                this.endMarkedContentSequence();
            }
        }
    }

    public void concatenate(AffineTransform transform2) {
        if (!transform2.isIdentity()) {
            this.currentState.concatenate(transform2);
            this.currentStream.add(CTMHelper.toPDFString(transform2, false) + " cm\n");
        }
    }

    public void clipRect(Rectangle rect) {
        StringBuffer sb = new StringBuffer();
        sb.append(PDFContentGenerator.format((float)rect.x / 1000.0f)).append(' ');
        sb.append(PDFContentGenerator.format((float)rect.y / 1000.0f)).append(' ');
        sb.append(PDFContentGenerator.format((float)rect.width / 1000.0f)).append(' ');
        sb.append(PDFContentGenerator.format((float)rect.height / 1000.0f)).append(" re W n\n");
        this.add(sb.toString());
    }

    public void add(String content) {
        this.currentStream.add(content);
    }

    public static final String format(float value2) {
        return PDFNumber.doubleOut(value2);
    }

    public void updateLineWidth(float width) {
        if (this.currentState.setLineWidth(width)) {
            this.currentStream.add(PDFContentGenerator.format(width) + " w\n");
        }
    }

    public void updateCharacterSpacing(float value2) {
        if (this.getState().setCharacterSpacing(value2)) {
            this.currentStream.add(PDFContentGenerator.format(value2) + " Tc\n");
        }
    }

    public void setColor(Color col, boolean fill2, PDFStream stream) {
        assert (stream != null);
        StringBuffer sb = new StringBuffer();
        this.setColor(col, fill2, sb);
        stream.add(sb.toString());
    }

    public void setColor(Color col, boolean fill2) {
        this.setColor(col, fill2, this.getStream());
    }

    protected void setColor(Color col, boolean fill2, StringBuffer pdf) {
        if (pdf != null) {
            this.colorHandler.establishColor(pdf, col, fill2);
        } else {
            this.setColor(col, fill2, this.currentStream);
        }
    }

    public void updateColor(Color col, boolean fill2, StringBuffer pdf) {
        if (col == null) {
            return;
        }
        boolean update2 = false;
        update2 = fill2 ? this.getState().setBackColor(col) : this.getState().setColor(col);
        if (update2) {
            this.setColor(col, fill2, pdf);
        }
    }

    public void placeImage(float x, float y, float w, float h, PDFXObject xobj) {
        this.saveGraphicsState();
        this.add(PDFContentGenerator.format(w) + " 0 0 " + PDFContentGenerator.format(-h) + " " + PDFContentGenerator.format(x) + " " + PDFContentGenerator.format(y + h) + " cm\n" + xobj.getName() + " Do\n");
        this.restoreGraphicsState();
    }

    public void placeImage(float x, float y, float w, float h, PDFXObject xobj, String structElemType, int mcid) {
        this.saveGraphicsState(structElemType, mcid);
        this.add(PDFContentGenerator.format(w) + " 0 0 " + PDFContentGenerator.format(-h) + " " + PDFContentGenerator.format(x) + " " + PDFContentGenerator.format(y + h) + " cm\n" + xobj.getName() + " Do\n");
        this.restoreGraphicsStateAccess();
    }
}

