/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.tools;

import java.util.Stack;
import org.apache.fop.render.rtf.rtflib.exceptions.RtfException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfOptions;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.tools.TableContext;

public class BuilderContext {
    private final Stack containers = new Stack();
    private final Stack tableContexts = new Stack();
    private final Stack builders = new Stack();
    private IRtfOptions options;

    public BuilderContext(IRtfOptions rtfOptions) {
        this.options = rtfOptions;
    }

    private Object getObjectFromStack(Stack s2, Class desiredClass) {
        Object result2 = null;
        Stack copy = (Stack)s2.clone();
        while (!copy.isEmpty()) {
            Object o = copy.pop();
            if (!desiredClass.isAssignableFrom(o.getClass())) continue;
            result2 = o;
            break;
        }
        return result2;
    }

    public RtfContainer getContainer(Class containerClass, boolean required, Object forWhichBuilder) throws RtfException {
        RtfContainer result2 = (RtfContainer)this.getObjectFromStack(this.containers, containerClass);
        if (result2 == null && required) {
            throw new RtfException("No RtfContainer of class '" + containerClass.getName() + "' available for '" + forWhichBuilder.getClass().getName() + "' builder");
        }
        return result2;
    }

    public void pushContainer(RtfContainer c) {
        this.containers.push(c);
    }

    public void replaceContainer(RtfContainer oldC, RtfContainer newC) throws Exception {
        int index2 = this.containers.indexOf(oldC);
        if (index2 < 0) {
            throw new Exception("container to replace not found:" + oldC);
        }
        this.containers.setElementAt(newC, index2);
    }

    public void popContainer() {
        this.containers.pop();
    }

    public TableContext getTableContext() {
        return (TableContext)this.tableContexts.peek();
    }

    public void pushTableContext(TableContext tc) {
        this.tableContexts.push(tc);
    }

    public void popTableContext() {
        this.tableContexts.pop();
    }
}

