/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler.util;

import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.Type;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;

final class SlotAllocator {
    private int _firstAvailableSlot;
    private int _size = 8;
    private int _free = 0;
    private int[] _slotsTaken = new int[this._size];

    SlotAllocator() {
    }

    public void initialize(LocalVariableGen[] vars) {
        int length = vars.length;
        int slot = 0;
        int i = 0;
        while (i < length) {
            int size2 = vars[i].getType().getSize();
            int index2 = vars[i].getIndex();
            slot = Math.max(slot, index2 + size2);
            ++i;
        }
        this._firstAvailableSlot = slot;
    }

    public int allocateSlot(Type type) {
        int size2 = type.getSize();
        int limit = this._free;
        int slot = this._firstAvailableSlot;
        int where = 0;
        if (this._free + size2 > this._size) {
            int[] array = new int[this._size *= 2];
            int j = 0;
            while (j < limit) {
                array[j] = this._slotsTaken[j];
                ++j;
            }
            this._slotsTaken = array;
        }
        while (where < limit) {
            if (slot + size2 <= this._slotsTaken[where]) {
                int j = limit - 1;
                while (j >= where) {
                    this._slotsTaken[j + size2] = this._slotsTaken[j];
                    --j;
                }
                break;
            }
            slot = this._slotsTaken[where++] + 1;
        }
        int j = 0;
        while (j < size2) {
            this._slotsTaken[where + j] = slot + j;
            ++j;
        }
        this._free += size2;
        return slot;
    }

    public void releaseSlot(LocalVariableGen lvg) {
        int size2 = lvg.getType().getSize();
        int slot = lvg.getIndex();
        int limit = this._free;
        int i = 0;
        while (i < limit) {
            if (this._slotsTaken[i] == slot) {
                int j = i + size2;
                while (j < limit) {
                    this._slotsTaken[i++] = this._slotsTaken[j++];
                }
                this._free -= size2;
                return;
            }
            ++i;
        }
        String state = "Variable slot allocation error(size=" + size2 + ", slot=" + slot + ", limit=" + limit + ")";
        ErrorMsg err2 = new ErrorMsg("INTERNAL_ERR", state);
        throw new Error(err2.toString());
    }
}

