/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;

public class TIFFDirectory
implements Serializable {
    boolean isBigEndian;
    int numEntries;
    TIFFField[] fields;
    Map fieldIndex = new HashMap();
    long IFDOffset = 8L;
    long nextIFDOffset = 0L;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    TIFFDirectory() {
    }

    private static boolean isValidEndianTag(int endian) {
        return endian == 18761 || endian == 19789;
    }

    public TIFFDirectory(SeekableStream stream, int directory) throws IOException {
        long global_save_offset = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFDirectory1"));
        }
        this.isBigEndian = endian == 19789;
        int magic = this.readUnsignedShort(stream);
        if (magic != 42) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFDirectory2"));
        }
        long ifd_offset = this.readUnsignedInt(stream);
        for (int i = 0; i < directory; ++i) {
            if (ifd_offset == 0L) {
                throw new IllegalArgumentException(PropertyUtil.getString("TIFFDirectory3"));
            }
            stream.seek(ifd_offset);
            long entries = this.readUnsignedShort(stream);
            stream.skip(12L * entries);
            ifd_offset = this.readUnsignedInt(stream);
        }
        if (ifd_offset == 0L) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFDirectory3"));
        }
        stream.seek(ifd_offset);
        this.initialize(stream);
        stream.seek(global_save_offset);
    }

    public TIFFDirectory(SeekableStream stream, long ifd_offset, int directory) throws IOException {
        long global_save_offset = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFDirectory1"));
        }
        this.isBigEndian = endian == 19789;
        stream.seek(ifd_offset);
        for (int dirNum = 0; dirNum < directory; ++dirNum) {
            long numEntries = this.readUnsignedShort(stream);
            stream.seek(ifd_offset + 12L * numEntries);
            ifd_offset = this.readUnsignedInt(stream);
            stream.seek(ifd_offset);
        }
        this.initialize(stream);
        stream.seek(global_save_offset);
    }

    private void initialize(SeekableStream stream) throws IOException {
        this.IFDOffset = stream.getFilePointer();
        this.numEntries = this.readUnsignedShort(stream);
        this.fields = new TIFFField[this.numEntries];
        for (int i = 0; i < this.numEntries; ++i) {
            long nextTagOffset;
            int count2;
            int type;
            int tag;
            block25: {
                tag = this.readUnsignedShort(stream);
                type = this.readUnsignedShort(stream);
                count2 = (int)this.readUnsignedInt(stream);
                int value2 = 0;
                nextTagOffset = stream.getFilePointer() + 4L;
                try {
                    if (count2 * sizeOfType[type] <= 4) break block25;
                    value2 = (int)this.readUnsignedInt(stream);
                    stream.seek(value2);
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    stream.seek(nextTagOffset);
                    continue;
                }
            }
            this.fieldIndex.put(new Integer(tag), new Integer(i));
            Object obj = null;
            switch (type) {
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    byte[] bvalues = new byte[count2];
                    stream.readFully(bvalues, 0, count2);
                    if (type == 2) {
                        int index2 = 0;
                        int prevIndex = 0;
                        ArrayList<String> v = new ArrayList<String>();
                        while (index2 < count2) {
                            while (index2 < count2 && bvalues[index2++] != 0) {
                            }
                            v.add(new String(bvalues, prevIndex, index2 - prevIndex));
                            prevIndex = index2;
                        }
                        count2 = v.size();
                        String[] strings = new String[count2];
                        v.toArray(strings);
                        obj = strings;
                        break;
                    }
                    obj = bvalues;
                    break;
                }
                case 3: {
                    int j;
                    char[] cvalues = new char[count2];
                    for (j = 0; j < count2; ++j) {
                        cvalues[j] = (char)this.readUnsignedShort(stream);
                    }
                    obj = cvalues;
                    break;
                }
                case 4: {
                    int j;
                    long[] lvalues = new long[count2];
                    for (j = 0; j < count2; ++j) {
                        lvalues[j] = this.readUnsignedInt(stream);
                    }
                    obj = lvalues;
                    break;
                }
                case 5: {
                    int j;
                    long[][] llvalues = new long[count2][2];
                    for (j = 0; j < count2; ++j) {
                        llvalues[j][0] = this.readUnsignedInt(stream);
                        llvalues[j][1] = this.readUnsignedInt(stream);
                    }
                    obj = llvalues;
                    break;
                }
                case 8: {
                    int j;
                    short[] svalues = new short[count2];
                    for (j = 0; j < count2; ++j) {
                        svalues[j] = this.readShort(stream);
                    }
                    obj = svalues;
                    break;
                }
                case 9: {
                    int j;
                    int[] ivalues = new int[count2];
                    for (j = 0; j < count2; ++j) {
                        ivalues[j] = this.readInt(stream);
                    }
                    obj = ivalues;
                    break;
                }
                case 10: {
                    int j;
                    int[][] iivalues = new int[count2][2];
                    for (j = 0; j < count2; ++j) {
                        iivalues[j][0] = this.readInt(stream);
                        iivalues[j][1] = this.readInt(stream);
                    }
                    obj = iivalues;
                    break;
                }
                case 11: {
                    int j;
                    float[] fvalues = new float[count2];
                    for (j = 0; j < count2; ++j) {
                        fvalues[j] = this.readFloat(stream);
                    }
                    obj = fvalues;
                    break;
                }
                case 12: {
                    int j;
                    double[] dvalues = new double[count2];
                    for (j = 0; j < count2; ++j) {
                        dvalues[j] = this.readDouble(stream);
                    }
                    obj = dvalues;
                    break;
                }
                default: {
                    throw new RuntimeException(PropertyUtil.getString("TIFFDirectory0"));
                }
            }
            this.fields[i] = new TIFFField(tag, type, count2, obj);
            stream.seek(nextTagOffset);
        }
        this.nextIFDOffset = this.readUnsignedInt(stream);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public TIFFField getField(int tag) {
        Integer i = (Integer)this.fieldIndex.get(new Integer(tag));
        if (i == null) {
            return null;
        }
        return this.fields[i];
    }

    public boolean isTagPresent(int tag) {
        return this.fieldIndex.containsKey(new Integer(tag));
    }

    public int[] getTags() {
        int[] tags = new int[this.fieldIndex.size()];
        Iterator iter2 = this.fieldIndex.keySet().iterator();
        int i = 0;
        while (iter2.hasNext()) {
            tags[i++] = (Integer)iter2.next();
        }
        return tags;
    }

    public TIFFField[] getFields() {
        return this.fields;
    }

    public byte getFieldAsByte(int tag, int index2) {
        Integer i = (Integer)this.fieldIndex.get(new Integer(tag));
        byte[] b = this.fields[i].getAsBytes();
        return b[index2];
    }

    public byte getFieldAsByte(int tag) {
        return this.getFieldAsByte(tag, 0);
    }

    public long getFieldAsLong(int tag, int index2) {
        Integer i = (Integer)this.fieldIndex.get(new Integer(tag));
        return this.fields[i].getAsLong(index2);
    }

    public long getFieldAsLong(int tag) {
        return this.getFieldAsLong(tag, 0);
    }

    public float getFieldAsFloat(int tag, int index2) {
        Integer i = (Integer)this.fieldIndex.get(new Integer(tag));
        return this.fields[i].getAsFloat(index2);
    }

    public float getFieldAsFloat(int tag) {
        return this.getFieldAsFloat(tag, 0);
    }

    public double getFieldAsDouble(int tag, int index2) {
        Integer i = (Integer)this.fieldIndex.get(new Integer(tag));
        return this.fields[i].getAsDouble(index2);
    }

    public double getFieldAsDouble(int tag) {
        return this.getFieldAsDouble(tag, 0);
    }

    private short readShort(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readShort();
        }
        return stream.readShortLE();
    }

    private int readUnsignedShort(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readUnsignedShort();
        }
        return stream.readUnsignedShortLE();
    }

    private int readInt(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readInt();
        }
        return stream.readIntLE();
    }

    private long readUnsignedInt(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readUnsignedInt();
        }
        return stream.readUnsignedIntLE();
    }

    private long readLong(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readLong();
        }
        return stream.readLongLE();
    }

    private float readFloat(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readFloat();
        }
        return stream.readFloatLE();
    }

    private double readDouble(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readDouble();
        }
        return stream.readDoubleLE();
    }

    private static int readUnsignedShort(SeekableStream stream, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return stream.readUnsignedShort();
        }
        return stream.readUnsignedShortLE();
    }

    private static long readUnsignedInt(SeekableStream stream, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return stream.readUnsignedInt();
        }
        return stream.readUnsignedIntLE();
    }

    public static int getNumDirectories(SeekableStream stream) throws IOException {
        long pointer = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFDirectory1"));
        }
        boolean isBigEndian = endian == 19789;
        int magic = TIFFDirectory.readUnsignedShort(stream, isBigEndian);
        if (magic != 42) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFDirectory2"));
        }
        stream.seek(4L);
        long offset = TIFFDirectory.readUnsignedInt(stream, isBigEndian);
        int numDirectories = 0;
        while (offset != 0L) {
            ++numDirectories;
            stream.seek(offset);
            long entries = TIFFDirectory.readUnsignedShort(stream, isBigEndian);
            stream.skip(12L * entries);
            offset = TIFFDirectory.readUnsignedInt(stream, isBigEndian);
        }
        stream.seek(pointer);
        return numDirectories;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public long getIFDOffset() {
        return this.IFDOffset;
    }

    public long getNextIFDOffset() {
        return this.nextIFDOffset;
    }
}

