/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp.schemas;

import java.util.Date;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.XMPSchemaAdapter;
import org.apache.xmlgraphics.xmp.XMPSchemaRegistry;

public class DublinCoreAdapter
extends XMPSchemaAdapter {
    private static final String CONTRIBUTOR = "contributor";
    private static final String COVERAGE = "coverage";
    private static final String CREATOR = "creator";
    private static final String DATE = "date";
    private static final String DESCRIPTION = "description";
    private static final String FORMAT = "format";
    private static final String IDENTIFIER = "identifier";
    private static final String LANGUAGE = "language";
    private static final String PUBLISHER = "publisher";
    private static final String RELATION = "relation";
    private static final String RIGHTS = "rights";
    private static final String SOURCE = "source";
    private static final String SUBJECT = "subject";
    private static final String TITLE = "title";
    private static final String TYPE = "type";

    public DublinCoreAdapter(Metadata meta) {
        super(meta, XMPSchemaRegistry.getInstance().getSchema("http://purl.org/dc/elements/1.1/"));
    }

    public void addContributor(String value2) {
        this.addStringToBag(CONTRIBUTOR, value2);
    }

    public boolean removeContributor(String value2) {
        return this.removeStringFromArray(CONTRIBUTOR, value2);
    }

    public String[] getContributors() {
        return this.getStringArray(CONTRIBUTOR);
    }

    public void setCoverage(String value2) {
        this.setValue(COVERAGE, value2);
    }

    public String getCoverage() {
        return this.getValue(COVERAGE);
    }

    public void addCreator(String value2) {
        this.addStringToSeq(CREATOR, value2);
    }

    public boolean removeCreator(String value2) {
        return this.removeStringFromArray(CREATOR, value2);
    }

    public String[] getCreators() {
        return this.getStringArray(CREATOR);
    }

    public void addDate(Date value2) {
        this.addDateToSeq(DATE, value2);
    }

    public Date[] getDates() {
        return this.getDateArray(DATE);
    }

    public Date getDate() {
        Date[] dates = this.getDates();
        if (dates != null) {
            Date latest = null;
            int c = dates.length;
            for (int i = 0; i < c; ++i) {
                if (latest != null && dates[i].getTime() <= latest.getTime()) continue;
                latest = dates[i];
            }
            return latest;
        }
        return null;
    }

    public void setDescription(String lang, String value2) {
        this.setLangAlt(DESCRIPTION, lang, value2);
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(String lang) {
        return this.getLangAlt(lang, DESCRIPTION);
    }

    public void setFormat(String value2) {
        this.setValue(FORMAT, value2);
    }

    public String getFormat() {
        return this.getValue(FORMAT);
    }

    public void setIdentifier(String value2) {
        this.setValue(IDENTIFIER, value2);
    }

    public String getIdentifier() {
        return this.getValue(IDENTIFIER);
    }

    public void addLanguage(String value2) {
        this.addStringToBag(LANGUAGE, value2);
    }

    public String[] getLanguages() {
        return this.getStringArray(LANGUAGE);
    }

    public void addPublisher(String value2) {
        this.addStringToBag(PUBLISHER, value2);
    }

    public String[] getPublisher() {
        return this.getStringArray(PUBLISHER);
    }

    public void addRelation(String value2) {
        this.addStringToBag(RELATION, value2);
    }

    public String[] getRelations() {
        return this.getStringArray(RELATION);
    }

    public void setRights(String lang, String value2) {
        this.setLangAlt(RIGHTS, lang, value2);
    }

    public String getRights() {
        return this.getRights(null);
    }

    public String getRights(String lang) {
        return this.getLangAlt(lang, RIGHTS);
    }

    public void setSource(String value2) {
        this.setValue(SOURCE, value2);
    }

    public String getSource() {
        return this.getValue(SOURCE);
    }

    public void addSubject(String value2) {
        this.addStringToBag(SUBJECT, value2);
    }

    public String[] getSubjects() {
        return this.getStringArray(SUBJECT);
    }

    public void setTitle(String value2) {
        this.setTitle(null, value2);
    }

    public void setTitle(String lang, String value2) {
        this.setLangAlt(TITLE, lang, value2);
    }

    public String getTitle() {
        return this.getTitle(null);
    }

    public String getTitle(String lang) {
        return this.getLangAlt(lang, TITLE);
    }

    public String removeTitle(String lang) {
        return this.removeLangAlt(lang, TITLE);
    }

    public void addType(String value2) {
        this.addStringToBag(TYPE, value2);
    }

    public String[] getTypes() {
        return this.getStringArray(TYPE);
    }
}

