/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import java.util.Iterator;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.AbstractElement;
import org.gedcom4j.model.PersonalName;
import org.gedcom4j.model.PersonalNameVariation;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.CitationValidator;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.PersonalNameVariationValidator;

public class PersonalNameValidator
extends AbstractValidator {
    private PersonalName pn;

    public PersonalNameValidator(GedcomValidator rootValidator, PersonalName pn) {
        this.rootValidator = rootValidator;
        this.pn = pn;
    }

    protected void validate() {
        PersonalNameVariation pnv;
        PersonalNameVariation nv;
        Iterator<AbstractElement> i$;
        if (this.pn == null) {
            this.addError("Personal name was null - cannot validate");
            return;
        }
        this.checkRequiredString(this.pn.basic, "basic name", (Object)this.pn);
        if (this.pn.citations == null) {
            if (this.rootValidator.autorepair) {
                this.pn.citations = new ArrayList<AbstractCitation>();
                this.addInfo("citations collection for personal name was null - autorepaired", this.pn);
            } else {
                this.addError("citations collection for personal name is null", this.pn);
            }
        }
        if (this.pn.citations != null) {
            for (AbstractCitation c : this.pn.citations) {
                new CitationValidator(this.rootValidator, c).validate();
            }
        }
        this.checkCustomTags(this.pn);
        this.checkOptionalString(this.pn.givenName, "given name", (Object)this.pn);
        this.checkOptionalString(this.pn.nickname, "nickname", (Object)this.pn);
        this.checkOptionalString(this.pn.prefix, "prefix", (Object)this.pn);
        this.checkOptionalString(this.pn.suffix, "suffix", (Object)this.pn);
        this.checkOptionalString(this.pn.surname, "surname", (Object)this.pn);
        this.checkOptionalString(this.pn.surnamePrefix, "surname prefix", (Object)this.pn);
        this.checkNotes(this.pn.notes, this.pn);
        if (this.pn.phonetic == null) {
            if (this.rootValidator.autorepair) {
                this.pn.phonetic = new ArrayList<PersonalNameVariation>();
                this.rootValidator.addInfo("Event had null list of phonetic name variations - repaired", this.pn);
            } else {
                this.rootValidator.addError("Event has null list of phonetic name variations", this.pn);
            }
        } else {
            i$ = this.pn.phonetic.iterator();
            while (i$.hasNext()) {
                pnv = nv = (PersonalNameVariation)i$.next();
                new PersonalNameVariationValidator(this.rootValidator, pnv).validate();
            }
        }
        if (this.pn.romanized == null) {
            if (this.rootValidator.autorepair) {
                this.pn.romanized = new ArrayList<PersonalNameVariation>();
                this.rootValidator.addInfo("Event had null list of romanized name variations - repaired", this.pn);
            } else {
                this.rootValidator.addError("Event has null list of romanized name variations", this.pn);
            }
        } else {
            i$ = this.pn.romanized.iterator();
            while (i$.hasNext()) {
                pnv = nv = (PersonalNameVariation)i$.next();
                new PersonalNameVariationValidator(this.rootValidator, pnv).validate();
            }
        }
    }
}

