/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeJavaPackage
extends ScriptableObject {
    static final long serialVersionUID = 7445054382212031523L;
    private String packageName;
    private ClassLoader classLoader;

    NativeJavaPackage(boolean bl, String string2, ClassLoader classLoader) {
        this.packageName = string2;
        this.classLoader = classLoader;
    }

    public NativeJavaPackage(String string2, ClassLoader classLoader) {
        this(false, string2, classLoader);
    }

    public NativeJavaPackage(String string2) {
        this(false, string2, Context.getCurrentContext().getApplicationClassLoader());
    }

    public String getClassName() {
        return "JavaPackage";
    }

    public boolean has(String string2, Scriptable scriptable) {
        return true;
    }

    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    public void put(String string2, Scriptable scriptable, Object object) {
    }

    public void put(int n, Scriptable scriptable, Object object) {
        throw Context.reportRuntimeError0("msg.pkg.int");
    }

    public Object get(String string2, Scriptable scriptable) {
        return this.getPkgProperty(string2, scriptable, true);
    }

    public Object get(int n, Scriptable scriptable) {
        return NOT_FOUND;
    }

    void forcePackage(String string2, Scriptable scriptable) {
        NativeJavaPackage nativeJavaPackage;
        String string3;
        Object object;
        int n = string2.indexOf(46);
        if (n == -1) {
            n = string2.length();
        }
        if ((object = super.get(string3 = string2.substring(0, n), (Scriptable)this)) != null && object instanceof NativeJavaPackage) {
            nativeJavaPackage = (NativeJavaPackage)object;
        } else {
            String string4 = this.packageName.length() == 0 ? string3 : this.packageName + "." + string3;
            nativeJavaPackage = new NativeJavaPackage(true, string4, this.classLoader);
            ScriptRuntime.setObjectProtoAndParent(nativeJavaPackage, scriptable);
            super.put(string3, (Scriptable)this, (Object)nativeJavaPackage);
        }
        if (n < string2.length()) {
            nativeJavaPackage.forcePackage(string2.substring(n + 1), scriptable);
        }
    }

    synchronized Object getPkgProperty(String string2, Scriptable scriptable, boolean bl) {
        Serializable serializable2;
        Object object = super.get(string2, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        String string3 = this.packageName.length() == 0 ? string2 : this.packageName + '.' + string2;
        Context context = Context.getContext();
        ClassShutter classShutter = context.getClassShutter();
        Serializable serializable3 = null;
        if (classShutter == null || classShutter.visibleToScripts(string3)) {
            serializable2 = null;
            serializable2 = this.classLoader != null ? Kit.classOrNull(this.classLoader, string3) : Kit.classOrNull(string3);
            if (serializable2 != null) {
                serializable3 = new NativeJavaClass(NativeJavaPackage.getTopLevelScope(this), (Class)serializable2);
                serializable3.setPrototype(this.getPrototype());
            }
        }
        if (serializable3 == null && bl) {
            serializable2 = new NativeJavaPackage(true, string3, this.classLoader);
            ScriptRuntime.setObjectProtoAndParent((ScriptableObject)serializable2, this.getParentScope());
            serializable3 = serializable2;
        }
        if (serializable3 != null) {
            super.put(string2, scriptable, serializable3);
        }
        return serializable3;
    }

    public Object getDefaultValue(Class clazz) {
        return this.toString();
    }

    public String toString() {
        return "[JavaPackage " + this.packageName + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof NativeJavaPackage) {
            NativeJavaPackage nativeJavaPackage = (NativeJavaPackage)object;
            return this.packageName.equals(nativeJavaPackage.packageName) && this.classLoader == nativeJavaPackage.classLoader;
        }
        return false;
    }

    public int hashCode() {
        return this.packageName.hashCode() ^ (this.classLoader == null ? 0 : this.classLoader.hashCode());
    }
}

