/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.FilePopupMenu;
import org.mozilla.javascript.tools.debugger.FileWindow;

class FileTextArea
extends JTextArea
implements ActionListener,
PopupMenuListener,
KeyListener,
MouseListener {
    private static final long serialVersionUID = -25032065448563720L;
    private FileWindow w;
    private FilePopupMenu popup;

    public FileTextArea(FileWindow fileWindow) {
        this.w = fileWindow;
        this.popup = new FilePopupMenu(this);
        this.popup.addPopupMenuListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setFont(new Font("Monospaced", 0, 12));
    }

    public void select(int n) {
        block9: {
            if (n >= 0) {
                try {
                    Serializable serializable2;
                    int n2 = this.getLineOfOffset(n);
                    Serializable serializable3 = this.modelToView(n);
                    if (serializable3 == null) {
                        this.select(n, n);
                        break block9;
                    }
                    try {
                        serializable2 = this.modelToView(this.getLineStartOffset(n2 + 1));
                        if (serializable2 != null) {
                            serializable3 = serializable2;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    serializable2 = (JViewport)this.getParent();
                    Rectangle rectangle = serializable2.getViewRect();
                    if (rectangle.y + rectangle.height > serializable3.y) {
                        this.select(n, n);
                    } else {
                        serializable3.y += (rectangle.height - serializable3.height) / 2;
                        this.scrollRectToVisible((Rectangle)serializable3);
                        this.select(n, n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.select(n, n);
                }
            }
        }
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
        this.requestFocus();
        this.getCaret().setVisible(true);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.viewToModel(new Point(this.popup.x, this.popup.y));
        this.popup.setVisible(false);
        String string2 = actionEvent.getActionCommand();
        int n2 = -1;
        try {
            n2 = this.getLineOfOffset(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2.equals("Set Breakpoint")) {
            this.w.setBreakPoint(n2 + 1);
        } else if (string2.equals("Clear Breakpoint")) {
            this.w.clearBreakPoint(n2 + 1);
        } else if (string2.equals("Run")) {
            this.w.load();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 8: 
            case 9: 
            case 10: 
            case 127: {
                keyEvent.consume();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }
}

