/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.mozilla.javascript.tools.debugger.SwingGui;

class MyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2971618907207577000L;
    private SwingGui debugGui;
    private Vector expressions;
    private Vector values;

    public MyTableModel(SwingGui swingGui) {
        this.debugGui = swingGui;
        this.expressions = new Vector();
        this.values = new Vector();
        this.expressions.addElement("");
        this.values.addElement("");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.expressions.size();
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Expression";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.expressions.elementAt(n);
            }
            case 1: {
                return this.values.elementAt(n);
            }
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                String string2 = object.toString();
                this.expressions.setElementAt(string2, n);
                String string3 = "";
                if (string2.length() > 0 && (string3 = this.debugGui.dim.eval(string2)) == null) {
                    string3 = "";
                }
                this.values.setElementAt(string3, n);
                this.updateModel();
                if (n + 1 != this.expressions.size()) break;
                this.expressions.addElement("");
                this.values.addElement("");
                this.fireTableRowsInserted(n + 1, n + 1);
                break;
            }
            case 1: {
                this.fireTableDataChanged();
            }
        }
    }

    void updateModel() {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Object e = this.expressions.elementAt(i);
            String string2 = e.toString();
            String string3 = "";
            if (string2.length() > 0) {
                string3 = this.debugGui.dim.eval(string2);
                if (string3 == null) {
                    string3 = "";
                }
            } else {
                string3 = "";
            }
            string3 = string3.replace('\n', ' ');
            this.values.setElementAt(string3, i);
        }
        this.fireTableDataChanged();
    }
}

