/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api._internal;

import com.droidkit.actors.ActorCreator;
import com.droidkit.actors.Props;
import com.droidkit.actors.tasks.TaskActor;
import im.actor.api.ActorApiConfig;
import im.actor.api.mtp.AuthIdRetreiver;
import im.actor.api.util.ExponentialBackoff;

public class AuthBuildActor
extends TaskActor<Long> {
    private ExponentialBackoff backoff;
    private ActorApiConfig config;

    public static Props<AuthBuildActor> auth(final ActorApiConfig config, final ExponentialBackoff backoff) {
        return Props.create(AuthBuildActor.class, (ActorCreator)new ActorCreator<AuthBuildActor>(){

            public AuthBuildActor create() {
                return new AuthBuildActor(config, backoff);
            }
        });
    }

    public AuthBuildActor(ActorApiConfig config, ExponentialBackoff backoff) {
        this.backoff = backoff;
        this.config = config;
    }

    public void startTask() {
        this.self().send((Object)new RequestKey());
    }

    public void onReceive(Object message) {
        super.onReceive(message);
        if (message instanceof RequestKey) {
            this.request();
        }
    }

    private void request() {
        AuthIdRetreiver.requestAuthId(this.config, new AuthIdRetreiver.AuthIdCallback(){

            @Override
            public void onSuccess(long authId) {
                AuthBuildActor.this.backoff.onSuccess();
                AuthBuildActor.this.complete(authId);
            }

            @Override
            public void onFailure(Exception e) {
                AuthBuildActor.this.backoff.onFailure();
                AuthBuildActor.this.self().send((Object)new RequestKey(), AuthBuildActor.this.backoff.exponentialWait());
            }
        });
    }

    private static class RequestKey {
        private RequestKey() {
        }
    }
}

