/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api._internal;

import com.droidkit.actors.Actor;
import com.droidkit.actors.ActorCreator;
import com.droidkit.actors.ActorRef;
import com.droidkit.actors.ActorSelection;
import com.droidkit.actors.Props;
import com.droidkit.actors.tasks.AskCallback;
import im.actor.api.ActorApiCallback;
import im.actor.api.ActorApiConfig;
import im.actor.api.LogInterface;
import im.actor.api._internal.AuthBuildActor;
import im.actor.api._internal.RawRequestActor;
import im.actor.api.crypto.Crypto;
import im.actor.api.mtp.MTProto;
import im.actor.api.mtp.MTProtoParams;
import im.actor.api.mtp._internal.entity.message.rpc.RpcRequest;
import im.actor.api.mtp.messages.AuthIdInvalidated;
import im.actor.api.mtp.messages.Confirmed;
import im.actor.api.mtp.messages.NewSessionCreated;
import im.actor.api.mtp.messages.RpcError;
import im.actor.api.mtp.messages.RpcMessage;
import im.actor.api.mtp.messages.Update;
import im.actor.api.parser.Request;
import im.actor.api.parser.Response;
import im.actor.api.parser.RpcScope;
import im.actor.api.scheme.base.FatSeqUpdate;
import im.actor.api.scheme.base.SeqUpdate;
import im.actor.api.scheme.base.SeqUpdateTooLong;
import im.actor.api.scheme.base.WeakUpdate;
import im.actor.api.scheme.parser.RpcParser;
import im.actor.api.scheme.parser.UpdatesParser;
import im.actor.api.util.ExponentialBackoff;
import java.util.HashMap;

public class ApiBrokerActor
extends Actor {
    private static final String TAG = "ApiBroker";
    private static final int CONNECTIONS_COUNT = 1;
    private final LogInterface LOG;
    private final boolean DEBUG;
    private final String ID;
    private final ActorApiConfig CONFIG;
    private final RpcParser rpcParser;
    private final UpdatesParser updatesParser;
    private MTProto protocol;
    private HashMap<Long, RequestHolder> requests = new HashMap();
    private HashMap<Long, Long> idMap = new HashMap();
    private ActorApiCallback apiCallback;
    private ExponentialBackoff backoff;

    public static ActorSelection broker(final String id, final ActorApiConfig config) {
        return new ActorSelection(Props.create(ApiBrokerActor.class, (ActorCreator)new ActorCreator<ApiBrokerActor>(){

            public ApiBrokerActor create() {
                return new ApiBrokerActor(id, config);
            }
        }), "/actor-api/" + id + "/broker");
    }

    public ApiBrokerActor(String id, ActorApiConfig config) {
        this.LOG = config.getLogInterface();
        this.DEBUG = config.isDebugLog();
        this.ID = id;
        this.CONFIG = config;
        this.apiCallback = config.getApiCallback();
        this.rpcParser = new RpcParser();
        this.updatesParser = new UpdatesParser();
        this.backoff = new ExponentialBackoff();
    }

    public void preStart() {
        if (this.CONFIG.getApiStorage().getAuthKey() != 0L) {
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "We have auth id, creating proto");
            }
            MTProtoParams params = new MTProtoParams(this.CONFIG.getApiStorage().getAuthKey(), Crypto.generateSessionId(), this.CONFIG);
            this.protocol = new MTProto(params, "/actor-api/" + this.ID + "/mtp", 1, this.self());
        } else {
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "Requesting auth id");
            }
            this.ask(new ActorSelection(AuthBuildActor.auth(this.CONFIG, this.backoff), "/actor-api/" + this.ID + "/auth_id"), (AskCallback)new AskCallback<Long>(){

                public void onResult(Long result) {
                    ApiBrokerActor.this.self().send((Object)new KeyCreated(result));
                }

                public void onError(Throwable throwable) {
                }
            });
        }
    }

    public void onReceive(Object message) {
        if (message instanceof SendRequest) {
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "New request #" + ((SendRequest)message).randomId);
            }
            SendRequest req = (SendRequest)message;
            RequestHolder holder = new RequestHolder(req.getRandomId(), new RpcRequest(req.getMessage().getHeaderKey(), req.getMessage().toByteArray()), this.sender());
            this.requests.put(holder.publicId, holder);
            if (this.protocol != null) {
                holder.protoId = this.protocol.sendRpcRequest(holder.message);
                if (this.DEBUG && this.LOG != null) {
                    this.LOG.d(TAG, "#" + ((SendRequest)message).randomId + " -> #" + holder.protoId);
                }
                this.idMap.put(holder.protoId, holder.publicId);
            }
        } else if (message instanceof CancelRequest) {
            RequestHolder holder;
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "Cancel request #" + ((CancelRequest)message).getRequestId());
            }
            if ((holder = this.requests.remove(((CancelRequest)message).getRequestId())) != null) {
                if (this.protocol != null) {
                    this.protocol.cancelRequest(holder.protoId);
                }
                this.idMap.remove(holder.protoId);
            }
        } else if (message instanceof NetworkChanged) {
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "Network changed");
            }
            if (this.protocol != null) {
                this.protocol.notifyNetworkStateChanged();
            }
        } else if (message instanceof KeyCreated) {
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "Key created");
            }
            this.onKeyCreated(((KeyCreated)message).getKey());
        } else if (message instanceof AuthIdInvalidated) {
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "AuthIdInvalidated");
            }
            this.apiCallback.onAuthIdInvalidated();
        } else if (message instanceof Confirmed) {
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "Confirmed #" + ((Confirmed)message).getMessageId());
            }
        } else if (message instanceof NewSessionCreated) {
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "NewSessionCreated");
            }
            this.apiCallback.onNewSessionCreated();
        } else if (message instanceof RpcError) {
            long pubId;
            RequestHolder holder;
            RpcError rpcError = (RpcError)message;
            if (this.DEBUG && this.LOG != null) {
                this.LOG.w(TAG, "RpcError #" + rpcError.getErrorCode() + " " + rpcError.getErrorTag());
            }
            if (this.idMap.containsKey(rpcError.getMessageId()) && (holder = this.requests.remove(pubId = this.idMap.remove(rpcError.getMessageId()).longValue())) != null) {
                holder.receiver.send((Object)new RawRequestActor.RpcError(rpcError.getErrorCode(), rpcError.getErrorTag(), rpcError.getErrorUserMessage(), rpcError.isCanTryAgain(), rpcError.getRelatedData()));
            }
        } else if (message instanceof RpcMessage) {
            long pubId;
            RequestHolder holder;
            RpcMessage rpcMessage = (RpcMessage)message;
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "RpcResponse #" + rpcMessage.getMessageId());
            }
            if (this.idMap.containsKey(rpcMessage.getMessageId()) && (holder = this.requests.get(pubId = this.idMap.get(rpcMessage.getMessageId()).longValue())) != null) {
                try {
                    Response result = (Response)this.rpcParser.read(rpcMessage.getPayloadType(), rpcMessage.getPayload());
                    this.requests.remove(pubId);
                    this.idMap.remove(rpcMessage.getMessageId());
                    holder.receiver.send((Object)new RawRequestActor.RpcResult(result));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (message instanceof Update) {
            Update update = (Update)message;
            if (this.DEBUG && this.LOG != null) {
                this.LOG.d(TAG, "Received update");
            }
            try {
                RpcScope msg = this.rpcParser.read(update.getUpdateType(), update.getPayload());
                if (msg instanceof SeqUpdate) {
                    SeqUpdate commonUpdate = (SeqUpdate)msg;
                    if (this.DEBUG && this.LOG != null) {
                        this.LOG.d(TAG, "Received update: common");
                    }
                    try {
                        im.actor.api.parser.Update upd = this.updatesParser.read(commonUpdate.getUpdateHeader(), commonUpdate.getUpdate());
                        this.apiCallback.onSeqUpdate(commonUpdate.getSeq(), commonUpdate.getState(), upd);
                    }
                    catch (Exception e) {
                        if (this.LOG != null) {
                            this.LOG.w(TAG, "Unable to load update");
                            this.LOG.e(TAG, e);
                        }
                        this.apiCallback.onSeqTooLong();
                    }
                } else if (msg instanceof FatSeqUpdate) {
                    FatSeqUpdate seqUpdate = (FatSeqUpdate)msg;
                    try {
                        im.actor.api.parser.Update upd = this.updatesParser.read(seqUpdate.getUpdateHeader(), seqUpdate.getUpdate());
                        this.apiCallback.onSeqFatUpdate(seqUpdate.getSeq(), seqUpdate.getState(), upd, seqUpdate.getUsers(), seqUpdate.getGroups());
                    }
                    catch (Exception e) {
                        if (this.LOG != null) {
                            this.LOG.w(TAG, "Unable to load update");
                            this.LOG.e(TAG, e);
                        }
                        this.apiCallback.onSeqTooLong();
                    }
                } else if (msg instanceof SeqUpdateTooLong) {
                    if (this.DEBUG && this.LOG != null) {
                        this.LOG.d(TAG, "Received update: too long");
                    }
                    this.apiCallback.onSeqTooLong();
                } else if (msg instanceof WeakUpdate) {
                    if (this.DEBUG && this.LOG != null) {
                        this.LOG.d(TAG, "Received update: weak update");
                    }
                    WeakUpdate weakUpdate = (WeakUpdate)msg;
                    im.actor.api.parser.Update weakMessage = this.updatesParser.read(weakUpdate.getUpdateHeader(), weakUpdate.getUpdate());
                    this.apiCallback.onWeakUpdate(weakUpdate.getDate(), weakMessage);
                }
            }
            catch (Exception e) {
                if (this.LOG != null) {
                    this.LOG.w(TAG, "Unable to parse update");
                }
                e.printStackTrace();
            }
        } else if (message instanceof Destroy) {
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "Destroying of API");
            }
            if (this.protocol != null) {
                this.protocol.close();
            }
            this.context().stopSelf();
        }
    }

    private void onKeyCreated(long key) {
        this.CONFIG.getApiStorage().saveAuthKey(key);
        MTProtoParams params = new MTProtoParams(key, Crypto.generateSessionId(), this.CONFIG);
        this.protocol = new MTProto(params, "/actor-api/" + this.ID + "/mtp", 1, this.self());
        for (RequestHolder holder : this.requests.values()) {
            if (holder.protoId != 0L) continue;
            holder.protoId = this.protocol.sendRpcRequest(holder.message);
            if (this.LOG != null && this.DEBUG) {
                this.LOG.d(TAG, "#" + holder.publicId + " -> #" + holder.protoId);
            }
            this.idMap.put(holder.protoId, holder.publicId);
        }
    }

    private class RequestHolder {
        private RpcRequest message;
        private ActorRef receiver;
        private long publicId;
        private long protoId;

        private RequestHolder(long publicId, RpcRequest message, ActorRef receiver) {
            this.message = message;
            this.receiver = receiver;
            this.publicId = publicId;
        }
    }

    public static final class Destroy {
    }

    private static final class KeyCreated {
        private long key;

        public KeyCreated(long key) {
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }
    }

    public static final class NetworkChanged {
    }

    public static final class CancelRequest {
        private long requestId;

        public CancelRequest(long requestId) {
            this.requestId = requestId;
        }

        public long getRequestId() {
            return this.requestId;
        }
    }

    public static final class SendRequest {
        private long randomId;
        private Request message;

        public SendRequest(long randomId, Request message) {
            this.randomId = randomId;
            this.message = message;
        }

        public long getRandomId() {
            return this.randomId;
        }

        public Request getMessage() {
            return this.message;
        }
    }
}

