/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.scheme.rpc;

import com.droidkit.bser.Bser;
import com.droidkit.bser.BserObject;
import com.droidkit.bser.BserValues;
import com.droidkit.bser.BserWriter;
import im.actor.api.parser.Request;
import im.actor.api.scheme.FileLocation;
import im.actor.api.scheme.rpc.ResponseGetFile;
import java.io.IOException;

public class RequestGetFile
extends Request<ResponseGetFile> {
    public static final int HEADER = 16;
    private FileLocation fileLocation;
    private int offset;
    private int limit;

    public static RequestGetFile fromBytes(byte[] data) throws IOException {
        return (RequestGetFile)Bser.parse(RequestGetFile.class, (byte[])data);
    }

    public RequestGetFile(FileLocation fileLocation, int offset, int limit) {
        this.fileLocation = fileLocation;
        this.offset = offset;
        this.limit = limit;
    }

    public RequestGetFile() {
    }

    public FileLocation getFileLocation() {
        return this.fileLocation;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void parse(BserValues values) throws IOException {
        this.fileLocation = (FileLocation)values.getObj(1, FileLocation.class);
        this.offset = values.getInt(2);
        this.limit = values.getInt(3);
    }

    public void serialize(BserWriter writer) throws IOException {
        if (this.fileLocation == null) {
            throw new IOException();
        }
        writer.writeObject(1, (BserObject)this.fileLocation);
        writer.writeInt(2, this.offset);
        writer.writeInt(3, this.limit);
    }

    @Override
    public int getHeaderKey() {
        return 16;
    }
}

