/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.dbip.api;

public final class GeoEntity {
    private final String city;
    private final String country;
    private final String province;
    private final String countryCode;

    public GeoEntity(Builder builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.province = builder.province;
        this.countryCode = builder.countryCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getProvince() {
        return this.province;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String toString() {
        return "GeoEntity{city='" + this.city + '\'' + ", country='" + this.country + '\'' + ", province='" + this.province + '\'' + ", countryCode='" + this.countryCode + '\'' + '}';
    }

    public static class Builder {
        private String countryCode;
        private String city;
        private String country;
        private String province;

        public Builder withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        public Builder withCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder withProvince(String province) {
            this.province = province;
            return this;
        }

        public GeoEntity build() {
            return new GeoEntity(this);
        }
    }
}

