/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.core.reflection;

import io.contextmap.core.reflection.ObjectToJsonConverter;
import io.contextmap.core.reflection.Property;
import io.contextmap.model.json.ScannedJsonNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class SwaggerV3 {
    private final ObjectToJsonConverter.ObjectToJsonReflection reflectionService;

    public SwaggerV3(ObjectToJsonConverter.ObjectToJsonReflection reflectionService) {
        this.reflectionService = reflectionService;
    }

    public boolean enrichWithSchemaAnnotationIfAvailable(Class<?> type, ScannedJsonNode propertyJsonNode) {
        String annotationFQN = "io.swagger.v3.oas.annotations.media.Schema";
        Optional<Annotation> annotation = this.reflectionService.getAnnotation(type, annotationFQN);
        if (annotation.isPresent()) {
            this.reflectionService.getAnnotationFieldValue(annotation.get(), "description").filter(str -> !((String)str).isEmpty()).ifPresent(description -> propertyJsonNode.setDescription((String)description));
            if (propertyJsonNode.getDescription() == null || propertyJsonNode.getDescription().isEmpty()) {
                this.reflectionService.getAnnotationFieldValue(annotation.get(), "title").filter(str -> !((String)str).isEmpty()).ifPresent(description -> propertyJsonNode.setDescription((String)description));
            }
            this.reflectionService.getAnnotationFieldValue(annotation.get(), "example").filter(str -> !((String)str).isEmpty()).ifPresent(example -> propertyJsonNode.setExample((String)example));
            return true;
        }
        return false;
    }

    public boolean enrichWithSchemaAnnotationIfAvailable(Property property, Function<Property, Method> methodToCheck, ScannedJsonNode propertyJsonNode) {
        Optional<Annotation> annotation;
        String annotationFQN = "io.swagger.v3.oas.annotations.media.Schema";
        Method method = methodToCheck.apply(property);
        Consumer<Annotation> enricher = ann -> {
            this.reflectionService.getAnnotationFieldValue((Annotation)ann, "description").filter(str -> !((String)str).isEmpty()).ifPresent(description -> propertyJsonNode.setDescription((String)description));
            if (propertyJsonNode.getDescription() == null || propertyJsonNode.getDescription().isEmpty()) {
                this.reflectionService.getAnnotationFieldValue((Annotation)ann, "title").filter(str -> !((String)str).isEmpty()).ifPresent(description -> propertyJsonNode.setDescription((String)description));
            }
            this.reflectionService.getAnnotationFieldValue((Annotation)ann, "example").filter(str -> !((String)str).isEmpty()).ifPresent(example -> propertyJsonNode.setExample((String)example));
        };
        if (method != null && (annotation = this.reflectionService.getAnnotation(method, annotationFQN)).isPresent()) {
            enricher.accept(annotation.get());
            return true;
        }
        if (property.getField() != null && (annotation = this.reflectionService.getAnnotation(property.getField(), annotationFQN)).isPresent()) {
            enricher.accept(annotation.get());
            return true;
        }
        return false;
    }
}

