/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.core.reflection;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class PrimitiveChecker {
    private static Set<String> numberPrimitives = new HashSet<String>(Arrays.asList(Integer.class.getName(), Integer.TYPE.getName(), Long.class.getName(), Long.TYPE.getName(), Byte.class.getName(), Byte.TYPE.getName(), Short.class.getName(), Short.TYPE.getName(), Float.class.getName(), Float.TYPE.getName(), Double.class.getName(), Double.TYPE.getName(), BigDecimal.class.getName(), BigInteger.class.getName()));
    private static Set<String> booleanPrimitives = new HashSet<String>(Arrays.asList(Boolean.class.getName(), Boolean.TYPE.getName()));
    private static Set<String> stringPrimitives = new HashSet<String>(Arrays.asList(String.class.getName(), UUID.class.getName(), Character.class.getName(), Character.TYPE.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName(), LocalDateTime.class.getName(), LocalDate.class.getName(), LocalTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetTime.class.getName(), DayOfWeek.class.getName(), OffsetDateTime.class.getName(), Duration.class.getName(), Instant.class.getName(), ZonedDateTime.class.getName()));

    public static boolean isStringPrimitive(String typeName) {
        return stringPrimitives.contains(typeName);
    }

    public static boolean isNumberPrimitive(String typeName) {
        return numberPrimitives.contains(typeName);
    }

    public static boolean isBooleanPrimitive(String typeName) {
        return booleanPrimitives.contains(typeName);
    }

    public static boolean isPrimitive(Class<?> type) {
        if (type.isEnum()) {
            return true;
        }
        HashSet<String> primitiveTypes = new HashSet<String>();
        primitiveTypes.addAll(stringPrimitives);
        primitiveTypes.addAll(numberPrimitives);
        primitiveTypes.addAll(booleanPrimitives);
        return primitiveTypes.contains(type.getName());
    }
}

