/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC27")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="GRPS0027")
public class ArrayCopyCheck
extends IssuableSubscriptionVisitor {
    protected static final String MESSAGERULE = "Use System.arraycopy to copy arrays";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        List<Bloc> blocs = this.getBlocsOfCode(tree);
        for (Bloc bloc : blocs) {
            if (bloc.isForeach()) {
                this.handleForEachAssignments(tree, bloc);
            }
            this.handleAssignments(tree, bloc);
        }
    }

    private void handleForEachAssignments(Tree tree, Bloc bloc) {
        for (AssignmentExpressionTree assignment : this.extractAssignments(tree, bloc)) {
            ExpressionTree destination = assignment.variable();
            ExpressionTree source = assignment.expression();
            if (!this.isArray(destination) || !this.isVariable(source)) continue;
            String destinationIdentifier = this.getArrayIdentifier(destination);
            String sourceIdentifier = ((IdentifierTree)source).name();
            if (!bloc.getValue().equals(sourceIdentifier) || bloc.getIterable().equals(destinationIdentifier)) continue;
            this.reportIssue(tree, MESSAGERULE);
        }
    }

    private void handleAssignments(Tree tree, Bloc bloc) {
        for (AssignmentExpressionTree assignment : this.extractAssignments(tree, bloc)) {
            ExpressionTree destVariable = assignment.variable();
            ExpressionTree srcEspression = assignment.expression();
            if (!this.isArray(destVariable) || !this.isArray(srcEspression)) continue;
            String destArray = this.getArrayIdentifier(destVariable);
            String srcArray = this.getArrayIdentifier(srcEspression);
            if (destArray == null || destArray.equals(srcArray)) continue;
            this.reportIssue(tree, MESSAGERULE);
        }
    }

    private String getArrayIdentifier(ExpressionTree expression) {
        ExpressionTree identifier;
        if (expression instanceof ArrayAccessExpressionTree && (identifier = ((ArrayAccessExpressionTree)expression).expression()) instanceof IdentifierTree) {
            return ((IdentifierTree)identifier).identifierToken().text();
        }
        return null;
    }

    private boolean isArray(ExpressionTree expression) {
        return expression instanceof ArrayAccessExpressionTree;
    }

    private boolean isVariable(ExpressionTree source) {
        return source instanceof IdentifierTree;
    }

    private List<Bloc> getBlocsOfCode(Tree tree) {
        ArrayList<Bloc> blocs = new ArrayList<Bloc>();
        if (tree instanceof ForStatementTree) {
            ForStatementTree castedForTree = (ForStatementTree)tree;
            this.addBloc(blocs, castedForTree.statement());
        } else if (tree instanceof ForEachStatement) {
            ForEachStatement castedForEachTree = (ForEachStatement)tree;
            this.addForEachBloc(blocs, castedForEachTree.statement(), castedForEachTree.variable(), castedForEachTree.expression());
        } else if (tree instanceof WhileStatementTree) {
            WhileStatementTree castedWhileTree = (WhileStatementTree)tree;
            this.addBloc(blocs, castedWhileTree.statement());
        } else if (tree instanceof DoWhileStatementTree) {
            DoWhileStatementTree castedDoWhileTree = (DoWhileStatementTree)tree;
            this.addBloc(blocs, castedDoWhileTree.statement());
        } else if (tree instanceof IfStatementTree) {
            IfStatementTree castedIfTree = (IfStatementTree)tree;
            this.addBloc(blocs, castedIfTree.thenStatement());
            this.addBloc(blocs, castedIfTree.elseStatement());
        } else if (tree instanceof TryStatementTree) {
            TryStatementTree tryTree = (TryStatementTree)tree;
            this.addBloc(blocs, new StatementTree[]{tryTree.block()});
            this.addBloc(blocs, (StatementTree[])this.extractCatchBlocks(tryTree));
            this.addBloc(blocs, new StatementTree[]{tryTree.finallyBlock()});
        }
        return blocs;
    }

    private List<AssignmentExpressionTree> extractAssignments(Tree tree, Bloc bloc) {
        BlockTree block = bloc.getBlockTree();
        Predicate<StatementTree> blocksPredicate = statement -> statement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) || statement.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT});
        Predicate<StatementTree> assignmentPredicate = statement -> statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && ((ExpressionStatementTree)statement).expression().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT});
        List<AssignmentExpressionTree> result = block.body().stream().filter(assignmentPredicate).map(assign -> (AssignmentExpressionTree)((ExpressionStatementTree)assign).expression()).collect(Collectors.toList());
        List ifStatements = block.body().stream().filter(blocksPredicate).collect(Collectors.toList());
        for (StatementTree ifstatement : ifStatements) {
            List<Bloc> blocs = this.getBlocsOfCode((Tree)ifstatement);
            for (Bloc b : blocs) {
                result.addAll(this.extractAssignments(tree, b));
            }
        }
        return result;
    }

    private BlockTree[] extractCatchBlocks(TryStatementTree tryTree) {
        List catches = tryTree.catches();
        return catches.stream().map(CatchTree::block).collect(Collectors.toList()).toArray(new BlockTree[0]);
    }

    private void addBloc(List<Bloc> blocs, StatementTree ... statements) {
        for (StatementTree statement : statements) {
            if (!(statement instanceof BlockTree)) continue;
            blocs.add(new Bloc((BlockTree)statement));
        }
    }

    private void addForEachBloc(List<Bloc> blocs, StatementTree statement, VariableTree variable, ExpressionTree expression) {
        if (statement instanceof BlockTree && expression instanceof IdentifierTree) {
            blocs.add(new Bloc((BlockTree)statement, ((IdentifierTree)expression).identifierToken().text(), variable.simpleName().identifierToken().text()));
        }
    }

    private static class Bloc {
        private final BlockTree blockTree;
        private String iterable;
        private String value;

        public Bloc(BlockTree blockTree, String iterable, String value) {
            this.blockTree = blockTree;
            this.iterable = iterable;
            this.value = value;
        }

        public boolean isForeach() {
            return this.iterable != null && this.value != null;
        }

        public Bloc(BlockTree blockTree) {
            this.blockTree = blockTree;
        }

        public BlockTree getBlockTree() {
            return this.blockTree;
        }

        public String getIterable() {
            return this.iterable;
        }

        public String getValue() {
            return this.value;
        }
    }
}

